<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Devisenkurs StructType
 * Meta information extracted from the WSDL
 * - documentation: Der Umrechnungskurs von einer Währung in eine andere Währung.
 * @subpackage Structs
 */
class CT_Devisenkurs extends CT_Objekt
{
    /**
     * The Ausgangswaehrung
     * Meta information extracted from the WSDL
     * - documentation: Ausgangswährung der Währungsumrechnung.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Ausgangswaehrung;
    /**
     * The Zielwaehrung
     * Meta information extracted from the WSDL
     * - documentation: Zielwährung der Währungsumrechnung.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Zielwaehrung;
    /**
     * The Kurs
     * Meta information extracted from the WSDL
     * - documentation: Der Kurs, der zum Zeitpunkt für die Umrechnung der Ausgangswährung in die Zielwährung gültig ist.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kurs;
    /**
     * The Zeitpunkt
     * Meta information extracted from the WSDL
     * - documentation: Der Zeitpunkt, zu dem der Umrechnungskurs gültig ist. | wie ST_Datum, ergänzt um Stunden und Minuten
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]
     * @var string
     */
    public $Zeitpunkt;
    /**
     * Constructor method for CT_Devisenkurs
     * @uses CT_Devisenkurs::setAusgangswaehrung()
     * @uses CT_Devisenkurs::setZielwaehrung()
     * @uses CT_Devisenkurs::setKurs()
     * @uses CT_Devisenkurs::setZeitpunkt()
     * @param string $ausgangswaehrung
     * @param string $zielwaehrung
     * @param float $kurs
     * @param string $zeitpunkt
     */
    public function __construct($ausgangswaehrung = null, $zielwaehrung = null, $kurs = null, $zeitpunkt = null)
    {
        $this
            ->setAusgangswaehrung($ausgangswaehrung)
            ->setZielwaehrung($zielwaehrung)
            ->setKurs($kurs)
            ->setZeitpunkt($zeitpunkt);
    }
    /**
     * Get Ausgangswaehrung value
     * @return string
     */
    public function getAusgangswaehrung()
    {
        return $this->Ausgangswaehrung;
    }
    /**
     * Set Ausgangswaehrung value
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ausgangswaehrung
     * @return \BiPRO\StructType\CT_Devisenkurs
     */
    public function setAusgangswaehrung($ausgangswaehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid($ausgangswaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Waehrungsschluessel', is_array($ausgangswaehrung) ? implode(', ', $ausgangswaehrung) : var_export($ausgangswaehrung, true), implode(', ', \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues())), __LINE__);
        }
        $this->Ausgangswaehrung = $ausgangswaehrung;
        return $this;
    }
    /**
     * Get Zielwaehrung value
     * @return string
     */
    public function getZielwaehrung()
    {
        return $this->Zielwaehrung;
    }
    /**
     * Set Zielwaehrung value
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zielwaehrung
     * @return \BiPRO\StructType\CT_Devisenkurs
     */
    public function setZielwaehrung($zielwaehrung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Waehrungsschluessel::valueIsValid($zielwaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Waehrungsschluessel', is_array($zielwaehrung) ? implode(', ', $zielwaehrung) : var_export($zielwaehrung, true), implode(', ', \BiPRO\EnumType\ST_Waehrungsschluessel::getValidValues())), __LINE__);
        }
        $this->Zielwaehrung = $zielwaehrung;
        return $this;
    }
    /**
     * Get Kurs value
     * @return float
     */
    public function getKurs()
    {
        return $this->Kurs;
    }
    /**
     * Set Kurs value
     * @param float $kurs
     * @return \BiPRO\StructType\CT_Devisenkurs
     */
    public function setKurs($kurs = null)
    {
        // validation for constraint: float
        if (!is_null($kurs) && !(is_float($kurs) || is_numeric($kurs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kurs, true), gettype($kurs)), __LINE__);
        }
        $this->Kurs = $kurs;
        return $this;
    }
    /**
     * Get Zeitpunkt value
     * @return string
     */
    public function getZeitpunkt()
    {
        return $this->Zeitpunkt;
    }
    /**
     * Set Zeitpunkt value
     * @param string $zeitpunkt
     * @return \BiPRO\StructType\CT_Devisenkurs
     */
    public function setZeitpunkt($zeitpunkt = null)
    {
        // validation for constraint: string
        if (!is_null($zeitpunkt) && !is_string($zeitpunkt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zeitpunkt, true), gettype($zeitpunkt)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9])
        if (!is_null($zeitpunkt) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]/', $zeitpunkt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]', var_export($zeitpunkt, true)), __LINE__);
        }
        $this->Zeitpunkt = $zeitpunkt;
        return $this;
    }
}
