<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Datei StructType
 * Meta information extracted from the WSDL
 * - documentation: Container-Objekt fuer zu uebertragende Dateien.
 * @subpackage Structs
 */
class CT_Datei extends CT_Objekt
{
    /**
     * The Komprimierungstyp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Komprimierungstyp;
    /**
     * The DateiID
     * Meta information extracted from the WSDL
     * - documentation: Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateiID;
    /**
     * The Dateiname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Dateiname;
    /**
     * The Dateityp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dateityp;
    /**
     * The Daten
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\Base64Binary
     */
    public $Daten;
    /**
     * The Datenlink
     * Meta information extracted from the WSDL
     * - documentation: Zur Übergabe einer Internet-URL.
     * - base: xsd:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Datenlink;
    /**
     * The Erstelldatum
     * Meta information extracted from the WSDL
     * - documentation: Zeitpunkt der Erstellung der Datei | wie ST_DatumZeit ergänzt um Sekunden
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]
     * @var string
     */
    public $Erstelldatum;
    /**
     * The DokumentartID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DokumentartID;
    /**
     * The Kurzbeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Attribut, um die Datei in wenigen Worten inhaltlich zu beschreiben. Sinnvoll nutzbar z. B. in Anwendungsfällen, bei denen die Datei in einem Dokumentenmanagement abgelegt wird. In diesen Fällen kann der Inhalt der Datei bzw. des
     * Dokumentes über die Kurzbeschreibung und damit über die reine DokumentartID hinaus kurz beschrieben und beispielweise in Form eines Tooltipps oder einer Betreffzeile eingeblendet werden. Das Attribut DokumenartID alleine ist nicht geeignet für die
     * Abbildung, da sich Dokumenteninhalte trotz übereinstimmender Dokumentenarten in einigen Szenarien inhaltlich unterscheiden können. Empfehlung formulieren, dass ein Service Provider die Beschreibung füllen soll.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Kurzbeschreibung;
    /**
     * The Bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Vollständiger Titel wie er auf dem Dokument erscheint
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Bezeichnung;
    /**
     * The Dateikennung
     * Meta information extracted from the WSDL
     * - documentation: Interne Refernz im Prozess beim Provider.
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Dateikennung;
    /**
     * The Pruefsumme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Pruefsumme
     */
    public $Pruefsumme;
    /**
     * The Vertraulich
     * Meta information extracted from the WSDL
     * - documentation: Status zur Vertraulichkeit der Datei. Das Attribut DARF NUR nur befüllt werden, wenn eine besondere Vereinbarung zwischen Consumer und Provider vorliegt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vertraulich;
    /**
     * The IstEingangspost
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichnung, ob es sich bei diesem Dokument aus Sicht des Providers um Eingangs- oder Ausgangspost handelt.Ja=EingangspostNein=Ausgangspost
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $IstEingangspost;
    /**
     * The Quelle
     * Meta information extracted from the WSDL
     * - documentation: Partner, der der Ersteller dieser Datei ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Quelle
     */
    public $Quelle;
    /**
     * Constructor method for CT_Datei
     * @uses CT_Datei::setKomprimierungstyp()
     * @uses CT_Datei::setDateiID()
     * @uses CT_Datei::setDateiname()
     * @uses CT_Datei::setDateityp()
     * @uses CT_Datei::setDaten()
     * @uses CT_Datei::setDatenlink()
     * @uses CT_Datei::setErstelldatum()
     * @uses CT_Datei::setDokumentartID()
     * @uses CT_Datei::setKurzbeschreibung()
     * @uses CT_Datei::setBezeichnung()
     * @uses CT_Datei::setDateikennung()
     * @uses CT_Datei::setPruefsumme()
     * @uses CT_Datei::setVertraulich()
     * @uses CT_Datei::setIstEingangspost()
     * @uses CT_Datei::setQuelle()
     * @param string $komprimierungstyp
     * @param string $dateiID
     * @param string $dateiname
     * @param string $dateityp
     * @param \BiPRO\StructType\Base64Binary $daten
     * @param string $datenlink
     * @param string $erstelldatum
     * @param string[] $dokumentartID
     * @param string $kurzbeschreibung
     * @param string $bezeichnung
     * @param string $dateikennung
     * @param \BiPRO\StructType\CT_Pruefsumme $pruefsumme
     * @param string $vertraulich
     * @param bool $istEingangspost
     * @param \BiPRO\StructType\CT_Quelle $quelle
     */
    public function __construct($komprimierungstyp = null, $dateiID = null, $dateiname = null, $dateityp = null, \BiPRO\StructType\Base64Binary $daten = null, $datenlink = null, $erstelldatum = null, array $dokumentartID = array(), $kurzbeschreibung = null, $bezeichnung = null, $dateikennung = null, \BiPRO\StructType\CT_Pruefsumme $pruefsumme = null, $vertraulich = null, $istEingangspost = null, \BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this
            ->setKomprimierungstyp($komprimierungstyp)
            ->setDateiID($dateiID)
            ->setDateiname($dateiname)
            ->setDateityp($dateityp)
            ->setDaten($daten)
            ->setDatenlink($datenlink)
            ->setErstelldatum($erstelldatum)
            ->setDokumentartID($dokumentartID)
            ->setKurzbeschreibung($kurzbeschreibung)
            ->setBezeichnung($bezeichnung)
            ->setDateikennung($dateikennung)
            ->setPruefsumme($pruefsumme)
            ->setVertraulich($vertraulich)
            ->setIstEingangspost($istEingangspost)
            ->setQuelle($quelle);
    }
    /**
     * Get Komprimierungstyp value
     * @return string
     */
    public function getKomprimierungstyp()
    {
        return $this->Komprimierungstyp;
    }
    /**
     * Set Komprimierungstyp value
     * @uses \BiPRO\EnumType\ST_Komprimierungstyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Komprimierungstyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $komprimierungstyp
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setKomprimierungstyp($komprimierungstyp = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Komprimierungstyp::valueIsValid($komprimierungstyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Komprimierungstyp', is_array($komprimierungstyp) ? implode(', ', $komprimierungstyp) : var_export($komprimierungstyp, true), implode(', ', \BiPRO\EnumType\ST_Komprimierungstyp::getValidValues())), __LINE__);
        }
        $this->Komprimierungstyp = $komprimierungstyp;
        return $this;
    }
    /**
     * Get DateiID value
     * @return string|null
     */
    public function getDateiID()
    {
        return $this->DateiID;
    }
    /**
     * Set DateiID value
     * @param string $dateiID
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setDateiID($dateiID = null)
    {
        // validation for constraint: string
        if (!is_null($dateiID) && !is_string($dateiID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateiID, true), gettype($dateiID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dateiID) && mb_strlen($dateiID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dateiID)), __LINE__);
        }
        $this->DateiID = $dateiID;
        return $this;
    }
    /**
     * Get Dateiname value
     * @return string|null
     */
    public function getDateiname()
    {
        return $this->Dateiname;
    }
    /**
     * Set Dateiname value
     * @param string $dateiname
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setDateiname($dateiname = null)
    {
        // validation for constraint: string
        if (!is_null($dateiname) && !is_string($dateiname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateiname, true), gettype($dateiname)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($dateiname) && mb_strlen($dateiname) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($dateiname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($dateiname) && mb_strlen($dateiname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($dateiname)), __LINE__);
        }
        $this->Dateiname = $dateiname;
        return $this;
    }
    /**
     * Get Dateityp value
     * @return string|null
     */
    public function getDateityp()
    {
        return $this->Dateityp;
    }
    /**
     * Set Dateityp value
     * @uses \BiPRO\EnumType\ST_Dateityp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Dateityp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateityp
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setDateityp($dateityp = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Dateityp::valueIsValid($dateityp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Dateityp', is_array($dateityp) ? implode(', ', $dateityp) : var_export($dateityp, true), implode(', ', \BiPRO\EnumType\ST_Dateityp::getValidValues())), __LINE__);
        }
        $this->Dateityp = $dateityp;
        return $this;
    }
    /**
     * Get Daten value
     * @return \BiPRO\StructType\Base64Binary|null
     */
    public function getDaten()
    {
        return $this->Daten;
    }
    /**
     * Set Daten value
     * @param \BiPRO\StructType\Base64Binary $daten
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setDaten(\BiPRO\StructType\Base64Binary $daten = null)
    {
        $this->Daten = $daten;
        return $this;
    }
    /**
     * Get Datenlink value
     * @return string|null
     */
    public function getDatenlink()
    {
        return $this->Datenlink;
    }
    /**
     * Set Datenlink value
     * @param string $datenlink
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setDatenlink($datenlink = null)
    {
        // validation for constraint: string
        if (!is_null($datenlink) && !is_string($datenlink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datenlink, true), gettype($datenlink)), __LINE__);
        }
        $this->Datenlink = $datenlink;
        return $this;
    }
    /**
     * Get Erstelldatum value
     * @return string|null
     */
    public function getErstelldatum()
    {
        return $this->Erstelldatum;
    }
    /**
     * Set Erstelldatum value
     * @param string $erstelldatum
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setErstelldatum($erstelldatum = null)
    {
        // validation for constraint: string
        if (!is_null($erstelldatum) && !is_string($erstelldatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erstelldatum, true), gettype($erstelldatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9])
        if (!is_null($erstelldatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]/', $erstelldatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]', var_export($erstelldatum, true)), __LINE__);
        }
        $this->Erstelldatum = $erstelldatum;
        return $this;
    }
    /**
     * Get DokumentartID value
     * @return string[]|null
     */
    public function getDokumentartID()
    {
        return $this->DokumentartID;
    }
    /**
     * This method is responsible for validating the values passed to the setDokumentartID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDokumentartID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDokumentartIDForArrayConstraintsFromSetDokumentartID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_DateiDokumentartIDItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_DokumentartID::valueIsValid($cT_DateiDokumentartIDItem)) {
                $invalidValues[] = is_object($cT_DateiDokumentartIDItem) ? get_class($cT_DateiDokumentartIDItem) : sprintf('%s(%s)', gettype($cT_DateiDokumentartIDItem), var_export($cT_DateiDokumentartIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DokumentartID', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_DokumentartID::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DokumentartID value
     * @uses \BiPRO\EnumType\ST_DokumentartID::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DokumentartID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $dokumentartID
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setDokumentartID(array $dokumentartID = array())
    {
        // validation for constraint: array
        if ('' !== ($dokumentartIDArrayErrorMessage = self::validateDokumentartIDForArrayConstraintsFromSetDokumentartID($dokumentartID))) {
            throw new \InvalidArgumentException($dokumentartIDArrayErrorMessage, __LINE__);
        }
        $this->DokumentartID = $dokumentartID;
        return $this;
    }
    /**
     * Add item to DokumentartID value
     * @uses \BiPRO\EnumType\ST_DokumentartID::valueIsValid()
     * @uses \BiPRO\EnumType\ST_DokumentartID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Datei
     */
    public function addToDokumentartID($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_DokumentartID::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_DokumentartID', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_DokumentartID::getValidValues())), __LINE__);
        }
        $this->DokumentartID[] = $item;
        return $this;
    }
    /**
     * Get Kurzbeschreibung value
     * @return string|null
     */
    public function getKurzbeschreibung()
    {
        return $this->Kurzbeschreibung;
    }
    /**
     * Set Kurzbeschreibung value
     * @param string $kurzbeschreibung
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setKurzbeschreibung($kurzbeschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($kurzbeschreibung) && !is_string($kurzbeschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kurzbeschreibung, true), gettype($kurzbeschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kurzbeschreibung) && mb_strlen($kurzbeschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kurzbeschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kurzbeschreibung) && mb_strlen($kurzbeschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kurzbeschreibung)), __LINE__);
        }
        $this->Kurzbeschreibung = $kurzbeschreibung;
        return $this;
    }
    /**
     * Get Bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->Bezeichnung;
    }
    /**
     * Set Bezeichnung value
     * @param string $bezeichnung
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->Bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get Dateikennung value
     * @return string|null
     */
    public function getDateikennung()
    {
        return $this->Dateikennung;
    }
    /**
     * Set Dateikennung value
     * @param string $dateikennung
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setDateikennung($dateikennung = null)
    {
        // validation for constraint: string
        if (!is_null($dateikennung) && !is_string($dateikennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateikennung, true), gettype($dateikennung)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($dateikennung) && mb_strlen($dateikennung) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($dateikennung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($dateikennung) && mb_strlen($dateikennung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($dateikennung)), __LINE__);
        }
        $this->Dateikennung = $dateikennung;
        return $this;
    }
    /**
     * Get Pruefsumme value
     * @return \BiPRO\StructType\CT_Pruefsumme|null
     */
    public function getPruefsumme()
    {
        return $this->Pruefsumme;
    }
    /**
     * Set Pruefsumme value
     * @param \BiPRO\StructType\CT_Pruefsumme $pruefsumme
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setPruefsumme(\BiPRO\StructType\CT_Pruefsumme $pruefsumme = null)
    {
        $this->Pruefsumme = $pruefsumme;
        return $this;
    }
    /**
     * Get Vertraulich value
     * @return string|null
     */
    public function getVertraulich()
    {
        return $this->Vertraulich;
    }
    /**
     * Set Vertraulich value
     * @uses \BiPRO\EnumType\ST_Vertraulich::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Vertraulich::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vertraulich
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setVertraulich($vertraulich = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Vertraulich::valueIsValid($vertraulich)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Vertraulich', is_array($vertraulich) ? implode(', ', $vertraulich) : var_export($vertraulich, true), implode(', ', \BiPRO\EnumType\ST_Vertraulich::getValidValues())), __LINE__);
        }
        $this->Vertraulich = $vertraulich;
        return $this;
    }
    /**
     * Get IstEingangspost value
     * @return bool|null
     */
    public function getIstEingangspost()
    {
        return $this->IstEingangspost;
    }
    /**
     * Set IstEingangspost value
     * @param bool $istEingangspost
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setIstEingangspost($istEingangspost = null)
    {
        // validation for constraint: boolean
        if (!is_null($istEingangspost) && !is_bool($istEingangspost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($istEingangspost, true), gettype($istEingangspost)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($istEingangspost) && !preg_match('/true|false/', $istEingangspost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($istEingangspost, true)), __LINE__);
        }
        $this->IstEingangspost = $istEingangspost;
        return $this;
    }
    /**
     * Get Quelle value
     * @return \BiPRO\StructType\CT_Quelle|null
     */
    public function getQuelle()
    {
        return $this->Quelle;
    }
    /**
     * Set Quelle value
     * @param \BiPRO\StructType\CT_Quelle $quelle
     * @return \BiPRO\StructType\CT_Datei
     */
    public function setQuelle(\BiPRO\StructType\CT_Quelle $quelle = null)
    {
        $this->Quelle = $quelle;
        return $this;
    }
}
