<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_CampingKfz StructType
 * Meta information extracted from the WSDL
 * - documentation: WKZ 127
 * @subpackage Structs
 */
class CT_CampingKfz extends CT_Fahrzeug
{
    /**
     * The ZulaessigesGesamtgewicht
     * Meta information extracted from the WSDL
     * - documentation: Zulässiges Gesamtgewicht in kg.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ZulaessigesGesamtgewicht;
    /**
     * The CampingKfzNutzung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_CampingKfzNutzung
     */
    public $CampingKfzNutzung;
    /**
     * The ArtDerZulassungBeimVorbesitzer
     * Meta information extracted from the WSDL
     * - documentation: Art der Zulassung beim direkten Vorbesitzer des aktuellen Besitzers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtDerZulassungBeimVorbesitzer;
    /**
     * The Dachmaterial
     * Meta information extracted from the WSDL
     * - documentation: Material des Fahrzeugdaches.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Dachmaterial;
    /**
     * The Aufbauten
     * Meta information extracted from the WSDL
     * - documentation: Aufbau eines CampingKfz.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aufbauten;
    /**
     * The AufbautenHersteller
     * Meta information extracted from the WSDL
     * - documentation: Hersteller des Aufbaus eines CampingKfz.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AufbautenHersteller;
    /**
     * Constructor method for CT_CampingKfz
     * @uses CT_CampingKfz::setZulaessigesGesamtgewicht()
     * @uses CT_CampingKfz::setCampingKfzNutzung()
     * @uses CT_CampingKfz::setArtDerZulassungBeimVorbesitzer()
     * @uses CT_CampingKfz::setDachmaterial()
     * @uses CT_CampingKfz::setAufbauten()
     * @uses CT_CampingKfz::setAufbautenHersteller()
     * @param float $zulaessigesGesamtgewicht
     * @param \BiPRO\StructType\CT_CampingKfzNutzung $campingKfzNutzung
     * @param string $artDerZulassungBeimVorbesitzer
     * @param string $dachmaterial
     * @param string $aufbauten
     * @param string $aufbautenHersteller
     */
    public function __construct($zulaessigesGesamtgewicht = null, \BiPRO\StructType\CT_CampingKfzNutzung $campingKfzNutzung = null, $artDerZulassungBeimVorbesitzer = null, $dachmaterial = null, $aufbauten = null, $aufbautenHersteller = null)
    {
        $this
            ->setZulaessigesGesamtgewicht($zulaessigesGesamtgewicht)
            ->setCampingKfzNutzung($campingKfzNutzung)
            ->setArtDerZulassungBeimVorbesitzer($artDerZulassungBeimVorbesitzer)
            ->setDachmaterial($dachmaterial)
            ->setAufbauten($aufbauten)
            ->setAufbautenHersteller($aufbautenHersteller);
    }
    /**
     * Get ZulaessigesGesamtgewicht value
     * @return float|null
     */
    public function getZulaessigesGesamtgewicht()
    {
        return $this->ZulaessigesGesamtgewicht;
    }
    /**
     * Set ZulaessigesGesamtgewicht value
     * @param float $zulaessigesGesamtgewicht
     * @return \BiPRO\StructType\CT_CampingKfz
     */
    public function setZulaessigesGesamtgewicht($zulaessigesGesamtgewicht = null)
    {
        // validation for constraint: float
        if (!is_null($zulaessigesGesamtgewicht) && !(is_float($zulaessigesGesamtgewicht) || is_numeric($zulaessigesGesamtgewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zulaessigesGesamtgewicht, true), gettype($zulaessigesGesamtgewicht)), __LINE__);
        }
        $this->ZulaessigesGesamtgewicht = $zulaessigesGesamtgewicht;
        return $this;
    }
    /**
     * Get CampingKfzNutzung value
     * @return \BiPRO\StructType\CT_CampingKfzNutzung|null
     */
    public function getCampingKfzNutzung()
    {
        return $this->CampingKfzNutzung;
    }
    /**
     * Set CampingKfzNutzung value
     * @param \BiPRO\StructType\CT_CampingKfzNutzung $campingKfzNutzung
     * @return \BiPRO\StructType\CT_CampingKfz
     */
    public function setCampingKfzNutzung(\BiPRO\StructType\CT_CampingKfzNutzung $campingKfzNutzung = null)
    {
        $this->CampingKfzNutzung = $campingKfzNutzung;
        return $this;
    }
    /**
     * Get ArtDerZulassungBeimVorbesitzer value
     * @return string|null
     */
    public function getArtDerZulassungBeimVorbesitzer()
    {
        return $this->ArtDerZulassungBeimVorbesitzer;
    }
    /**
     * Set ArtDerZulassungBeimVorbesitzer value
     * @uses \BiPRO\EnumType\ST_ArtDerZulassung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtDerZulassung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artDerZulassungBeimVorbesitzer
     * @return \BiPRO\StructType\CT_CampingKfz
     */
    public function setArtDerZulassungBeimVorbesitzer($artDerZulassungBeimVorbesitzer = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtDerZulassung::valueIsValid($artDerZulassungBeimVorbesitzer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtDerZulassung', is_array($artDerZulassungBeimVorbesitzer) ? implode(', ', $artDerZulassungBeimVorbesitzer) : var_export($artDerZulassungBeimVorbesitzer, true), implode(', ', \BiPRO\EnumType\ST_ArtDerZulassung::getValidValues())), __LINE__);
        }
        $this->ArtDerZulassungBeimVorbesitzer = $artDerZulassungBeimVorbesitzer;
        return $this;
    }
    /**
     * Get Dachmaterial value
     * @return string|null
     */
    public function getDachmaterial()
    {
        return $this->Dachmaterial;
    }
    /**
     * Set Dachmaterial value
     * @uses \BiPRO\EnumType\ST_Fahrzeugdachmaterial::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fahrzeugdachmaterial::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dachmaterial
     * @return \BiPRO\StructType\CT_CampingKfz
     */
    public function setDachmaterial($dachmaterial = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fahrzeugdachmaterial::valueIsValid($dachmaterial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fahrzeugdachmaterial', is_array($dachmaterial) ? implode(', ', $dachmaterial) : var_export($dachmaterial, true), implode(', ', \BiPRO\EnumType\ST_Fahrzeugdachmaterial::getValidValues())), __LINE__);
        }
        $this->Dachmaterial = $dachmaterial;
        return $this;
    }
    /**
     * Get Aufbauten value
     * @return string|null
     */
    public function getAufbauten()
    {
        return $this->Aufbauten;
    }
    /**
     * Set Aufbauten value
     * @uses \BiPRO\EnumType\ST_AufbautenCampingKfz::valueIsValid()
     * @uses \BiPRO\EnumType\ST_AufbautenCampingKfz::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $aufbauten
     * @return \BiPRO\StructType\CT_CampingKfz
     */
    public function setAufbauten($aufbauten = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_AufbautenCampingKfz::valueIsValid($aufbauten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_AufbautenCampingKfz', is_array($aufbauten) ? implode(', ', $aufbauten) : var_export($aufbauten, true), implode(', ', \BiPRO\EnumType\ST_AufbautenCampingKfz::getValidValues())), __LINE__);
        }
        $this->Aufbauten = $aufbauten;
        return $this;
    }
    /**
     * Get AufbautenHersteller value
     * @return string|null
     */
    public function getAufbautenHersteller()
    {
        return $this->AufbautenHersteller;
    }
    /**
     * Set AufbautenHersteller value
     * @param string $aufbautenHersteller
     * @return \BiPRO\StructType\CT_CampingKfz
     */
    public function setAufbautenHersteller($aufbautenHersteller = null)
    {
        // validation for constraint: string
        if (!is_null($aufbautenHersteller) && !is_string($aufbautenHersteller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aufbautenHersteller, true), gettype($aufbautenHersteller)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($aufbautenHersteller) && mb_strlen($aufbautenHersteller) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($aufbautenHersteller)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aufbautenHersteller) && mb_strlen($aufbautenHersteller) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aufbautenHersteller)), __LINE__);
        }
        $this->AufbautenHersteller = $aufbautenHersteller;
        return $this;
    }
}
