<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_BusanhaengerZurPersonenbefoerderung StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Abbildung von Busanhängern, die zur Personenbeförderung genutzt werden.
 * @subpackage Structs
 */
class CT_BusanhaengerZurPersonenbefoerderung extends CT_Anhaenger
{
    /**
     * The AnzahlPlaetze
     * Meta information extracted from the WSDL
     * - documentation: Gesamtzahl der Sitz- und Stehplätze.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlPlaetze;
    /**
     * The AnzahlStehplaetze
     * Meta information extracted from the WSDL
     * - documentation: Maximale Anzahl an Stehplätzen.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlStehplaetze;
    /**
     * Constructor method for CT_BusanhaengerZurPersonenbefoerderung
     * @uses CT_BusanhaengerZurPersonenbefoerderung::setAnzahlPlaetze()
     * @uses CT_BusanhaengerZurPersonenbefoerderung::setAnzahlStehplaetze()
     * @param int $anzahlPlaetze
     * @param int $anzahlStehplaetze
     */
    public function __construct($anzahlPlaetze = null, $anzahlStehplaetze = null)
    {
        $this
            ->setAnzahlPlaetze($anzahlPlaetze)
            ->setAnzahlStehplaetze($anzahlStehplaetze);
    }
    /**
     * Get AnzahlPlaetze value
     * @return int|null
     */
    public function getAnzahlPlaetze()
    {
        return $this->AnzahlPlaetze;
    }
    /**
     * Set AnzahlPlaetze value
     * @param int $anzahlPlaetze
     * @return \BiPRO\StructType\CT_BusanhaengerZurPersonenbefoerderung
     */
    public function setAnzahlPlaetze($anzahlPlaetze = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlPlaetze) && !(is_int($anzahlPlaetze) || ctype_digit($anzahlPlaetze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlPlaetze, true), gettype($anzahlPlaetze)), __LINE__);
        }
        $this->AnzahlPlaetze = $anzahlPlaetze;
        return $this;
    }
    /**
     * Get AnzahlStehplaetze value
     * @return int|null
     */
    public function getAnzahlStehplaetze()
    {
        return $this->AnzahlStehplaetze;
    }
    /**
     * Set AnzahlStehplaetze value
     * @param int $anzahlStehplaetze
     * @return \BiPRO\StructType\CT_BusanhaengerZurPersonenbefoerderung
     */
    public function setAnzahlStehplaetze($anzahlStehplaetze = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlStehplaetze) && !(is_int($anzahlStehplaetze) || ctype_digit($anzahlStehplaetze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlStehplaetze, true), gettype($anzahlStehplaetze)), __LINE__);
        }
        $this->AnzahlStehplaetze = $anzahlStehplaetze;
        return $this;
    }
}
