<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_BusNutzung StructType
 * @subpackage Structs
 */
class CT_BusNutzung extends CT_Fahrzeugnutzung
{
    /**
     * The Fahrgebiet
     * Meta information extracted from the WSDL
     * - documentation: Fahrgebiet oder Nutzungsgebiet
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fahrgebiet;
    /**
     * The Verwendung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Verwendung;
    /**
     * Constructor method for CT_BusNutzung
     * @uses CT_BusNutzung::setFahrgebiet()
     * @uses CT_BusNutzung::setVerwendung()
     * @param string $fahrgebiet
     * @param string $verwendung
     */
    public function __construct($fahrgebiet = null, $verwendung = null)
    {
        $this
            ->setFahrgebiet($fahrgebiet)
            ->setVerwendung($verwendung);
    }
    /**
     * Get Fahrgebiet value
     * @return string|null
     */
    public function getFahrgebiet()
    {
        return $this->Fahrgebiet;
    }
    /**
     * Set Fahrgebiet value
     * @uses \BiPRO\EnumType\ST_Fahrgebiet::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fahrgebiet::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fahrgebiet
     * @return \BiPRO\StructType\CT_BusNutzung
     */
    public function setFahrgebiet($fahrgebiet = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fahrgebiet::valueIsValid($fahrgebiet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fahrgebiet', is_array($fahrgebiet) ? implode(', ', $fahrgebiet) : var_export($fahrgebiet, true), implode(', ', \BiPRO\EnumType\ST_Fahrgebiet::getValidValues())), __LINE__);
        }
        $this->Fahrgebiet = $fahrgebiet;
        return $this;
    }
    /**
     * Get Verwendung value
     * @return string|null
     */
    public function getVerwendung()
    {
        return $this->Verwendung;
    }
    /**
     * Set Verwendung value
     * @param string $verwendung
     * @return \BiPRO\StructType\CT_BusNutzung
     */
    public function setVerwendung($verwendung = null)
    {
        // validation for constraint: string
        if (!is_null($verwendung) && !is_string($verwendung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verwendung, true), gettype($verwendung)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($verwendung) && mb_strlen($verwendung) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($verwendung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($verwendung) && mb_strlen($verwendung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($verwendung)), __LINE__);
        }
        $this->Verwendung = $verwendung;
        return $this;
    }
}
