<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Bus StructType
 * @subpackage Structs
 */
class CT_Bus extends CT_Fahrzeug
{
    /**
     * The AnzahlPlaetze
     * Meta information extracted from the WSDL
     * - documentation: Gesamtzahl der Sitz- und Stehplätze
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlPlaetze;
    /**
     * The BusNutzung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_BusNutzung
     */
    public $BusNutzung;
    /**
     * The AnzahlStehplaetze
     * Meta information extracted from the WSDL
     * - documentation: Maximale Anzahl Stehplätze.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlStehplaetze;
    /**
     * The Bauart
     * Meta information extracted from the WSDL
     * - documentation: Bauart des Busses.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bauart;
    /**
     * The IstOberleitungsbus
     * Meta information extracted from the WSDL
     * - documentation: JA = Bus mit Elektromotor(en), der seinen Fahrstrom mittels eines Stromabnehmers aus einer Oberleitung bezieht.NEIN = Sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $IstOberleitungsbus;
    /**
     * The HatSenkrechtGeteilteFrontscheibe
     * Meta information extracted from the WSDL
     * - documentation: Angabe, ob Bus eine senkrecht geteilte Frontscheibe hat.Ja = Bus hat senkrecht geteilte FrontscheibeNein = Sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $HatSenkrechtGeteilteFrontscheibe;
    /**
     * Constructor method for CT_Bus
     * @uses CT_Bus::setAnzahlPlaetze()
     * @uses CT_Bus::setBusNutzung()
     * @uses CT_Bus::setAnzahlStehplaetze()
     * @uses CT_Bus::setBauart()
     * @uses CT_Bus::setIstOberleitungsbus()
     * @uses CT_Bus::setHatSenkrechtGeteilteFrontscheibe()
     * @param int $anzahlPlaetze
     * @param \BiPRO\StructType\CT_BusNutzung $busNutzung
     * @param int $anzahlStehplaetze
     * @param string $bauart
     * @param bool $istOberleitungsbus
     * @param bool $hatSenkrechtGeteilteFrontscheibe
     */
    public function __construct($anzahlPlaetze = null, \BiPRO\StructType\CT_BusNutzung $busNutzung = null, $anzahlStehplaetze = null, $bauart = null, $istOberleitungsbus = null, $hatSenkrechtGeteilteFrontscheibe = null)
    {
        $this
            ->setAnzahlPlaetze($anzahlPlaetze)
            ->setBusNutzung($busNutzung)
            ->setAnzahlStehplaetze($anzahlStehplaetze)
            ->setBauart($bauart)
            ->setIstOberleitungsbus($istOberleitungsbus)
            ->setHatSenkrechtGeteilteFrontscheibe($hatSenkrechtGeteilteFrontscheibe);
    }
    /**
     * Get AnzahlPlaetze value
     * @return int|null
     */
    public function getAnzahlPlaetze()
    {
        return $this->AnzahlPlaetze;
    }
    /**
     * Set AnzahlPlaetze value
     * @param int $anzahlPlaetze
     * @return \BiPRO\StructType\CT_Bus
     */
    public function setAnzahlPlaetze($anzahlPlaetze = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlPlaetze) && !(is_int($anzahlPlaetze) || ctype_digit($anzahlPlaetze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlPlaetze, true), gettype($anzahlPlaetze)), __LINE__);
        }
        $this->AnzahlPlaetze = $anzahlPlaetze;
        return $this;
    }
    /**
     * Get BusNutzung value
     * @return \BiPRO\StructType\CT_BusNutzung|null
     */
    public function getBusNutzung()
    {
        return $this->BusNutzung;
    }
    /**
     * Set BusNutzung value
     * @param \BiPRO\StructType\CT_BusNutzung $busNutzung
     * @return \BiPRO\StructType\CT_Bus
     */
    public function setBusNutzung(\BiPRO\StructType\CT_BusNutzung $busNutzung = null)
    {
        $this->BusNutzung = $busNutzung;
        return $this;
    }
    /**
     * Get AnzahlStehplaetze value
     * @return int|null
     */
    public function getAnzahlStehplaetze()
    {
        return $this->AnzahlStehplaetze;
    }
    /**
     * Set AnzahlStehplaetze value
     * @param int $anzahlStehplaetze
     * @return \BiPRO\StructType\CT_Bus
     */
    public function setAnzahlStehplaetze($anzahlStehplaetze = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlStehplaetze) && !(is_int($anzahlStehplaetze) || ctype_digit($anzahlStehplaetze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlStehplaetze, true), gettype($anzahlStehplaetze)), __LINE__);
        }
        $this->AnzahlStehplaetze = $anzahlStehplaetze;
        return $this;
    }
    /**
     * Get Bauart value
     * @return string|null
     */
    public function getBauart()
    {
        return $this->Bauart;
    }
    /**
     * Set Bauart value
     * @uses \BiPRO\EnumType\ST_BusBauart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_BusBauart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bauart
     * @return \BiPRO\StructType\CT_Bus
     */
    public function setBauart($bauart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_BusBauart::valueIsValid($bauart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_BusBauart', is_array($bauart) ? implode(', ', $bauart) : var_export($bauart, true), implode(', ', \BiPRO\EnumType\ST_BusBauart::getValidValues())), __LINE__);
        }
        $this->Bauart = $bauart;
        return $this;
    }
    /**
     * Get IstOberleitungsbus value
     * @return bool|null
     */
    public function getIstOberleitungsbus()
    {
        return $this->IstOberleitungsbus;
    }
    /**
     * Set IstOberleitungsbus value
     * @param bool $istOberleitungsbus
     * @return \BiPRO\StructType\CT_Bus
     */
    public function setIstOberleitungsbus($istOberleitungsbus = null)
    {
        // validation for constraint: boolean
        if (!is_null($istOberleitungsbus) && !is_bool($istOberleitungsbus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($istOberleitungsbus, true), gettype($istOberleitungsbus)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($istOberleitungsbus) && !preg_match('/true|false/', $istOberleitungsbus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($istOberleitungsbus, true)), __LINE__);
        }
        $this->IstOberleitungsbus = $istOberleitungsbus;
        return $this;
    }
    /**
     * Get HatSenkrechtGeteilteFrontscheibe value
     * @return bool|null
     */
    public function getHatSenkrechtGeteilteFrontscheibe()
    {
        return $this->HatSenkrechtGeteilteFrontscheibe;
    }
    /**
     * Set HatSenkrechtGeteilteFrontscheibe value
     * @param bool $hatSenkrechtGeteilteFrontscheibe
     * @return \BiPRO\StructType\CT_Bus
     */
    public function setHatSenkrechtGeteilteFrontscheibe($hatSenkrechtGeteilteFrontscheibe = null)
    {
        // validation for constraint: boolean
        if (!is_null($hatSenkrechtGeteilteFrontscheibe) && !is_bool($hatSenkrechtGeteilteFrontscheibe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hatSenkrechtGeteilteFrontscheibe, true), gettype($hatSenkrechtGeteilteFrontscheibe)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($hatSenkrechtGeteilteFrontscheibe) && !preg_match('/true|false/', $hatSenkrechtGeteilteFrontscheibe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($hatSenkrechtGeteilteFrontscheibe, true)), __LINE__);
        }
        $this->HatSenkrechtGeteilteFrontscheibe = $hatSenkrechtGeteilteFrontscheibe;
        return $this;
    }
}
