<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Blitzschaden StructType
 * Meta information extracted from the WSDL
 * - documentation: Durch Blitzschlag entstandener Schaden.
 * @subpackage Structs
 */
class CT_Blitzschaden extends CT_SchadenZuObjekt
{
    /**
     * The Blitzeinschlagstelle
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Blitzeinschlagstelle.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Blitzeinschlagstelle;
    /**
     * The Entfernung
     * Meta information extracted from the WSDL
     * - documentation: Entfernung der Blitzeinschlagstelle in Metern
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Entfernung;
    /**
     * The Blitzeinschlagspuren
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Blitzeinschlagspuren.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Blitzeinschlagspuren;
    /**
     * The Anschlussleitung
     * Meta information extracted from the WSDL
     * - documentation: Anschlussleitung der beschädigten Sache.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Anschlussleitung;
    /**
     * The Anlageart
     * Meta information extracted from the WSDL
     * - documentation: Art der vom Blitzschaden betroffenen Anlage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Anlageart;
    /**
     * The LetzterBetrieb
     * Meta information extracted from the WSDL
     * - documentation: Datum und optional Zeit, wann die geschädigte Sache zuletzt in Betrieb war.Es MUSS mindestens ein Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF
     * übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden. | Datentyp zur Angabe eines Zeitpunkts mit beliebiger Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt entspricht
     * die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp nutzende Attribute MÜSSEN in ihrer Dokumentation die gewünschte Genauigkeit und die Optionalität der Zeitzone explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt interpretiert
     * werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht UTC +5 Stunden.Gültige Werte sind zum
     * Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $LetzterBetrieb;
    /**
     * Constructor method for CT_Blitzschaden
     * @uses CT_Blitzschaden::setBlitzeinschlagstelle()
     * @uses CT_Blitzschaden::setEntfernung()
     * @uses CT_Blitzschaden::setBlitzeinschlagspuren()
     * @uses CT_Blitzschaden::setAnschlussleitung()
     * @uses CT_Blitzschaden::setAnlageart()
     * @uses CT_Blitzschaden::setLetzterBetrieb()
     * @param string $blitzeinschlagstelle
     * @param float $entfernung
     * @param string $blitzeinschlagspuren
     * @param string $anschlussleitung
     * @param string $anlageart
     * @param string $letzterBetrieb
     */
    public function __construct($blitzeinschlagstelle = null, $entfernung = null, $blitzeinschlagspuren = null, $anschlussleitung = null, $anlageart = null, $letzterBetrieb = null)
    {
        $this
            ->setBlitzeinschlagstelle($blitzeinschlagstelle)
            ->setEntfernung($entfernung)
            ->setBlitzeinschlagspuren($blitzeinschlagspuren)
            ->setAnschlussleitung($anschlussleitung)
            ->setAnlageart($anlageart)
            ->setLetzterBetrieb($letzterBetrieb);
    }
    /**
     * Get Blitzeinschlagstelle value
     * @return string|null
     */
    public function getBlitzeinschlagstelle()
    {
        return $this->Blitzeinschlagstelle;
    }
    /**
     * Set Blitzeinschlagstelle value
     * @param string $blitzeinschlagstelle
     * @return \BiPRO\StructType\CT_Blitzschaden
     */
    public function setBlitzeinschlagstelle($blitzeinschlagstelle = null)
    {
        // validation for constraint: string
        if (!is_null($blitzeinschlagstelle) && !is_string($blitzeinschlagstelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blitzeinschlagstelle, true), gettype($blitzeinschlagstelle)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($blitzeinschlagstelle) && mb_strlen($blitzeinschlagstelle) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($blitzeinschlagstelle)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($blitzeinschlagstelle) && mb_strlen($blitzeinschlagstelle) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($blitzeinschlagstelle)), __LINE__);
        }
        $this->Blitzeinschlagstelle = $blitzeinschlagstelle;
        return $this;
    }
    /**
     * Get Entfernung value
     * @return float|null
     */
    public function getEntfernung()
    {
        return $this->Entfernung;
    }
    /**
     * Set Entfernung value
     * @param float $entfernung
     * @return \BiPRO\StructType\CT_Blitzschaden
     */
    public function setEntfernung($entfernung = null)
    {
        // validation for constraint: float
        if (!is_null($entfernung) && !(is_float($entfernung) || is_numeric($entfernung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($entfernung, true), gettype($entfernung)), __LINE__);
        }
        $this->Entfernung = $entfernung;
        return $this;
    }
    /**
     * Get Blitzeinschlagspuren value
     * @return string|null
     */
    public function getBlitzeinschlagspuren()
    {
        return $this->Blitzeinschlagspuren;
    }
    /**
     * Set Blitzeinschlagspuren value
     * @param string $blitzeinschlagspuren
     * @return \BiPRO\StructType\CT_Blitzschaden
     */
    public function setBlitzeinschlagspuren($blitzeinschlagspuren = null)
    {
        // validation for constraint: string
        if (!is_null($blitzeinschlagspuren) && !is_string($blitzeinschlagspuren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blitzeinschlagspuren, true), gettype($blitzeinschlagspuren)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($blitzeinschlagspuren) && mb_strlen($blitzeinschlagspuren) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($blitzeinschlagspuren)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($blitzeinschlagspuren) && mb_strlen($blitzeinschlagspuren) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($blitzeinschlagspuren)), __LINE__);
        }
        $this->Blitzeinschlagspuren = $blitzeinschlagspuren;
        return $this;
    }
    /**
     * Get Anschlussleitung value
     * @return string|null
     */
    public function getAnschlussleitung()
    {
        return $this->Anschlussleitung;
    }
    /**
     * Set Anschlussleitung value
     * @uses \BiPRO\EnumType\ST_Leitungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Leitungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anschlussleitung
     * @return \BiPRO\StructType\CT_Blitzschaden
     */
    public function setAnschlussleitung($anschlussleitung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Leitungsart::valueIsValid($anschlussleitung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Leitungsart', is_array($anschlussleitung) ? implode(', ', $anschlussleitung) : var_export($anschlussleitung, true), implode(', ', \BiPRO\EnumType\ST_Leitungsart::getValidValues())), __LINE__);
        }
        $this->Anschlussleitung = $anschlussleitung;
        return $this;
    }
    /**
     * Get Anlageart value
     * @return string|null
     */
    public function getAnlageart()
    {
        return $this->Anlageart;
    }
    /**
     * Set Anlageart value
     * @uses \BiPRO\EnumType\ST_ArtTechnischeAnlage::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ArtTechnischeAnlage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anlageart
     * @return \BiPRO\StructType\CT_Blitzschaden
     */
    public function setAnlageart($anlageart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ArtTechnischeAnlage::valueIsValid($anlageart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ArtTechnischeAnlage', is_array($anlageart) ? implode(', ', $anlageart) : var_export($anlageart, true), implode(', ', \BiPRO\EnumType\ST_ArtTechnischeAnlage::getValidValues())), __LINE__);
        }
        $this->Anlageart = $anlageart;
        return $this;
    }
    /**
     * Get LetzterBetrieb value
     * @return string|null
     */
    public function getLetzterBetrieb()
    {
        return $this->LetzterBetrieb;
    }
    /**
     * Set LetzterBetrieb value
     * @param string $letzterBetrieb
     * @return \BiPRO\StructType\CT_Blitzschaden
     */
    public function setLetzterBetrieb($letzterBetrieb = null)
    {
        // validation for constraint: string
        if (!is_null($letzterBetrieb) && !is_string($letzterBetrieb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($letzterBetrieb, true), gettype($letzterBetrieb)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($letzterBetrieb) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $letzterBetrieb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($letzterBetrieb, true)), __LINE__);
        }
        $this->LetzterBetrieb = $letzterBetrieb;
        return $this;
    }
}
