<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Bezugsrecht StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zu Bezugsrechten und -berechtigten.
 * @subpackage Structs
 */
class CT_Bezugsrecht extends CT_Objekt
{
    /**
     * The Leistungsfall
     * Meta information extracted from the WSDL
     * - documentation: Die Art des Ereignisses, das das Bezugsrecht auslöst
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Leistungsfall;
    /**
     * The UnwiderruflichesBezugsrecht
     * Meta information extracted from the WSDL
     * - documentation: Nicht änderbares Bezugsrecht
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $UnwiderruflichesBezugsrecht;
    /**
     * The IndexBerechtigter
     * Meta information extracted from the WSDL
     * - documentation: Festlegung der Bezugsberechtigung. Falls hier die Ausprägung 9 (individuell) gewählt wurde, MUSS Individualbezug oder Bezugsberechtiger gefüllt sein.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IndexBerechtigter;
    /**
     * The Individualbezug
     * Meta information extracted from the WSDL
     * - documentation: Angabe des Bezugsberechtigten als Freitext. MUSS angegeben werden, wenn IndexBerechtigter = 9 (individuell) und Bezugsberechtigter nicht gefüllt ist.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Individualbezug;
    /**
     * The Bezugsrechtsanteil
     * Meta information extracted from the WSDL
     * - documentation: Anteiliges Bezugsrecht im Leistungsfall. | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $Bezugsrechtsanteil;
    /**
     * The Bezugsberechtigter
     * Meta information extracted from the WSDL
     * - documentation: Angabe des Bezugsberechtigten als Partner. MUSS angegeben werden, wenn IndexBerechtigter = 9 (individuell) und Individualabzug nicht gefüllt ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Bezugsberechtigter
     */
    public $Bezugsberechtigter;
    /**
     * Constructor method for CT_Bezugsrecht
     * @uses CT_Bezugsrecht::setLeistungsfall()
     * @uses CT_Bezugsrecht::setUnwiderruflichesBezugsrecht()
     * @uses CT_Bezugsrecht::setIndexBerechtigter()
     * @uses CT_Bezugsrecht::setIndividualbezug()
     * @uses CT_Bezugsrecht::setBezugsrechtsanteil()
     * @uses CT_Bezugsrecht::setBezugsberechtigter()
     * @param string $leistungsfall
     * @param bool $unwiderruflichesBezugsrecht
     * @param string $indexBerechtigter
     * @param string $individualbezug
     * @param float $bezugsrechtsanteil
     * @param \BiPRO\StructType\CT_Bezugsberechtigter $bezugsberechtigter
     */
    public function __construct($leistungsfall = null, $unwiderruflichesBezugsrecht = null, $indexBerechtigter = null, $individualbezug = null, $bezugsrechtsanteil = null, \BiPRO\StructType\CT_Bezugsberechtigter $bezugsberechtigter = null)
    {
        $this
            ->setLeistungsfall($leistungsfall)
            ->setUnwiderruflichesBezugsrecht($unwiderruflichesBezugsrecht)
            ->setIndexBerechtigter($indexBerechtigter)
            ->setIndividualbezug($individualbezug)
            ->setBezugsrechtsanteil($bezugsrechtsanteil)
            ->setBezugsberechtigter($bezugsberechtigter);
    }
    /**
     * Get Leistungsfall value
     * @return string|null
     */
    public function getLeistungsfall()
    {
        return $this->Leistungsfall;
    }
    /**
     * Set Leistungsfall value
     * @uses \BiPRO\EnumType\ST_Leistungsfall::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Leistungsfall::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $leistungsfall
     * @return \BiPRO\StructType\CT_Bezugsrecht
     */
    public function setLeistungsfall($leistungsfall = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Leistungsfall::valueIsValid($leistungsfall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Leistungsfall', is_array($leistungsfall) ? implode(', ', $leistungsfall) : var_export($leistungsfall, true), implode(', ', \BiPRO\EnumType\ST_Leistungsfall::getValidValues())), __LINE__);
        }
        $this->Leistungsfall = $leistungsfall;
        return $this;
    }
    /**
     * Get UnwiderruflichesBezugsrecht value
     * @return bool|null
     */
    public function getUnwiderruflichesBezugsrecht()
    {
        return $this->UnwiderruflichesBezugsrecht;
    }
    /**
     * Set UnwiderruflichesBezugsrecht value
     * @param bool $unwiderruflichesBezugsrecht
     * @return \BiPRO\StructType\CT_Bezugsrecht
     */
    public function setUnwiderruflichesBezugsrecht($unwiderruflichesBezugsrecht = null)
    {
        // validation for constraint: boolean
        if (!is_null($unwiderruflichesBezugsrecht) && !is_bool($unwiderruflichesBezugsrecht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unwiderruflichesBezugsrecht, true), gettype($unwiderruflichesBezugsrecht)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($unwiderruflichesBezugsrecht) && !preg_match('/true|false/', $unwiderruflichesBezugsrecht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($unwiderruflichesBezugsrecht, true)), __LINE__);
        }
        $this->UnwiderruflichesBezugsrecht = $unwiderruflichesBezugsrecht;
        return $this;
    }
    /**
     * Get IndexBerechtigter value
     * @return string|null
     */
    public function getIndexBerechtigter()
    {
        return $this->IndexBerechtigter;
    }
    /**
     * Set IndexBerechtigter value
     * @uses \BiPRO\EnumType\ST_Bezugsrecht::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Bezugsrecht::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $indexBerechtigter
     * @return \BiPRO\StructType\CT_Bezugsrecht
     */
    public function setIndexBerechtigter($indexBerechtigter = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Bezugsrecht::valueIsValid($indexBerechtigter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Bezugsrecht', is_array($indexBerechtigter) ? implode(', ', $indexBerechtigter) : var_export($indexBerechtigter, true), implode(', ', \BiPRO\EnumType\ST_Bezugsrecht::getValidValues())), __LINE__);
        }
        $this->IndexBerechtigter = $indexBerechtigter;
        return $this;
    }
    /**
     * Get Individualbezug value
     * @return string|null
     */
    public function getIndividualbezug()
    {
        return $this->Individualbezug;
    }
    /**
     * Set Individualbezug value
     * @param string $individualbezug
     * @return \BiPRO\StructType\CT_Bezugsrecht
     */
    public function setIndividualbezug($individualbezug = null)
    {
        // validation for constraint: string
        if (!is_null($individualbezug) && !is_string($individualbezug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualbezug, true), gettype($individualbezug)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($individualbezug) && mb_strlen($individualbezug) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($individualbezug)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($individualbezug) && mb_strlen($individualbezug) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($individualbezug)), __LINE__);
        }
        $this->Individualbezug = $individualbezug;
        return $this;
    }
    /**
     * Get Bezugsrechtsanteil value
     * @return float|null
     */
    public function getBezugsrechtsanteil()
    {
        return $this->Bezugsrechtsanteil;
    }
    /**
     * Set Bezugsrechtsanteil value
     * @param float $bezugsrechtsanteil
     * @return \BiPRO\StructType\CT_Bezugsrecht
     */
    public function setBezugsrechtsanteil($bezugsrechtsanteil = null)
    {
        // validation for constraint: float
        if (!is_null($bezugsrechtsanteil) && !(is_float($bezugsrechtsanteil) || is_numeric($bezugsrechtsanteil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bezugsrechtsanteil, true), gettype($bezugsrechtsanteil)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bezugsrechtsanteil) && $bezugsrechtsanteil < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bezugsrechtsanteil, true)), __LINE__);
        }
        $this->Bezugsrechtsanteil = $bezugsrechtsanteil;
        return $this;
    }
    /**
     * Get Bezugsberechtigter value
     * @return \BiPRO\StructType\CT_Bezugsberechtigter|null
     */
    public function getBezugsberechtigter()
    {
        return $this->Bezugsberechtigter;
    }
    /**
     * Set Bezugsberechtigter value
     * @param \BiPRO\StructType\CT_Bezugsberechtigter $bezugsberechtigter
     * @return \BiPRO\StructType\CT_Bezugsrecht
     */
    public function setBezugsberechtigter(\BiPRO\StructType\CT_Bezugsberechtigter $bezugsberechtigter = null)
    {
        $this->Bezugsberechtigter = $bezugsberechtigter;
        return $this;
    }
}
