<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Betrieb StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Beschreibung eines Betriebes als Risikoobjekt und dessen Anteil bei gemischter Nutzung und Mischbetrieben.
 * @subpackage Structs
 */
class CT_Betrieb extends CT_Gegenstand
{
    /**
     * The Betriebsart
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Bezeichnung der Betriebsart des Providers. | Empfehlung: GDV-Betriebsartenverzeichnis verwenden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $Betriebsart;
    /**
     * The Stichwort
     * Meta information extracted from the WSDL
     * - documentation: Stichwort aus dem Stichwortverzeichnis.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Stichwort;
    /**
     * The Anteil
     * Meta information extracted from the WSDL
     * - documentation: Anteil der Betriebsart am Betrieb gemäß Werteinheit.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Anteil;
    /**
     * The Werteinheit
     * Meta information extracted from the WSDL
     * - documentation: Werteinheit des Anteils.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Werteinheit;
    /**
     * Constructor method for CT_Betrieb
     * @uses CT_Betrieb::setBetriebsart()
     * @uses CT_Betrieb::setStichwort()
     * @uses CT_Betrieb::setAnteil()
     * @uses CT_Betrieb::setWerteinheit()
     * @param string[] $betriebsart
     * @param string $stichwort
     * @param float $anteil
     * @param string $werteinheit
     */
    public function __construct(array $betriebsart = array(), $stichwort = null, $anteil = null, $werteinheit = null)
    {
        $this
            ->setBetriebsart($betriebsart)
            ->setStichwort($stichwort)
            ->setAnteil($anteil)
            ->setWerteinheit($werteinheit);
    }
    /**
     * Get Betriebsart value
     * @return string[]|null
     */
    public function getBetriebsart()
    {
        return $this->Betriebsart;
    }
    /**
     * This method is responsible for validating the values passed to the setBetriebsart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBetriebsart method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBetriebsartForArrayConstraintsFromSetBetriebsart(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_BetriebBetriebsartItem) {
            // validation for constraint: itemType
            if (!is_string($cT_BetriebBetriebsartItem)) {
                $invalidValues[] = is_object($cT_BetriebBetriebsartItem) ? get_class($cT_BetriebBetriebsartItem) : sprintf('%s(%s)', gettype($cT_BetriebBetriebsartItem), var_export($cT_BetriebBetriebsartItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Betriebsart property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Betriebsart value
     * @param string[] $betriebsart
     * @return \BiPRO\StructType\CT_Betrieb
     */
    public function setBetriebsart(array $betriebsart = array())
    {
        // validation for constraint: list
        if ('' !== ($betriebsartArrayErrorMessage = self::validateBetriebsartForArrayConstraintsFromSetBetriebsart($betriebsart))) {
            throw new \InvalidArgumentException($betriebsartArrayErrorMessage, __LINE__);
        }
        $this->Betriebsart = is_array($betriebsart) ? implode(' ', $betriebsart) : null;
        return $this;
    }
    /**
     * Get Stichwort value
     * @return string|null
     */
    public function getStichwort()
    {
        return $this->Stichwort;
    }
    /**
     * Set Stichwort value
     * @param string $stichwort
     * @return \BiPRO\StructType\CT_Betrieb
     */
    public function setStichwort($stichwort = null)
    {
        // validation for constraint: string
        if (!is_null($stichwort) && !is_string($stichwort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stichwort, true), gettype($stichwort)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($stichwort) && mb_strlen($stichwort) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($stichwort)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($stichwort) && mb_strlen($stichwort) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($stichwort)), __LINE__);
        }
        $this->Stichwort = $stichwort;
        return $this;
    }
    /**
     * Get Anteil value
     * @return float|null
     */
    public function getAnteil()
    {
        return $this->Anteil;
    }
    /**
     * Set Anteil value
     * @param float $anteil
     * @return \BiPRO\StructType\CT_Betrieb
     */
    public function setAnteil($anteil = null)
    {
        // validation for constraint: float
        if (!is_null($anteil) && !(is_float($anteil) || is_numeric($anteil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anteil, true), gettype($anteil)), __LINE__);
        }
        $this->Anteil = $anteil;
        return $this;
    }
    /**
     * Get Werteinheit value
     * @return string|null
     */
    public function getWerteinheit()
    {
        return $this->Werteinheit;
    }
    /**
     * Set Werteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $werteinheit
     * @return \BiPRO\StructType\CT_Betrieb
     */
    public function setWerteinheit($werteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($werteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($werteinheit) ? implode(', ', $werteinheit) : var_export($werteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->Werteinheit = $werteinheit;
        return $this;
    }
}
