<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Beteiligungsverhaeltnis StructType
 * Meta information extracted from the WSDL
 * - documentation: Diese Klasse spezifiziert den Anteil eines Vermittlers an einem Gesamtvertrag und die Aufteilung dieses Anteils auf mehrere Versicherer.Beispiel Normalfall:Vermittler A vermittlet den Gesamtvertrag und beteiligt das führende VU X zu
 * 60 % und das beteiligte VU Y zu 40 %.Beteiligungsverhaeltnis.AnteilVermittler = 100Beteiligungsanteil.AnteilVU = 60Beteiligungsanteil.VUFuehrend = JaBeteiligungsanteil.Versicherungsunternehmen = VU XBeteiligungsanteil.AnteilVU =
 * 40Beteiligungsanteil.VUFuehrend = NeinBeteiligungsanteil.Versicherungsunternehmen = VU YBeispiel Vermittler nur partiell beteiligt:Vermittler A vermittlet einen Anteil am Gesamtvertrag von 60 % und beteiligt das führende VU X zu 40 % und das
 * beteiligte VU Y zu 20 %.Beteiligungsverhaeltnis.AnteilVermittler = 60Beteiligungsanteil.AnteilVU = 40Beteiligungsanteil.VUFuehrend = JaBeteiligungsanteil.Versicherungsunternehmen = VU XBeteiligungsanteil.AnteilVU = 20Beteiligungsanteil.VUFuehrend =
 * NeinBeteiligungsanteil.Versicherungsunternehmen = VU Y
 * @subpackage Structs
 */
class CT_Beteiligungsverhaeltnis extends CT_Objekt
{
    /**
     * The Beteiligungsanteil
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Beteiligungsanteil[]
     */
    public $Beteiligungsanteil;
    /**
     * The GueltigAb
     * Meta information extracted from the WSDL
     * - documentation: Datum, ab dem das Beteiligungsverhaeltnis gültig ist. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $GueltigAb;
    /**
     * The AnteilVermittler
     * Meta information extracted from the WSDL
     * - documentation: Anteil des Vermittlers am Gesamtvertrag | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $AnteilVermittler;
    /**
     * The AbrechnungVermittlerMitBeteiligten
     * Meta information extracted from the WSDL
     * - documentation: JA = Vermittler rechnet mit allen beteiligten Versicherern ab.NEIN = Vermittler rechnet nur mit dem führenden Versicherer ab.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $AbrechnungVermittlerMitBeteiligten;
    /**
     * Constructor method for CT_Beteiligungsverhaeltnis
     * @uses CT_Beteiligungsverhaeltnis::setBeteiligungsanteil()
     * @uses CT_Beteiligungsverhaeltnis::setGueltigAb()
     * @uses CT_Beteiligungsverhaeltnis::setAnteilVermittler()
     * @uses CT_Beteiligungsverhaeltnis::setAbrechnungVermittlerMitBeteiligten()
     * @param \BiPRO\StructType\CT_Beteiligungsanteil[] $beteiligungsanteil
     * @param string $gueltigAb
     * @param float $anteilVermittler
     * @param bool $abrechnungVermittlerMitBeteiligten
     */
    public function __construct(array $beteiligungsanteil = array(), $gueltigAb = null, $anteilVermittler = null, $abrechnungVermittlerMitBeteiligten = null)
    {
        $this
            ->setBeteiligungsanteil($beteiligungsanteil)
            ->setGueltigAb($gueltigAb)
            ->setAnteilVermittler($anteilVermittler)
            ->setAbrechnungVermittlerMitBeteiligten($abrechnungVermittlerMitBeteiligten);
    }
    /**
     * Get Beteiligungsanteil value
     * @return \BiPRO\StructType\CT_Beteiligungsanteil[]
     */
    public function getBeteiligungsanteil()
    {
        return $this->Beteiligungsanteil;
    }
    /**
     * This method is responsible for validating the values passed to the setBeteiligungsanteil method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeteiligungsanteil method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeteiligungsanteilForArrayConstraintsFromSetBeteiligungsanteil(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_BeteiligungsverhaeltnisBeteiligungsanteilItem) {
            // validation for constraint: itemType
            if (!$cT_BeteiligungsverhaeltnisBeteiligungsanteilItem instanceof \BiPRO\StructType\CT_Beteiligungsanteil) {
                $invalidValues[] = is_object($cT_BeteiligungsverhaeltnisBeteiligungsanteilItem) ? get_class($cT_BeteiligungsverhaeltnisBeteiligungsanteilItem) : sprintf('%s(%s)', gettype($cT_BeteiligungsverhaeltnisBeteiligungsanteilItem), var_export($cT_BeteiligungsverhaeltnisBeteiligungsanteilItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Beteiligungsanteil property can only contain items of type \BiPRO\StructType\CT_Beteiligungsanteil, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Beteiligungsanteil value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Beteiligungsanteil[] $beteiligungsanteil
     * @return \BiPRO\StructType\CT_Beteiligungsverhaeltnis
     */
    public function setBeteiligungsanteil(array $beteiligungsanteil = array())
    {
        // validation for constraint: array
        if ('' !== ($beteiligungsanteilArrayErrorMessage = self::validateBeteiligungsanteilForArrayConstraintsFromSetBeteiligungsanteil($beteiligungsanteil))) {
            throw new \InvalidArgumentException($beteiligungsanteilArrayErrorMessage, __LINE__);
        }
        $this->Beteiligungsanteil = $beteiligungsanteil;
        return $this;
    }
    /**
     * Add item to Beteiligungsanteil value
     * @throws \InvalidArgumentException
     * @param \BiPRO\StructType\CT_Beteiligungsanteil $item
     * @return \BiPRO\StructType\CT_Beteiligungsverhaeltnis
     */
    public function addToBeteiligungsanteil(\BiPRO\StructType\CT_Beteiligungsanteil $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \BiPRO\StructType\CT_Beteiligungsanteil) {
            throw new \InvalidArgumentException(sprintf('The Beteiligungsanteil property can only contain items of type \BiPRO\StructType\CT_Beteiligungsanteil, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Beteiligungsanteil[] = $item;
        return $this;
    }
    /**
     * Get GueltigAb value
     * @return string|null
     */
    public function getGueltigAb()
    {
        return $this->GueltigAb;
    }
    /**
     * Set GueltigAb value
     * @param string $gueltigAb
     * @return \BiPRO\StructType\CT_Beteiligungsverhaeltnis
     */
    public function setGueltigAb($gueltigAb = null)
    {
        // validation for constraint: string
        if (!is_null($gueltigAb) && !is_string($gueltigAb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gueltigAb, true), gettype($gueltigAb)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($gueltigAb) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $gueltigAb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($gueltigAb, true)), __LINE__);
        }
        $this->GueltigAb = $gueltigAb;
        return $this;
    }
    /**
     * Get AnteilVermittler value
     * @return float|null
     */
    public function getAnteilVermittler()
    {
        return $this->AnteilVermittler;
    }
    /**
     * Set AnteilVermittler value
     * @param float $anteilVermittler
     * @return \BiPRO\StructType\CT_Beteiligungsverhaeltnis
     */
    public function setAnteilVermittler($anteilVermittler = null)
    {
        // validation for constraint: float
        if (!is_null($anteilVermittler) && !(is_float($anteilVermittler) || is_numeric($anteilVermittler))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anteilVermittler, true), gettype($anteilVermittler)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anteilVermittler) && $anteilVermittler < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anteilVermittler, true)), __LINE__);
        }
        $this->AnteilVermittler = $anteilVermittler;
        return $this;
    }
    /**
     * Get AbrechnungVermittlerMitBeteiligten value
     * @return bool|null
     */
    public function getAbrechnungVermittlerMitBeteiligten()
    {
        return $this->AbrechnungVermittlerMitBeteiligten;
    }
    /**
     * Set AbrechnungVermittlerMitBeteiligten value
     * @param bool $abrechnungVermittlerMitBeteiligten
     * @return \BiPRO\StructType\CT_Beteiligungsverhaeltnis
     */
    public function setAbrechnungVermittlerMitBeteiligten($abrechnungVermittlerMitBeteiligten = null)
    {
        // validation for constraint: boolean
        if (!is_null($abrechnungVermittlerMitBeteiligten) && !is_bool($abrechnungVermittlerMitBeteiligten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abrechnungVermittlerMitBeteiligten, true), gettype($abrechnungVermittlerMitBeteiligten)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($abrechnungVermittlerMitBeteiligten) && !preg_match('/true|false/', $abrechnungVermittlerMitBeteiligten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($abrechnungVermittlerMitBeteiligten, true)), __LINE__);
        }
        $this->AbrechnungVermittlerMitBeteiligten = $abrechnungVermittlerMitBeteiligten;
        return $this;
    }
}
