<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Beteiligter StructType
 * Meta information extracted from the WSDL
 * - documentation: Partner, der an einem Schaden bzw. einer Leistung beteiligt ist.
 * @subpackage Structs
 */
class CT_Beteiligter extends CT_Partnerrolle
{
    /**
     * The Rolle
     * Meta information extracted from the WSDL
     * - documentation: Rolle des Beteiligten (z.B. Versicherungsnehmer, Anspruchsteller, Reparaturfirma, Sachverständiger, Zeuge, Rechtsanwalt, Sicherungsgläubiger, versicherte Person).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Rolle;
    /**
     * Constructor method for CT_Beteiligter
     * @uses CT_Beteiligter::setRolle()
     * @param string $rolle
     */
    public function __construct($rolle = null)
    {
        $this
            ->setRolle($rolle);
    }
    /**
     * Get Rolle value
     * @return string
     */
    public function getRolle()
    {
        return $this->Rolle;
    }
    /**
     * Set Rolle value
     * @uses \BiPRO\EnumType\ST_RolleBeteiligter::valueIsValid()
     * @uses \BiPRO\EnumType\ST_RolleBeteiligter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rolle
     * @return \BiPRO\StructType\CT_Beteiligter
     */
    public function setRolle($rolle = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_RolleBeteiligter::valueIsValid($rolle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_RolleBeteiligter', is_array($rolle) ? implode(', ', $rolle) : var_export($rolle, true), implode(', ', \BiPRO\EnumType\ST_RolleBeteiligter::getValidValues())), __LINE__);
        }
        $this->Rolle = $rolle;
        return $this;
    }
}
