<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Besichtigung StructType
 * Meta information extracted from the WSDL
 * - documentation: Tätigkeit, bei der jemand etwas genau betrachtet.
 * @subpackage Structs
 */
class CT_Besichtigung extends CT_Objekt
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status der Besichtigung (z.B. gewünscht, erforderlich, vereinbart, erfolgt)Beispiel: Status = 3 bedeutet Besichtigung ist erforderlich
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Beauftragungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum mit optionaler Zeitangabe, an dem die Besichtigung beauftragt wurde.Es MUSS mindestens ein Datum übermittelt werden. Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF
     * übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden. | Datentyp zur Angabe eines Zeitpunkts mit beliebiger Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt entspricht
     * die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp nutzende Attribute MÜSSEN in ihrer Dokumentation die gewünschte Genauigkeit und die Optionalität der Zeitzone explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt interpretiert
     * werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht UTC +5 Stunden.Gültige Werte sind zum
     * Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $Beauftragungsdatum;
    /**
     * The Besichtigungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum mit optionaler Zeitangabe, an dem die Besichtigung gewünscht ist oder geplant ist oder durchgeführt wurde (entsprechend dem Status = 2 gewünscht = gewünschter Termin, etc.).Es MUSS mindestens ein Datum übermittelt werden.
     * Wird eine Zeitangabe übermittelt, MUSS diese mit Stunden und Minuten angegeben werden. Eine Zeitzone DARF übermittelt werden. Fehlt die Zeitzone, MUSS die am angegebenen Datum in Deutschland gültige Zeitzone angenommen werden. | Datentyp zur
     * Angabe eines Zeitpunkts mit beliebiger Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt entspricht die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp nutzende Attribute MÜSSEN in ihrer Dokumentation die gewünschte
     * Genauigkeit und die Optionalität der Zeitzone explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt interpretiert werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht UTC +5 Stunden.Gültige Werte sind zum
     * Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $Besichtigungsdatum;
    /**
     * The BesichtigungszeitZusatz
     * Meta information extracted from the WSDL
     * - documentation: Klartext zur Besichtigungszeit (z. B. "nachmittags").
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $BesichtigungszeitZusatz;
    /**
     * The Hinweis
     * Meta information extracted from the WSDL
     * - documentation: Ergänzender Hinweis zur Besichtigung (z.B. "Fahrzeug steht in der Garage").
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Hinweis;
    /**
     * The Besichtiger
     * Meta information extracted from the WSDL
     * - documentation: Partner, der die Besichtigung durchführt. Wenn mehrere Besichtiger (z.B. von VN und AST) gleichzeitig besichtigen, sind das zwei Besichtigungen. Zu jeder Besichtigung gibt es einen verantwortlichen Besichtiger.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Besichtiger
     */
    public $Besichtiger;
    /**
     * The BesichtigungBei
     * Meta information extracted from the WSDL
     * - documentation: Partner, bei dem die Besichtigung durchgeführt wird.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_BesichtigungBei
     */
    public $BesichtigungBei;
    /**
     * The Besichtigungsanschrift
     * Meta information extracted from the WSDL
     * - documentation: Anschrift, an der die Besichtigung durchführt wird (ev. auch Geoposition).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Besichtigungsanschrift
     */
    public $Besichtigungsanschrift;
    /**
     * Constructor method for CT_Besichtigung
     * @uses CT_Besichtigung::setStatus()
     * @uses CT_Besichtigung::setBeauftragungsdatum()
     * @uses CT_Besichtigung::setBesichtigungsdatum()
     * @uses CT_Besichtigung::setBesichtigungszeitZusatz()
     * @uses CT_Besichtigung::setHinweis()
     * @uses CT_Besichtigung::setBesichtiger()
     * @uses CT_Besichtigung::setBesichtigungBei()
     * @uses CT_Besichtigung::setBesichtigungsanschrift()
     * @param string $status
     * @param string $beauftragungsdatum
     * @param string $besichtigungsdatum
     * @param string $besichtigungszeitZusatz
     * @param string $hinweis
     * @param \BiPRO\StructType\CT_Besichtiger $besichtiger
     * @param \BiPRO\StructType\CT_BesichtigungBei $besichtigungBei
     * @param \BiPRO\StructType\CT_Besichtigungsanschrift $besichtigungsanschrift
     */
    public function __construct($status = null, $beauftragungsdatum = null, $besichtigungsdatum = null, $besichtigungszeitZusatz = null, $hinweis = null, \BiPRO\StructType\CT_Besichtiger $besichtiger = null, \BiPRO\StructType\CT_BesichtigungBei $besichtigungBei = null, \BiPRO\StructType\CT_Besichtigungsanschrift $besichtigungsanschrift = null)
    {
        $this
            ->setStatus($status)
            ->setBeauftragungsdatum($beauftragungsdatum)
            ->setBesichtigungsdatum($besichtigungsdatum)
            ->setBesichtigungszeitZusatz($besichtigungszeitZusatz)
            ->setHinweis($hinweis)
            ->setBesichtiger($besichtiger)
            ->setBesichtigungBei($besichtigungBei)
            ->setBesichtigungsanschrift($besichtigungsanschrift);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \BiPRO\EnumType\ST_Leistungsstatus::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Leistungsstatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \BiPRO\StructType\CT_Besichtigung
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Leistungsstatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Leistungsstatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \BiPRO\EnumType\ST_Leistungsstatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Beauftragungsdatum value
     * @return string|null
     */
    public function getBeauftragungsdatum()
    {
        return $this->Beauftragungsdatum;
    }
    /**
     * Set Beauftragungsdatum value
     * @param string $beauftragungsdatum
     * @return \BiPRO\StructType\CT_Besichtigung
     */
    public function setBeauftragungsdatum($beauftragungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($beauftragungsdatum) && !is_string($beauftragungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beauftragungsdatum, true), gettype($beauftragungsdatum)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($beauftragungsdatum) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $beauftragungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($beauftragungsdatum, true)), __LINE__);
        }
        $this->Beauftragungsdatum = $beauftragungsdatum;
        return $this;
    }
    /**
     * Get Besichtigungsdatum value
     * @return string|null
     */
    public function getBesichtigungsdatum()
    {
        return $this->Besichtigungsdatum;
    }
    /**
     * Set Besichtigungsdatum value
     * @param string $besichtigungsdatum
     * @return \BiPRO\StructType\CT_Besichtigung
     */
    public function setBesichtigungsdatum($besichtigungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($besichtigungsdatum) && !is_string($besichtigungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($besichtigungsdatum, true), gettype($besichtigungsdatum)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($besichtigungsdatum) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $besichtigungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($besichtigungsdatum, true)), __LINE__);
        }
        $this->Besichtigungsdatum = $besichtigungsdatum;
        return $this;
    }
    /**
     * Get BesichtigungszeitZusatz value
     * @return string|null
     */
    public function getBesichtigungszeitZusatz()
    {
        return $this->BesichtigungszeitZusatz;
    }
    /**
     * Set BesichtigungszeitZusatz value
     * @param string $besichtigungszeitZusatz
     * @return \BiPRO\StructType\CT_Besichtigung
     */
    public function setBesichtigungszeitZusatz($besichtigungszeitZusatz = null)
    {
        // validation for constraint: string
        if (!is_null($besichtigungszeitZusatz) && !is_string($besichtigungszeitZusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($besichtigungszeitZusatz, true), gettype($besichtigungszeitZusatz)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($besichtigungszeitZusatz) && mb_strlen($besichtigungszeitZusatz) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($besichtigungszeitZusatz)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($besichtigungszeitZusatz) && mb_strlen($besichtigungszeitZusatz) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($besichtigungszeitZusatz)), __LINE__);
        }
        $this->BesichtigungszeitZusatz = $besichtigungszeitZusatz;
        return $this;
    }
    /**
     * Get Hinweis value
     * @return string|null
     */
    public function getHinweis()
    {
        return $this->Hinweis;
    }
    /**
     * Set Hinweis value
     * @param string $hinweis
     * @return \BiPRO\StructType\CT_Besichtigung
     */
    public function setHinweis($hinweis = null)
    {
        // validation for constraint: string
        if (!is_null($hinweis) && !is_string($hinweis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hinweis, true), gettype($hinweis)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($hinweis) && mb_strlen($hinweis) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($hinweis)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hinweis) && mb_strlen($hinweis) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hinweis)), __LINE__);
        }
        $this->Hinweis = $hinweis;
        return $this;
    }
    /**
     * Get Besichtiger value
     * @return \BiPRO\StructType\CT_Besichtiger|null
     */
    public function getBesichtiger()
    {
        return $this->Besichtiger;
    }
    /**
     * Set Besichtiger value
     * @param \BiPRO\StructType\CT_Besichtiger $besichtiger
     * @return \BiPRO\StructType\CT_Besichtigung
     */
    public function setBesichtiger(\BiPRO\StructType\CT_Besichtiger $besichtiger = null)
    {
        $this->Besichtiger = $besichtiger;
        return $this;
    }
    /**
     * Get BesichtigungBei value
     * @return \BiPRO\StructType\CT_BesichtigungBei|null
     */
    public function getBesichtigungBei()
    {
        return $this->BesichtigungBei;
    }
    /**
     * Set BesichtigungBei value
     * @param \BiPRO\StructType\CT_BesichtigungBei $besichtigungBei
     * @return \BiPRO\StructType\CT_Besichtigung
     */
    public function setBesichtigungBei(\BiPRO\StructType\CT_BesichtigungBei $besichtigungBei = null)
    {
        $this->BesichtigungBei = $besichtigungBei;
        return $this;
    }
    /**
     * Get Besichtigungsanschrift value
     * @return \BiPRO\StructType\CT_Besichtigungsanschrift|null
     */
    public function getBesichtigungsanschrift()
    {
        return $this->Besichtigungsanschrift;
    }
    /**
     * Set Besichtigungsanschrift value
     * @param \BiPRO\StructType\CT_Besichtigungsanschrift $besichtigungsanschrift
     * @return \BiPRO\StructType\CT_Besichtigung
     */
    public function setBesichtigungsanschrift(\BiPRO\StructType\CT_Besichtigungsanschrift $besichtigungsanschrift = null)
    {
        $this->Besichtigungsanschrift = $besichtigungsanschrift;
        return $this;
    }
}
