<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_BeschaedigungKfz StructType
 * Meta information extracted from the WSDL
 * - documentation: Beschädigung an einem Kraftfahrzeug.
 * @subpackage Structs
 */
class CT_BeschaedigungKfz extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der Beschädigung.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * Constructor method for CT_BeschaedigungKfz
     * @uses CT_BeschaedigungKfz::setArtID()
     * @param string $artID
     */
    public function __construct($artID = null)
    {
        $this
            ->setArtID($artID);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_BeschaedigungKfz::valueIsValid()
     * @uses \BiPRO\EnumType\ST_BeschaedigungKfz::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_BeschaedigungKfz
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_BeschaedigungKfz::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_BeschaedigungKfz', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_BeschaedigungKfz::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
}
