<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Berufstaetigkeit StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zur Berufstaetigkeit.Die Attribute Beteiligung (ST_Beteiligung) und Bundesland (ST_Bundesland) fehlen, da die entsprechenden einfachen Datentypen nicht definiert sind.
 * @subpackage Structs
 */
class CT_Berufstaetigkeit extends CT_Objekt
{
    /**
     * The Beruf
     * Meta information extracted from the WSDL
     * - documentation: Name eines bestimmten Berufs. Werden die Attribute "Beruf" UND "Berufschluessel" gemeinsam verwendet, DUERFEN sich die Werte NICHT widersprechen. Der Beruf kann über die Norm 480.2 Berufssuche ermittelt werden. Werden Beruf und
     * Berufsschlüssel geliefert, hat der Berufsschlüssel vorrang. Der Provider DARF im Response den Beruf aus dem Berufsschlüssel ermitteln ggf überschreiben, kenntlich machen und zurückgeben.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Beruf;
    /**
     * The StellungImBeruf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_StellungImBeruf
     */
    public $StellungImBeruf;
    /**
     * The Mitarbeiteranzahl
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Mitarbeiteranzahl;
    /**
     * The Besoldungsgruppe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Besoldungsgruppe;
    /**
     * The SelbststaendigSeit
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $SelbststaendigSeit;
    /**
     * The ArbeitsvertragBefristetBis
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $ArbeitsvertragBefristetBis;
    /**
     * The Betriebseintritt
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Betriebseintritt;
    /**
     * The KoerperlichTaetig
     * Meta information extracted from the WSDL
     * - documentation: Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $KoerperlichTaetig;
    /**
     * The Branche
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_BerufsBranche
     */
    public $Branche;
    /**
     * The OeffentlicherDienst
     * Meta information extracted from the WSDL
     * - documentation: Ja, wenn der Partner im öffentlichen Dienst beschäftigt ist.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $OeffentlicherDienst;
    /**
     * The AnteilAussendienst
     * Meta information extracted from the WSDL
     * - documentation: Anteil der Tätigkeiten im Außendienst in Prozent. | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $AnteilAussendienst;
    /**
     * The Aufsichtsfuehrend
     * Meta information extracted from the WSDL
     * - documentation: Angabe, ob der Partner beruflich (auch teilweise) aufsichtsführend tätig ist.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Aufsichtsfuehrend;
    /**
     * The Mitarbeitend
     * Meta information extracted from the WSDL
     * - documentation: Feststellung, ob der Partner beruflich (auch teilweise) mitarbeitend tätig ist.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Mitarbeitend;
    /**
     * The Berufsschluessel
     * Meta information extracted from the WSDL
     * - documentation: Identifikation eines bestimmten Berufs. Werden die Attribute "Berufschluessel" UND "Beruf" gemeinsam verwendet, DUERFEN sich die Werte NICHT widersprechen. Der Berufsschlüssel kann über die Norm 480.2 Berufssuche ermittelt werden.
     * Werden Beruf und Berufsschlüssel geliefert, hat der Berufsschlüssel vorrang. Der Provider DARF im Response den Beruf aus dem Berufsschlüssel ermitteln ggf überschreiben, kenntlich machen und zurückgeben.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Berufsschluessel;
    /**
     * The NichtKoerperlichTaetig
     * Meta information extracted from the WSDL
     * - documentation: Zur Bestimmung der Risikogruppe wird zusätzlich zur Angabe der körperlichen Tätigkeit (partner:KoerperlichTaetig) auch die Angabe der Tätigkeit im Büro bzw. ob nicht körperlich Tätig, benötigt. Die Summe beider Werte muss
     * nicht zwangsläufig 100% ergeben, um die Risikogruppe zu bestimmen. | Prozentanteil ohne Prozentzeichen z.B. 50 = 50% oder 12,5 = 12,5%
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * @var float
     */
    public $NichtKoerperlichTaetig;
    /**
     * The Gewerbesteuerpflichtig
     * Meta information extracted from the WSDL
     * - documentation: Zeigt an, ob sich um eine gewerbesteuerpflichtige Berufstätigkeit handelt.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Gewerbesteuerpflichtig;
    /**
     * The Praxisform
     * Meta information extracted from the WSDL
     * - documentation: Die Praxisform dient der Angabe, ob es sich hierbei um eine Einzelpraxis bzw. um welche Form der Berufsausübungsgemeinschaft es sich handelt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Praxisform;
    /**
     * The Einkommen
     * Meta information extracted from the WSDL
     * - documentation: Diese Assoziation zwischen Berufstätigkeit und Einkommensart ist dazu vorgesehen um darzustellen, wieviel jemand jeweils mit teilweise selbständiger und teilweise angestellter Tätigkeit verdient. Zu beachten ist dabei, dass das
     * Einkommen nur entweder über Assoziation an Person oder an Berufstätigkeit abgebildet werden kann.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Einkommensart
     */
    public $Einkommen;
    /**
     * The StellungImBerufSeit
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, seit wann die unter StellungImBeruf angegebene Stellung im Beruf eingenommen wird. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $StellungImBerufSeit;
    /**
     * The Berufsschluesselverzeichnis
     * Meta information extracted from the WSDL
     * - documentation: Art des Schlüsselverzeichnisses, das dem verwendeten Berufsschlüssel im Attribut Berufsschluessel zugrunde liegt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Berufsschluesselverzeichnis
     */
    public $Berufsschluesselverzeichnis;
    /**
     * The Arbeitgeber
     * Meta information extracted from the WSDL
     * - documentation: Arbeitgeber der Berufstätigkeit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Arbeitgeber
     */
    public $Arbeitgeber;
    /**
     * The Teilzeit
     * Meta information extracted from the WSDL
     * - documentation: Informationen zum Teilzeitgrad der Berufstätigkeit.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Teilzeit
     */
    public $Teilzeit;
    /**
     * The Grenzgaenger
     * Meta information extracted from the WSDL
     * - documentation: Ja = Die Person wechselt zur Ausübung ihrer beruflichen Tätigkeit regelmäßig vom inländischen Wohnsitz zum Arbeitsplatz im benachbarten Ausland.Nein = sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Grenzgaenger;
    /**
     * Constructor method for CT_Berufstaetigkeit
     * @uses CT_Berufstaetigkeit::setBeruf()
     * @uses CT_Berufstaetigkeit::setStellungImBeruf()
     * @uses CT_Berufstaetigkeit::setMitarbeiteranzahl()
     * @uses CT_Berufstaetigkeit::setBesoldungsgruppe()
     * @uses CT_Berufstaetigkeit::setSelbststaendigSeit()
     * @uses CT_Berufstaetigkeit::setArbeitsvertragBefristetBis()
     * @uses CT_Berufstaetigkeit::setBetriebseintritt()
     * @uses CT_Berufstaetigkeit::setKoerperlichTaetig()
     * @uses CT_Berufstaetigkeit::setBranche()
     * @uses CT_Berufstaetigkeit::setOeffentlicherDienst()
     * @uses CT_Berufstaetigkeit::setAnteilAussendienst()
     * @uses CT_Berufstaetigkeit::setAufsichtsfuehrend()
     * @uses CT_Berufstaetigkeit::setMitarbeitend()
     * @uses CT_Berufstaetigkeit::setBerufsschluessel()
     * @uses CT_Berufstaetigkeit::setNichtKoerperlichTaetig()
     * @uses CT_Berufstaetigkeit::setGewerbesteuerpflichtig()
     * @uses CT_Berufstaetigkeit::setPraxisform()
     * @uses CT_Berufstaetigkeit::setEinkommen()
     * @uses CT_Berufstaetigkeit::setStellungImBerufSeit()
     * @uses CT_Berufstaetigkeit::setBerufsschluesselverzeichnis()
     * @uses CT_Berufstaetigkeit::setArbeitgeber()
     * @uses CT_Berufstaetigkeit::setTeilzeit()
     * @uses CT_Berufstaetigkeit::setGrenzgaenger()
     * @param string $beruf
     * @param \BiPRO\StructType\STE_StellungImBeruf $stellungImBeruf
     * @param int $mitarbeiteranzahl
     * @param string $besoldungsgruppe
     * @param string $selbststaendigSeit
     * @param string $arbeitsvertragBefristetBis
     * @param string $betriebseintritt
     * @param float $koerperlichTaetig
     * @param \BiPRO\StructType\STE_BerufsBranche $branche
     * @param bool $oeffentlicherDienst
     * @param float $anteilAussendienst
     * @param bool $aufsichtsfuehrend
     * @param bool $mitarbeitend
     * @param string $berufsschluessel
     * @param float $nichtKoerperlichTaetig
     * @param bool $gewerbesteuerpflichtig
     * @param string $praxisform
     * @param \BiPRO\StructType\CT_Einkommensart $einkommen
     * @param string $stellungImBerufSeit
     * @param \BiPRO\StructType\STE_Berufsschluesselverzeichnis $berufsschluesselverzeichnis
     * @param \BiPRO\StructType\CT_Arbeitgeber $arbeitgeber
     * @param \BiPRO\StructType\CT_Teilzeit $teilzeit
     * @param bool $grenzgaenger
     */
    public function __construct($beruf = null, \BiPRO\StructType\STE_StellungImBeruf $stellungImBeruf = null, $mitarbeiteranzahl = null, $besoldungsgruppe = null, $selbststaendigSeit = null, $arbeitsvertragBefristetBis = null, $betriebseintritt = null, $koerperlichTaetig = null, \BiPRO\StructType\STE_BerufsBranche $branche = null, $oeffentlicherDienst = null, $anteilAussendienst = null, $aufsichtsfuehrend = null, $mitarbeitend = null, $berufsschluessel = null, $nichtKoerperlichTaetig = null, $gewerbesteuerpflichtig = null, $praxisform = null, \BiPRO\StructType\CT_Einkommensart $einkommen = null, $stellungImBerufSeit = null, \BiPRO\StructType\STE_Berufsschluesselverzeichnis $berufsschluesselverzeichnis = null, \BiPRO\StructType\CT_Arbeitgeber $arbeitgeber = null, \BiPRO\StructType\CT_Teilzeit $teilzeit = null, $grenzgaenger = null)
    {
        $this
            ->setBeruf($beruf)
            ->setStellungImBeruf($stellungImBeruf)
            ->setMitarbeiteranzahl($mitarbeiteranzahl)
            ->setBesoldungsgruppe($besoldungsgruppe)
            ->setSelbststaendigSeit($selbststaendigSeit)
            ->setArbeitsvertragBefristetBis($arbeitsvertragBefristetBis)
            ->setBetriebseintritt($betriebseintritt)
            ->setKoerperlichTaetig($koerperlichTaetig)
            ->setBranche($branche)
            ->setOeffentlicherDienst($oeffentlicherDienst)
            ->setAnteilAussendienst($anteilAussendienst)
            ->setAufsichtsfuehrend($aufsichtsfuehrend)
            ->setMitarbeitend($mitarbeitend)
            ->setBerufsschluessel($berufsschluessel)
            ->setNichtKoerperlichTaetig($nichtKoerperlichTaetig)
            ->setGewerbesteuerpflichtig($gewerbesteuerpflichtig)
            ->setPraxisform($praxisform)
            ->setEinkommen($einkommen)
            ->setStellungImBerufSeit($stellungImBerufSeit)
            ->setBerufsschluesselverzeichnis($berufsschluesselverzeichnis)
            ->setArbeitgeber($arbeitgeber)
            ->setTeilzeit($teilzeit)
            ->setGrenzgaenger($grenzgaenger);
    }
    /**
     * Get Beruf value
     * @return string|null
     */
    public function getBeruf()
    {
        return $this->Beruf;
    }
    /**
     * Set Beruf value
     * @param string $beruf
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setBeruf($beruf = null)
    {
        // validation for constraint: string
        if (!is_null($beruf) && !is_string($beruf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beruf, true), gettype($beruf)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($beruf) && mb_strlen($beruf) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($beruf)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beruf) && mb_strlen($beruf) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beruf)), __LINE__);
        }
        $this->Beruf = $beruf;
        return $this;
    }
    /**
     * Get StellungImBeruf value
     * @return \BiPRO\StructType\STE_StellungImBeruf|null
     */
    public function getStellungImBeruf()
    {
        return $this->StellungImBeruf;
    }
    /**
     * Set StellungImBeruf value
     * @param \BiPRO\StructType\STE_StellungImBeruf $stellungImBeruf
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setStellungImBeruf(\BiPRO\StructType\STE_StellungImBeruf $stellungImBeruf = null)
    {
        $this->StellungImBeruf = $stellungImBeruf;
        return $this;
    }
    /**
     * Get Mitarbeiteranzahl value
     * @return int|null
     */
    public function getMitarbeiteranzahl()
    {
        return $this->Mitarbeiteranzahl;
    }
    /**
     * Set Mitarbeiteranzahl value
     * @param int $mitarbeiteranzahl
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setMitarbeiteranzahl($mitarbeiteranzahl = null)
    {
        // validation for constraint: int
        if (!is_null($mitarbeiteranzahl) && !(is_int($mitarbeiteranzahl) || ctype_digit($mitarbeiteranzahl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mitarbeiteranzahl, true), gettype($mitarbeiteranzahl)), __LINE__);
        }
        $this->Mitarbeiteranzahl = $mitarbeiteranzahl;
        return $this;
    }
    /**
     * Get Besoldungsgruppe value
     * @return string|null
     */
    public function getBesoldungsgruppe()
    {
        return $this->Besoldungsgruppe;
    }
    /**
     * Set Besoldungsgruppe value
     * @param string $besoldungsgruppe
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setBesoldungsgruppe($besoldungsgruppe = null)
    {
        // validation for constraint: string
        if (!is_null($besoldungsgruppe) && !is_string($besoldungsgruppe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($besoldungsgruppe, true), gettype($besoldungsgruppe)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($besoldungsgruppe) && mb_strlen($besoldungsgruppe) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($besoldungsgruppe)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($besoldungsgruppe) && mb_strlen($besoldungsgruppe) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($besoldungsgruppe)), __LINE__);
        }
        $this->Besoldungsgruppe = $besoldungsgruppe;
        return $this;
    }
    /**
     * Get SelbststaendigSeit value
     * @return string|null
     */
    public function getSelbststaendigSeit()
    {
        return $this->SelbststaendigSeit;
    }
    /**
     * Set SelbststaendigSeit value
     * @param string $selbststaendigSeit
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setSelbststaendigSeit($selbststaendigSeit = null)
    {
        // validation for constraint: string
        if (!is_null($selbststaendigSeit) && !is_string($selbststaendigSeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selbststaendigSeit, true), gettype($selbststaendigSeit)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($selbststaendigSeit) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $selbststaendigSeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($selbststaendigSeit, true)), __LINE__);
        }
        $this->SelbststaendigSeit = $selbststaendigSeit;
        return $this;
    }
    /**
     * Get ArbeitsvertragBefristetBis value
     * @return string|null
     */
    public function getArbeitsvertragBefristetBis()
    {
        return $this->ArbeitsvertragBefristetBis;
    }
    /**
     * Set ArbeitsvertragBefristetBis value
     * @param string $arbeitsvertragBefristetBis
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setArbeitsvertragBefristetBis($arbeitsvertragBefristetBis = null)
    {
        // validation for constraint: string
        if (!is_null($arbeitsvertragBefristetBis) && !is_string($arbeitsvertragBefristetBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arbeitsvertragBefristetBis, true), gettype($arbeitsvertragBefristetBis)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($arbeitsvertragBefristetBis) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $arbeitsvertragBefristetBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($arbeitsvertragBefristetBis, true)), __LINE__);
        }
        $this->ArbeitsvertragBefristetBis = $arbeitsvertragBefristetBis;
        return $this;
    }
    /**
     * Get Betriebseintritt value
     * @return string|null
     */
    public function getBetriebseintritt()
    {
        return $this->Betriebseintritt;
    }
    /**
     * Set Betriebseintritt value
     * @param string $betriebseintritt
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setBetriebseintritt($betriebseintritt = null)
    {
        // validation for constraint: string
        if (!is_null($betriebseintritt) && !is_string($betriebseintritt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betriebseintritt, true), gettype($betriebseintritt)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($betriebseintritt) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $betriebseintritt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($betriebseintritt, true)), __LINE__);
        }
        $this->Betriebseintritt = $betriebseintritt;
        return $this;
    }
    /**
     * Get KoerperlichTaetig value
     * @return float|null
     */
    public function getKoerperlichTaetig()
    {
        return $this->KoerperlichTaetig;
    }
    /**
     * Set KoerperlichTaetig value
     * @param float $koerperlichTaetig
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setKoerperlichTaetig($koerperlichTaetig = null)
    {
        // validation for constraint: float
        if (!is_null($koerperlichTaetig) && !(is_float($koerperlichTaetig) || is_numeric($koerperlichTaetig))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($koerperlichTaetig, true), gettype($koerperlichTaetig)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($koerperlichTaetig) && $koerperlichTaetig < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($koerperlichTaetig, true)), __LINE__);
        }
        $this->KoerperlichTaetig = $koerperlichTaetig;
        return $this;
    }
    /**
     * Get Branche value
     * @return \BiPRO\StructType\STE_BerufsBranche|null
     */
    public function getBranche()
    {
        return $this->Branche;
    }
    /**
     * Set Branche value
     * @param \BiPRO\StructType\STE_BerufsBranche $branche
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setBranche(\BiPRO\StructType\STE_BerufsBranche $branche = null)
    {
        $this->Branche = $branche;
        return $this;
    }
    /**
     * Get OeffentlicherDienst value
     * @return bool|null
     */
    public function getOeffentlicherDienst()
    {
        return $this->OeffentlicherDienst;
    }
    /**
     * Set OeffentlicherDienst value
     * @param bool $oeffentlicherDienst
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setOeffentlicherDienst($oeffentlicherDienst = null)
    {
        // validation for constraint: boolean
        if (!is_null($oeffentlicherDienst) && !is_bool($oeffentlicherDienst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($oeffentlicherDienst, true), gettype($oeffentlicherDienst)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($oeffentlicherDienst) && !preg_match('/true|false/', $oeffentlicherDienst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($oeffentlicherDienst, true)), __LINE__);
        }
        $this->OeffentlicherDienst = $oeffentlicherDienst;
        return $this;
    }
    /**
     * Get AnteilAussendienst value
     * @return float|null
     */
    public function getAnteilAussendienst()
    {
        return $this->AnteilAussendienst;
    }
    /**
     * Set AnteilAussendienst value
     * @param float $anteilAussendienst
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setAnteilAussendienst($anteilAussendienst = null)
    {
        // validation for constraint: float
        if (!is_null($anteilAussendienst) && !(is_float($anteilAussendienst) || is_numeric($anteilAussendienst))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($anteilAussendienst, true), gettype($anteilAussendienst)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($anteilAussendienst) && $anteilAussendienst < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($anteilAussendienst, true)), __LINE__);
        }
        $this->AnteilAussendienst = $anteilAussendienst;
        return $this;
    }
    /**
     * Get Aufsichtsfuehrend value
     * @return bool|null
     */
    public function getAufsichtsfuehrend()
    {
        return $this->Aufsichtsfuehrend;
    }
    /**
     * Set Aufsichtsfuehrend value
     * @param bool $aufsichtsfuehrend
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setAufsichtsfuehrend($aufsichtsfuehrend = null)
    {
        // validation for constraint: boolean
        if (!is_null($aufsichtsfuehrend) && !is_bool($aufsichtsfuehrend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aufsichtsfuehrend, true), gettype($aufsichtsfuehrend)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($aufsichtsfuehrend) && !preg_match('/true|false/', $aufsichtsfuehrend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($aufsichtsfuehrend, true)), __LINE__);
        }
        $this->Aufsichtsfuehrend = $aufsichtsfuehrend;
        return $this;
    }
    /**
     * Get Mitarbeitend value
     * @return bool|null
     */
    public function getMitarbeitend()
    {
        return $this->Mitarbeitend;
    }
    /**
     * Set Mitarbeitend value
     * @param bool $mitarbeitend
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setMitarbeitend($mitarbeitend = null)
    {
        // validation for constraint: boolean
        if (!is_null($mitarbeitend) && !is_bool($mitarbeitend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mitarbeitend, true), gettype($mitarbeitend)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($mitarbeitend) && !preg_match('/true|false/', $mitarbeitend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($mitarbeitend, true)), __LINE__);
        }
        $this->Mitarbeitend = $mitarbeitend;
        return $this;
    }
    /**
     * Get Berufsschluessel value
     * @return string|null
     */
    public function getBerufsschluessel()
    {
        return $this->Berufsschluessel;
    }
    /**
     * Set Berufsschluessel value
     * @param string $berufsschluessel
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setBerufsschluessel($berufsschluessel = null)
    {
        // validation for constraint: string
        if (!is_null($berufsschluessel) && !is_string($berufsschluessel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($berufsschluessel, true), gettype($berufsschluessel)), __LINE__);
        }
        $this->Berufsschluessel = $berufsschluessel;
        return $this;
    }
    /**
     * Get NichtKoerperlichTaetig value
     * @return float|null
     */
    public function getNichtKoerperlichTaetig()
    {
        return $this->NichtKoerperlichTaetig;
    }
    /**
     * Set NichtKoerperlichTaetig value
     * @param float $nichtKoerperlichTaetig
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setNichtKoerperlichTaetig($nichtKoerperlichTaetig = null)
    {
        // validation for constraint: float
        if (!is_null($nichtKoerperlichTaetig) && !(is_float($nichtKoerperlichTaetig) || is_numeric($nichtKoerperlichTaetig))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nichtKoerperlichTaetig, true), gettype($nichtKoerperlichTaetig)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($nichtKoerperlichTaetig) && $nichtKoerperlichTaetig < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($nichtKoerperlichTaetig, true)), __LINE__);
        }
        $this->NichtKoerperlichTaetig = $nichtKoerperlichTaetig;
        return $this;
    }
    /**
     * Get Gewerbesteuerpflichtig value
     * @return bool|null
     */
    public function getGewerbesteuerpflichtig()
    {
        return $this->Gewerbesteuerpflichtig;
    }
    /**
     * Set Gewerbesteuerpflichtig value
     * @param bool $gewerbesteuerpflichtig
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setGewerbesteuerpflichtig($gewerbesteuerpflichtig = null)
    {
        // validation for constraint: boolean
        if (!is_null($gewerbesteuerpflichtig) && !is_bool($gewerbesteuerpflichtig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gewerbesteuerpflichtig, true), gettype($gewerbesteuerpflichtig)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($gewerbesteuerpflichtig) && !preg_match('/true|false/', $gewerbesteuerpflichtig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($gewerbesteuerpflichtig, true)), __LINE__);
        }
        $this->Gewerbesteuerpflichtig = $gewerbesteuerpflichtig;
        return $this;
    }
    /**
     * Get Praxisform value
     * @return string|null
     */
    public function getPraxisform()
    {
        return $this->Praxisform;
    }
    /**
     * Set Praxisform value
     * @uses \BiPRO\EnumType\ST_Praxisform::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Praxisform::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $praxisform
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setPraxisform($praxisform = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Praxisform::valueIsValid($praxisform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Praxisform', is_array($praxisform) ? implode(', ', $praxisform) : var_export($praxisform, true), implode(', ', \BiPRO\EnumType\ST_Praxisform::getValidValues())), __LINE__);
        }
        $this->Praxisform = $praxisform;
        return $this;
    }
    /**
     * Get Einkommen value
     * @return \BiPRO\StructType\CT_Einkommensart|null
     */
    public function getEinkommen()
    {
        return $this->Einkommen;
    }
    /**
     * Set Einkommen value
     * @param \BiPRO\StructType\CT_Einkommensart $einkommen
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setEinkommen(\BiPRO\StructType\CT_Einkommensart $einkommen = null)
    {
        $this->Einkommen = $einkommen;
        return $this;
    }
    /**
     * Get StellungImBerufSeit value
     * @return string|null
     */
    public function getStellungImBerufSeit()
    {
        return $this->StellungImBerufSeit;
    }
    /**
     * Set StellungImBerufSeit value
     * @param string $stellungImBerufSeit
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setStellungImBerufSeit($stellungImBerufSeit = null)
    {
        // validation for constraint: string
        if (!is_null($stellungImBerufSeit) && !is_string($stellungImBerufSeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stellungImBerufSeit, true), gettype($stellungImBerufSeit)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($stellungImBerufSeit) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $stellungImBerufSeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($stellungImBerufSeit, true)), __LINE__);
        }
        $this->StellungImBerufSeit = $stellungImBerufSeit;
        return $this;
    }
    /**
     * Get Berufsschluesselverzeichnis value
     * @return \BiPRO\StructType\STE_Berufsschluesselverzeichnis|null
     */
    public function getBerufsschluesselverzeichnis()
    {
        return $this->Berufsschluesselverzeichnis;
    }
    /**
     * Set Berufsschluesselverzeichnis value
     * @param \BiPRO\StructType\STE_Berufsschluesselverzeichnis $berufsschluesselverzeichnis
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setBerufsschluesselverzeichnis(\BiPRO\StructType\STE_Berufsschluesselverzeichnis $berufsschluesselverzeichnis = null)
    {
        $this->Berufsschluesselverzeichnis = $berufsschluesselverzeichnis;
        return $this;
    }
    /**
     * Get Arbeitgeber value
     * @return \BiPRO\StructType\CT_Arbeitgeber|null
     */
    public function getArbeitgeber()
    {
        return $this->Arbeitgeber;
    }
    /**
     * Set Arbeitgeber value
     * @param \BiPRO\StructType\CT_Arbeitgeber $arbeitgeber
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setArbeitgeber(\BiPRO\StructType\CT_Arbeitgeber $arbeitgeber = null)
    {
        $this->Arbeitgeber = $arbeitgeber;
        return $this;
    }
    /**
     * Get Teilzeit value
     * @return \BiPRO\StructType\CT_Teilzeit|null
     */
    public function getTeilzeit()
    {
        return $this->Teilzeit;
    }
    /**
     * Set Teilzeit value
     * @param \BiPRO\StructType\CT_Teilzeit $teilzeit
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setTeilzeit(\BiPRO\StructType\CT_Teilzeit $teilzeit = null)
    {
        $this->Teilzeit = $teilzeit;
        return $this;
    }
    /**
     * Get Grenzgaenger value
     * @return bool|null
     */
    public function getGrenzgaenger()
    {
        return $this->Grenzgaenger;
    }
    /**
     * Set Grenzgaenger value
     * @param bool $grenzgaenger
     * @return \BiPRO\StructType\CT_Berufstaetigkeit
     */
    public function setGrenzgaenger($grenzgaenger = null)
    {
        // validation for constraint: boolean
        if (!is_null($grenzgaenger) && !is_bool($grenzgaenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($grenzgaenger, true), gettype($grenzgaenger)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($grenzgaenger) && !preg_match('/true|false/', $grenzgaenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($grenzgaenger, true)), __LINE__);
        }
        $this->Grenzgaenger = $grenzgaenger;
        return $this;
    }
}
