<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_BankverbindungBasis StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zur Bankverbindung.
 * @subpackage Structs
 */
abstract class CT_BankverbindungBasis extends CT_Objekt
{
    /**
     * The Bankverbindung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bankverbindung;
    /**
     * The BIC
     * Meta information extracted from the WSDL
     * - documentation: Auspraegungen gemaess GDV-Satzart 0100, Teilsatz 4, Feld 16.Aufbau (Typ : Ausprägung):BBBB : 4-stelliger Bankcode, vom Geldinstitut frei wählbar (nur Alphazeichen),CC : 2-stelliger Ländercode nach ISO 3166-1 (nur Alphazeichen),LL
     * : 2-stellige Codierung des Ortes (alphanumerische Zeichen; zweites Zeichen = 1; passiver SWIFT-Teilnehmer),bbb : 3-stellige Kennzeichnung der Filiale oder Abteilung (optional, Standard: "XXX", kann weggelassen werden, andere Kennzeichen nicht)
     * (alphanumerische Zeichen)
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $BIC;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - documentation: IBAN (International Bank Account Number).Dient zur internationalen Identifikation von Bankkonten.Ausprägungen gemäß GDV-Satzart 0100, Teilsatz 4, Feld 18. Die IBAN setzt sich folgendermaßen zusammen: 2-stelliger Ländercode
     * gemäß ISO 3166-1 (Buchstaben) 2-stellige Prüfziffer gemäß ISO 7064 (Ziffern), max. 30-stellige Kontoidentifikation (8-stellige deutsche Bankleitzahl und die 10-stellige Kontonummer, Buchstaben und Ziffern). Die IBAN kann somit maximal 34 Stellen
     * umfassen. Zur besseren Lesbarkeit wird die IBAN in Vierergruppen eingeteilt. National können weitere Einschränkungen gemacht werden:Eine deutsche IBAN hat z.B. immer 22 Stellen, kürzere Kontonummern werden mit führenden Nullen auf 10 Stellen
     * erweitert.
     * - base: xsd:string
     * - maxLength: 34
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $IBAN;
    /**
     * The Institut
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Institut;
    /**
     * The Kontoinhaber
     * Meta information extracted from the WSDL
     * - documentation: Der Name des Kontoinhabers, falls abweichend vom Partner, von dem die Bankverbindung referenziert wird.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Kontoinhaber;
    /**
     * The Referenz
     * Meta information extracted from the WSDL
     * - documentation: Vom Provider generierte, eindeutige Referenznummer zur Identifizierung des Objektes über Prozesse hinweg, insbesondere zwischen Auskunfts- und Änderungsprozessen. | Allgemeiner Datentyp für alle externen, statischen Referenzen zur
     * Identifizierung von Objekten. Mit diesem Datentyp können Objekte über unterschiedliche Nachrichten (z.B. Auskunft und Änderung) hinweg identifiziert werden.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referenz;
    /**
     * Constructor method for CT_BankverbindungBasis
     * @uses CT_BankverbindungBasis::setBankverbindung()
     * @uses CT_BankverbindungBasis::setBIC()
     * @uses CT_BankverbindungBasis::setIBAN()
     * @uses CT_BankverbindungBasis::setInstitut()
     * @uses CT_BankverbindungBasis::setKontoinhaber()
     * @uses CT_BankverbindungBasis::setReferenz()
     * @param string $bankverbindung
     * @param string $bIC
     * @param string $iBAN
     * @param string $institut
     * @param string $kontoinhaber
     * @param string $referenz
     */
    public function __construct($bankverbindung = null, $bIC = null, $iBAN = null, $institut = null, $kontoinhaber = null, $referenz = null)
    {
        $this
            ->setBankverbindung($bankverbindung)
            ->setBIC($bIC)
            ->setIBAN($iBAN)
            ->setInstitut($institut)
            ->setKontoinhaber($kontoinhaber)
            ->setReferenz($referenz);
    }
    /**
     * Get Bankverbindung value
     * @return string|null
     */
    public function getBankverbindung()
    {
        return $this->Bankverbindung;
    }
    /**
     * Set Bankverbindung value
     * @uses \BiPRO\EnumType\ST_TypDerBankverbindung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_TypDerBankverbindung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bankverbindung
     * @return \BiPRO\StructType\CT_BankverbindungBasis
     */
    public function setBankverbindung($bankverbindung = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_TypDerBankverbindung::valueIsValid($bankverbindung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_TypDerBankverbindung', is_array($bankverbindung) ? implode(', ', $bankverbindung) : var_export($bankverbindung, true), implode(', ', \BiPRO\EnumType\ST_TypDerBankverbindung::getValidValues())), __LINE__);
        }
        $this->Bankverbindung = $bankverbindung;
        return $this;
    }
    /**
     * Get BIC value
     * @return string|null
     */
    public function getBIC()
    {
        return $this->BIC;
    }
    /**
     * Set BIC value
     * @param string $bIC
     * @return \BiPRO\StructType\CT_BankverbindungBasis
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIC, true), gettype($bIC)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($bIC) && mb_strlen($bIC) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($bIC)), __LINE__);
        }
        // validation for constraint: minLength(8)
        if (!is_null($bIC) && mb_strlen($bIC) < 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 8', mb_strlen($bIC)), __LINE__);
        }
        $this->BIC = $bIC;
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return $this->IBAN;
    }
    /**
     * Set IBAN value
     * @param string $iBAN
     * @return \BiPRO\StructType\CT_BankverbindungBasis
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($iBAN) && mb_strlen($iBAN) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($iBAN)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($iBAN) && mb_strlen($iBAN) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($iBAN)), __LINE__);
        }
        $this->IBAN = $iBAN;
        return $this;
    }
    /**
     * Get Institut value
     * @return string|null
     */
    public function getInstitut()
    {
        return $this->Institut;
    }
    /**
     * Set Institut value
     * @param string $institut
     * @return \BiPRO\StructType\CT_BankverbindungBasis
     */
    public function setInstitut($institut = null)
    {
        // validation for constraint: string
        if (!is_null($institut) && !is_string($institut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($institut, true), gettype($institut)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($institut) && mb_strlen($institut) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($institut)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($institut) && mb_strlen($institut) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($institut)), __LINE__);
        }
        $this->Institut = $institut;
        return $this;
    }
    /**
     * Get Kontoinhaber value
     * @return string|null
     */
    public function getKontoinhaber()
    {
        return $this->Kontoinhaber;
    }
    /**
     * Set Kontoinhaber value
     * @param string $kontoinhaber
     * @return \BiPRO\StructType\CT_BankverbindungBasis
     */
    public function setKontoinhaber($kontoinhaber = null)
    {
        // validation for constraint: string
        if (!is_null($kontoinhaber) && !is_string($kontoinhaber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kontoinhaber, true), gettype($kontoinhaber)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($kontoinhaber) && mb_strlen($kontoinhaber) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($kontoinhaber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($kontoinhaber) && mb_strlen($kontoinhaber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($kontoinhaber)), __LINE__);
        }
        $this->Kontoinhaber = $kontoinhaber;
        return $this;
    }
    /**
     * Get Referenz value
     * @return string|null
     */
    public function getReferenz()
    {
        return $this->Referenz;
    }
    /**
     * Set Referenz value
     * @param string $referenz
     * @return \BiPRO\StructType\CT_BankverbindungBasis
     */
    public function setReferenz($referenz = null)
    {
        // validation for constraint: string
        if (!is_null($referenz) && !is_string($referenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenz, true), gettype($referenz)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenz) && mb_strlen($referenz) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenz)), __LINE__);
        }
        $this->Referenz = $referenz;
        return $this;
    }
}
