<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Bankverbindung StructType
 * Meta information extracted from the WSDL
 * - documentation: Bankverbindung, die zum SEPA-Bereich gehört.
 * @subpackage Structs
 */
class CT_Bankverbindung extends CT_BankverbindungBasis
{
    /**
     * The Kontonummer
     * Meta information extracted from the WSDL
     * - documentation: Abweichend vom GDV (dort sind 12 Stellen definiert).
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kontonummer;
    /**
     * The Bankleitzahl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 8
     * - maxOccurs: 1
     * - minLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $Bankleitzahl;
    /**
     * The Einzugsermaechtigung
     * Meta information extracted from the WSDL
     * - documentation: Die Einzugsermaechtigung DARF NICHT die Zahlungsart in der Klasse TAA ersetzen. Sie stellt lediglich fest, ob zu dieser Bankverbindung eine Einzugsermächtigung vorliegt. Die Ausprägung sagt aber nichts über die Zahlungsart eines
     * bestimmten Vertrages aus.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Einzugsermaechtigung;
    /**
     * Constructor method for CT_Bankverbindung
     * @uses CT_Bankverbindung::setKontonummer()
     * @uses CT_Bankverbindung::setBankleitzahl()
     * @uses CT_Bankverbindung::setEinzugsermaechtigung()
     * @param string $kontonummer
     * @param string $bankleitzahl
     * @param bool $einzugsermaechtigung
     */
    public function __construct($kontonummer = null, $bankleitzahl = null, $einzugsermaechtigung = null)
    {
        $this
            ->setKontonummer($kontonummer)
            ->setBankleitzahl($bankleitzahl)
            ->setEinzugsermaechtigung($einzugsermaechtigung);
    }
    /**
     * Get Kontonummer value
     * @return string|null
     */
    public function getKontonummer()
    {
        return $this->Kontonummer;
    }
    /**
     * Set Kontonummer value
     * @param string $kontonummer
     * @return \BiPRO\StructType\CT_Bankverbindung
     */
    public function setKontonummer($kontonummer = null)
    {
        // validation for constraint: string
        if (!is_null($kontonummer) && !is_string($kontonummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kontonummer, true), gettype($kontonummer)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kontonummer) && mb_strlen($kontonummer) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kontonummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kontonummer) && mb_strlen($kontonummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kontonummer)), __LINE__);
        }
        $this->Kontonummer = $kontonummer;
        return $this;
    }
    /**
     * Get Bankleitzahl value
     * @return string|null
     */
    public function getBankleitzahl()
    {
        return $this->Bankleitzahl;
    }
    /**
     * Set Bankleitzahl value
     * @param string $bankleitzahl
     * @return \BiPRO\StructType\CT_Bankverbindung
     */
    public function setBankleitzahl($bankleitzahl = null)
    {
        // validation for constraint: string
        if (!is_null($bankleitzahl) && !is_string($bankleitzahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankleitzahl, true), gettype($bankleitzahl)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($bankleitzahl) && mb_strlen($bankleitzahl) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($bankleitzahl)), __LINE__);
        }
        // validation for constraint: minLength(8)
        if (!is_null($bankleitzahl) && mb_strlen($bankleitzahl) < 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 8', mb_strlen($bankleitzahl)), __LINE__);
        }
        $this->Bankleitzahl = $bankleitzahl;
        return $this;
    }
    /**
     * Get Einzugsermaechtigung value
     * @return bool|null
     */
    public function getEinzugsermaechtigung()
    {
        return $this->Einzugsermaechtigung;
    }
    /**
     * Set Einzugsermaechtigung value
     * @param bool $einzugsermaechtigung
     * @return \BiPRO\StructType\CT_Bankverbindung
     */
    public function setEinzugsermaechtigung($einzugsermaechtigung = null)
    {
        // validation for constraint: boolean
        if (!is_null($einzugsermaechtigung) && !is_bool($einzugsermaechtigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($einzugsermaechtigung, true), gettype($einzugsermaechtigung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($einzugsermaechtigung) && !preg_match('/true|false/', $einzugsermaechtigung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($einzugsermaechtigung, true)), __LINE__);
        }
        $this->Einzugsermaechtigung = $einzugsermaechtigung;
        return $this;
    }
}
