<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Ausbildung StructType
 * Meta information extracted from the WSDL
 * - documentation: Das Objekt kann nur einmal geliefert werden. Abgebildet wird hier deshalb der höchste erzielte Abschluss.
 * @subpackage Structs
 */
class CT_Ausbildung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der Schul- oder Ausbildung
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\STE_Ausbildungsart
     */
    public $ArtID;
    /**
     * The Fachrichtung
     * Meta information extracted from the WSDL
     * - documentation: Freitext zur Ausbildungsart oder zum höchsten Abschluss
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Fachrichtung;
    /**
     * The Abschlussdatum
     * Meta information extracted from the WSDL
     * - documentation: Datum, an dem der Abschluss erzielt wurde. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Abschlussdatum;
    /**
     * The Firmeneintritt
     * Meta information extracted from the WSDL
     * - documentation: Zeitpunkt des Firmeneintritts im Ausbildungsbetrieb bei einer betrieblichen Ausbildung | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Firmeneintritt;
    /**
     * The HoechsterAbschluss
     * Meta information extracted from the WSDL
     * - documentation: Höchster Schul- oder Hochschulabschluss
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Bildungsabschluss
     */
    public $HoechsterAbschluss;
    /**
     * Constructor method for CT_Ausbildung
     * @uses CT_Ausbildung::setArtID()
     * @uses CT_Ausbildung::setFachrichtung()
     * @uses CT_Ausbildung::setAbschlussdatum()
     * @uses CT_Ausbildung::setFirmeneintritt()
     * @uses CT_Ausbildung::setHoechsterAbschluss()
     * @param \BiPRO\StructType\STE_Ausbildungsart $artID
     * @param string $fachrichtung
     * @param string $abschlussdatum
     * @param string $firmeneintritt
     * @param \BiPRO\StructType\STE_Bildungsabschluss $hoechsterAbschluss
     */
    public function __construct(\BiPRO\StructType\STE_Ausbildungsart $artID = null, $fachrichtung = null, $abschlussdatum = null, $firmeneintritt = null, \BiPRO\StructType\STE_Bildungsabschluss $hoechsterAbschluss = null)
    {
        $this
            ->setArtID($artID)
            ->setFachrichtung($fachrichtung)
            ->setAbschlussdatum($abschlussdatum)
            ->setFirmeneintritt($firmeneintritt)
            ->setHoechsterAbschluss($hoechsterAbschluss);
    }
    /**
     * Get ArtID value
     * @return \BiPRO\StructType\STE_Ausbildungsart
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @param \BiPRO\StructType\STE_Ausbildungsart $artID
     * @return \BiPRO\StructType\CT_Ausbildung
     */
    public function setArtID(\BiPRO\StructType\STE_Ausbildungsart $artID = null)
    {
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Fachrichtung value
     * @return string|null
     */
    public function getFachrichtung()
    {
        return $this->Fachrichtung;
    }
    /**
     * Set Fachrichtung value
     * @param string $fachrichtung
     * @return \BiPRO\StructType\CT_Ausbildung
     */
    public function setFachrichtung($fachrichtung = null)
    {
        // validation for constraint: string
        if (!is_null($fachrichtung) && !is_string($fachrichtung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fachrichtung, true), gettype($fachrichtung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($fachrichtung) && mb_strlen($fachrichtung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($fachrichtung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($fachrichtung) && mb_strlen($fachrichtung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($fachrichtung)), __LINE__);
        }
        $this->Fachrichtung = $fachrichtung;
        return $this;
    }
    /**
     * Get Abschlussdatum value
     * @return string|null
     */
    public function getAbschlussdatum()
    {
        return $this->Abschlussdatum;
    }
    /**
     * Set Abschlussdatum value
     * @param string $abschlussdatum
     * @return \BiPRO\StructType\CT_Ausbildung
     */
    public function setAbschlussdatum($abschlussdatum = null)
    {
        // validation for constraint: string
        if (!is_null($abschlussdatum) && !is_string($abschlussdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abschlussdatum, true), gettype($abschlussdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($abschlussdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $abschlussdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($abschlussdatum, true)), __LINE__);
        }
        $this->Abschlussdatum = $abschlussdatum;
        return $this;
    }
    /**
     * Get Firmeneintritt value
     * @return string|null
     */
    public function getFirmeneintritt()
    {
        return $this->Firmeneintritt;
    }
    /**
     * Set Firmeneintritt value
     * @param string $firmeneintritt
     * @return \BiPRO\StructType\CT_Ausbildung
     */
    public function setFirmeneintritt($firmeneintritt = null)
    {
        // validation for constraint: string
        if (!is_null($firmeneintritt) && !is_string($firmeneintritt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firmeneintritt, true), gettype($firmeneintritt)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($firmeneintritt) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $firmeneintritt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($firmeneintritt, true)), __LINE__);
        }
        $this->Firmeneintritt = $firmeneintritt;
        return $this;
    }
    /**
     * Get HoechsterAbschluss value
     * @return \BiPRO\StructType\STE_Bildungsabschluss|null
     */
    public function getHoechsterAbschluss()
    {
        return $this->HoechsterAbschluss;
    }
    /**
     * Set HoechsterAbschluss value
     * @param \BiPRO\StructType\STE_Bildungsabschluss $hoechsterAbschluss
     * @return \BiPRO\StructType\CT_Ausbildung
     */
    public function setHoechsterAbschluss(\BiPRO\StructType\STE_Bildungsabschluss $hoechsterAbschluss = null)
    {
        $this->HoechsterAbschluss = $hoechsterAbschluss;
        return $this;
    }
}
