<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_ArbeitsmaschineNutzung StructType
 * Meta information extracted from the WSDL
 * - documentation: Zur Abbildung der Nutzung einer Arbeitsmaschine.
 * @subpackage Structs
 */
class CT_ArbeitsmaschineNutzung extends CT_Fahrzeugnutzung
{
    /**
     * The BeUndEntladen
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, ob die Arbeitsmaschine für das Be- und Entladen eingesetzt wird.Ja = Die Arbeitsmaschine wird für das Be- und Entladen eingesetzt.Nein = Sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $BeUndEntladen;
    /**
     * The Leitungsarbeiten
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, ob die Arbeitsmaschine für Leitungsarbeiten eingesetzt wird.Ja = Die Arbeitsmaschine wird für Leitungsarbeiten eingesetzt.Nein = Sonst
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Leitungsarbeiten;
    /**
     * Constructor method for CT_ArbeitsmaschineNutzung
     * @uses CT_ArbeitsmaschineNutzung::setBeUndEntladen()
     * @uses CT_ArbeitsmaschineNutzung::setLeitungsarbeiten()
     * @param bool $beUndEntladen
     * @param bool $leitungsarbeiten
     */
    public function __construct($beUndEntladen = null, $leitungsarbeiten = null)
    {
        $this
            ->setBeUndEntladen($beUndEntladen)
            ->setLeitungsarbeiten($leitungsarbeiten);
    }
    /**
     * Get BeUndEntladen value
     * @return bool|null
     */
    public function getBeUndEntladen()
    {
        return $this->BeUndEntladen;
    }
    /**
     * Set BeUndEntladen value
     * @param bool $beUndEntladen
     * @return \BiPRO\StructType\CT_ArbeitsmaschineNutzung
     */
    public function setBeUndEntladen($beUndEntladen = null)
    {
        // validation for constraint: boolean
        if (!is_null($beUndEntladen) && !is_bool($beUndEntladen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($beUndEntladen, true), gettype($beUndEntladen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($beUndEntladen) && !preg_match('/true|false/', $beUndEntladen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($beUndEntladen, true)), __LINE__);
        }
        $this->BeUndEntladen = $beUndEntladen;
        return $this;
    }
    /**
     * Get Leitungsarbeiten value
     * @return bool|null
     */
    public function getLeitungsarbeiten()
    {
        return $this->Leitungsarbeiten;
    }
    /**
     * Set Leitungsarbeiten value
     * @param bool $leitungsarbeiten
     * @return \BiPRO\StructType\CT_ArbeitsmaschineNutzung
     */
    public function setLeitungsarbeiten($leitungsarbeiten = null)
    {
        // validation for constraint: boolean
        if (!is_null($leitungsarbeiten) && !is_bool($leitungsarbeiten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leitungsarbeiten, true), gettype($leitungsarbeiten)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($leitungsarbeiten) && !preg_match('/true|false/', $leitungsarbeiten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($leitungsarbeiten, true)), __LINE__);
        }
        $this->Leitungsarbeiten = $leitungsarbeiten;
        return $this;
    }
}
