<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_AntwortZahl StructType
 * Meta information extracted from the WSDL
 * - documentation: Ableitung der Klasse Antwort zur typisierten Übertragung einer Dezimalzahl als Antwort.
 * @subpackage Structs
 */
class CT_AntwortZahl extends CT_Antwort
{
    /**
     * The Zahl
     * Meta information extracted from the WSDL
     * - documentation: Antwort als Dezimalzahl
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Zahl;
    /**
     * Constructor method for CT_AntwortZahl
     * @uses CT_AntwortZahl::setZahl()
     * @param float $zahl
     */
    public function __construct($zahl = null)
    {
        $this
            ->setZahl($zahl);
    }
    /**
     * Get Zahl value
     * @return float
     */
    public function getZahl()
    {
        return $this->Zahl;
    }
    /**
     * Set Zahl value
     * @param float $zahl
     * @return \BiPRO\StructType\CT_AntwortZahl
     */
    public function setZahl($zahl = null)
    {
        // validation for constraint: float
        if (!is_null($zahl) && !(is_float($zahl) || is_numeric($zahl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zahl, true), gettype($zahl)), __LINE__);
        }
        $this->Zahl = $zahl;
        return $this;
    }
}
