<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_AntwortJaNein StructType
 * Meta information extracted from the WSDL
 * - documentation: Ableitung der Klasse Antwort zur typisierten Übertragung einer Ja-/Nein Antwort.
 * @subpackage Structs
 */
class CT_AntwortJaNein extends CT_Antwort
{
    /**
     * The Entscheidung
     * Meta information extracted from the WSDL
     * - documentation: Eine Antwortenscheidung aus Ja oder Nein
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: true|false
     * @var bool
     */
    public $Entscheidung;
    /**
     * Constructor method for CT_AntwortJaNein
     * @uses CT_AntwortJaNein::setEntscheidung()
     * @param bool $entscheidung
     */
    public function __construct($entscheidung = null)
    {
        $this
            ->setEntscheidung($entscheidung);
    }
    /**
     * Get Entscheidung value
     * @return bool
     */
    public function getEntscheidung()
    {
        return $this->Entscheidung;
    }
    /**
     * Set Entscheidung value
     * @param bool $entscheidung
     * @return \BiPRO\StructType\CT_AntwortJaNein
     */
    public function setEntscheidung($entscheidung = null)
    {
        // validation for constraint: boolean
        if (!is_null($entscheidung) && !is_bool($entscheidung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($entscheidung, true), gettype($entscheidung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($entscheidung) && !preg_match('/true|false/', $entscheidung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($entscheidung, true)), __LINE__);
        }
        $this->Entscheidung = $entscheidung;
        return $this;
    }
}
