<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_AntwortDatum StructType
 * Meta information extracted from the WSDL
 * - documentation: Ableitung der Klasse Antwort zur typisierten Übertragung eines Datums als Antwort.
 * @subpackage Structs
 */
class CT_AntwortDatum extends CT_Antwort
{
    /**
     * The Datum
     * Meta information extracted from the WSDL
     * - documentation: Datum als Antwort auf eine Datumsfrage | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Datum;
    /**
     * Constructor method for CT_AntwortDatum
     * @uses CT_AntwortDatum::setDatum()
     * @param string $datum
     */
    public function __construct($datum = null)
    {
        $this
            ->setDatum($datum);
    }
    /**
     * Get Datum value
     * @return string
     */
    public function getDatum()
    {
        return $this->Datum;
    }
    /**
     * Set Datum value
     * @param string $datum
     * @return \BiPRO\StructType\CT_AntwortDatum
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($datum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($datum, true)), __LINE__);
        }
        $this->Datum = $datum;
        return $this;
    }
}
