<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_AnstossbereichKfz StructType
 * Meta information extracted from the WSDL
 * - documentation: Bereich an einem Fahrzeug, an dem ein Anstoß erfolgte oder nicht erfolgte. Die Klasse wird nur bei einer Kollision genutzt.
 * @subpackage Structs
 */
class CT_AnstossbereichKfz extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Bereich des Anstoßes.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The AnstossErfolgt
     * Meta information extracted from the WSDL
     * - documentation: JA = In diesem Bereich erfolgte ein Anstoß.NEIN = In diesem Bereich erfolgte kein Anstoß.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: true|false
     * @var bool
     */
    public $AnstossErfolgt;
    /**
     * The Anstossstaerke
     * Meta information extracted from the WSDL
     * - documentation: Stärke des Anstoßes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Anstossstaerke;
    /**
     * The DateiID
     * Meta information extracted from the WSDL
     * - documentation: Referenz auf eine Datei zu diesem Anstoßbereich, z.B. ein Foto.Dabei MUSS die entsprechende Datei innerhalb dieser Nachricht ([Geschaeftsvorgang].Datei) übertragen werden und Anstossbereich.DateiID MUSS der ID der Datei
     * (Datei.DateiID) entsprechen.Es können mehrere Dateien zu einem Anstossbereich übermittelt werden. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: unbounded
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $DateiID;
    /**
     * Constructor method for CT_AnstossbereichKfz
     * @uses CT_AnstossbereichKfz::setArtID()
     * @uses CT_AnstossbereichKfz::setAnstossErfolgt()
     * @uses CT_AnstossbereichKfz::setAnstossstaerke()
     * @uses CT_AnstossbereichKfz::setDateiID()
     * @param string $artID
     * @param bool $anstossErfolgt
     * @param string $anstossstaerke
     * @param string[] $dateiID
     */
    public function __construct($artID = null, $anstossErfolgt = null, $anstossstaerke = null, array $dateiID = array())
    {
        $this
            ->setArtID($artID)
            ->setAnstossErfolgt($anstossErfolgt)
            ->setAnstossstaerke($anstossstaerke)
            ->setDateiID($dateiID);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Anstossbereich::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Anstossbereich::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_AnstossbereichKfz
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Anstossbereich::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Anstossbereich', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Anstossbereich::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get AnstossErfolgt value
     * @return bool
     */
    public function getAnstossErfolgt()
    {
        return $this->AnstossErfolgt;
    }
    /**
     * Set AnstossErfolgt value
     * @param bool $anstossErfolgt
     * @return \BiPRO\StructType\CT_AnstossbereichKfz
     */
    public function setAnstossErfolgt($anstossErfolgt = null)
    {
        // validation for constraint: boolean
        if (!is_null($anstossErfolgt) && !is_bool($anstossErfolgt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anstossErfolgt, true), gettype($anstossErfolgt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($anstossErfolgt) && !preg_match('/true|false/', $anstossErfolgt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($anstossErfolgt, true)), __LINE__);
        }
        $this->AnstossErfolgt = $anstossErfolgt;
        return $this;
    }
    /**
     * Get Anstossstaerke value
     * @return string|null
     */
    public function getAnstossstaerke()
    {
        return $this->Anstossstaerke;
    }
    /**
     * Set Anstossstaerke value
     * @uses \BiPRO\EnumType\ST_Staerkegrad::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Staerkegrad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anstossstaerke
     * @return \BiPRO\StructType\CT_AnstossbereichKfz
     */
    public function setAnstossstaerke($anstossstaerke = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Staerkegrad::valueIsValid($anstossstaerke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Staerkegrad', is_array($anstossstaerke) ? implode(', ', $anstossstaerke) : var_export($anstossstaerke, true), implode(', ', \BiPRO\EnumType\ST_Staerkegrad::getValidValues())), __LINE__);
        }
        $this->Anstossstaerke = $anstossstaerke;
        return $this;
    }
    /**
     * Get DateiID value
     * @return string[]|null
     */
    public function getDateiID()
    {
        return $this->DateiID;
    }
    /**
     * This method is responsible for validating the values passed to the setDateiID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateiID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateiIDForArrayConstraintsFromSetDateiID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_AnstossbereichKfzDateiIDItem) {
            // validation for constraint: itemType
            if (!is_string($cT_AnstossbereichKfzDateiIDItem)) {
                $invalidValues[] = is_object($cT_AnstossbereichKfzDateiIDItem) ? get_class($cT_AnstossbereichKfzDateiIDItem) : sprintf('%s(%s)', gettype($cT_AnstossbereichKfzDateiIDItem), var_export($cT_AnstossbereichKfzDateiIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DateiID property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDateiID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateiID method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateiIDForMinLengthConstraintFromSetDateiID($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_AnstossbereichKfzDateiIDItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($cT_AnstossbereichKfzDateiIDItem) < 1) {
                $invalidValues[] = var_export($cT_AnstossbereichKfzDateiIDItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DateiID value
     * @throws \InvalidArgumentException
     * @param string[] $dateiID
     * @return \BiPRO\StructType\CT_AnstossbereichKfz
     */
    public function setDateiID(array $dateiID = array())
    {
        // validation for constraint: array
        if ('' !== ($dateiIDArrayErrorMessage = self::validateDateiIDForArrayConstraintsFromSetDateiID($dateiID))) {
            throw new \InvalidArgumentException($dateiIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($dateiIDMinLengthErrorMessage = self::validateDateiIDForMinLengthConstraintFromSetDateiID($dateiID))) {
            throw new \InvalidArgumentException($dateiIDMinLengthErrorMessage, __LINE__);
        }
        $this->DateiID = $dateiID;
        return $this;
    }
    /**
     * Add item to DateiID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_AnstossbereichKfz
     */
    public function addToDateiID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DateiID property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->DateiID[] = $item;
        return $this;
    }
}
