<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Anlage StructType
 * Meta information extracted from the WSDL
 * - documentation: Anlage wie z.B. eine EDV-Anlage, eine Dreh-Maschine oder ein Drucker.
 * @subpackage Structs
 */
class CT_Anlage extends CT_Gegenstand
{
    /**
     * The Objektkennziffer
     * Meta information extracted from the WSDL
     * - documentation: Genaue Objektbeschreibung nach GDV-Anlage 48
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\STE_Objektkennziffer
     */
    public $Objektkennziffer;
    /**
     * The Hersteller
     * Meta information extracted from the WSDL
     * - documentation: Hersteller der Anlage.
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Hersteller;
    /**
     * The Typ
     * Meta information extracted from the WSDL
     * - documentation: Anlagentyp
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Typ;
    /**
     * The Nummer
     * Meta information extracted from the WSDL
     * - documentation: Anlagennummer
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Nummer;
    /**
     * The Zubehoer
     * Meta information extracted from the WSDL
     * - documentation: Anlagenzubehör
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Zubehoer;
    /**
     * The Baujahr
     * Meta information extracted from the WSDL
     * - documentation: Baujahr der Anlage
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Baujahr;
    /**
     * The Leistung
     * Meta information extracted from the WSDL
     * - documentation: Leistung der Anlage.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Leistung;
    /**
     * The LeistungWerteinheit
     * Meta information extracted from the WSDL
     * - documentation: Werteinheit der Leistung der Anlage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LeistungWerteinheit;
    /**
     * The Inventarnummer
     * Meta information extracted from the WSDL
     * - documentation: Textfeld zur Angabe einer Inventarnummer der Anlage beim Kunden.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Inventarnummer;
    /**
     * The Kaufpreis
     * Meta information extracted from the WSDL
     * - documentation: Kaufpreis der Anlage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Kaufpreis
     */
    public $Kaufpreis;
    /**
     * The Neuwert
     * Meta information extracted from the WSDL
     * - documentation: Neuwert der Anlage
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Neuwert
     */
    public $Neuwert;
    /**
     * The Betriebsstunden
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Betriebsstunden der Anlage.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Betriebsstunden;
    /**
     * The Sicherungsglaeubiger
     * Meta information extracted from the WSDL
     * - documentation: Sicherungsgläubiger einer Anlage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Sicherungsglaeubiger
     */
    public $Sicherungsglaeubiger;
    /**
     * Constructor method for CT_Anlage
     * @uses CT_Anlage::setObjektkennziffer()
     * @uses CT_Anlage::setHersteller()
     * @uses CT_Anlage::setTyp()
     * @uses CT_Anlage::setNummer()
     * @uses CT_Anlage::setZubehoer()
     * @uses CT_Anlage::setBaujahr()
     * @uses CT_Anlage::setLeistung()
     * @uses CT_Anlage::setLeistungWerteinheit()
     * @uses CT_Anlage::setInventarnummer()
     * @uses CT_Anlage::setKaufpreis()
     * @uses CT_Anlage::setNeuwert()
     * @uses CT_Anlage::setBetriebsstunden()
     * @uses CT_Anlage::setSicherungsglaeubiger()
     * @param \BiPRO\StructType\STE_Objektkennziffer $objektkennziffer
     * @param string $hersteller
     * @param string $typ
     * @param string $nummer
     * @param string $zubehoer
     * @param int $baujahr
     * @param float $leistung
     * @param string $leistungWerteinheit
     * @param string $inventarnummer
     * @param \BiPRO\StructType\CT_Kaufpreis $kaufpreis
     * @param \BiPRO\StructType\CT_Neuwert $neuwert
     * @param float $betriebsstunden
     * @param \BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger
     */
    public function __construct(\BiPRO\StructType\STE_Objektkennziffer $objektkennziffer = null, $hersteller = null, $typ = null, $nummer = null, $zubehoer = null, $baujahr = null, $leistung = null, $leistungWerteinheit = null, $inventarnummer = null, \BiPRO\StructType\CT_Kaufpreis $kaufpreis = null, \BiPRO\StructType\CT_Neuwert $neuwert = null, $betriebsstunden = null, \BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger = null)
    {
        $this
            ->setObjektkennziffer($objektkennziffer)
            ->setHersteller($hersteller)
            ->setTyp($typ)
            ->setNummer($nummer)
            ->setZubehoer($zubehoer)
            ->setBaujahr($baujahr)
            ->setLeistung($leistung)
            ->setLeistungWerteinheit($leistungWerteinheit)
            ->setInventarnummer($inventarnummer)
            ->setKaufpreis($kaufpreis)
            ->setNeuwert($neuwert)
            ->setBetriebsstunden($betriebsstunden)
            ->setSicherungsglaeubiger($sicherungsglaeubiger);
    }
    /**
     * Get Objektkennziffer value
     * @return \BiPRO\StructType\STE_Objektkennziffer|null
     */
    public function getObjektkennziffer()
    {
        return $this->Objektkennziffer;
    }
    /**
     * Set Objektkennziffer value
     * @param \BiPRO\StructType\STE_Objektkennziffer $objektkennziffer
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setObjektkennziffer(\BiPRO\StructType\STE_Objektkennziffer $objektkennziffer = null)
    {
        $this->Objektkennziffer = $objektkennziffer;
        return $this;
    }
    /**
     * Get Hersteller value
     * @return string|null
     */
    public function getHersteller()
    {
        return $this->Hersteller;
    }
    /**
     * Set Hersteller value
     * @param string $hersteller
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setHersteller($hersteller = null)
    {
        // validation for constraint: string
        if (!is_null($hersteller) && !is_string($hersteller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hersteller, true), gettype($hersteller)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($hersteller) && mb_strlen($hersteller) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($hersteller)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hersteller) && mb_strlen($hersteller) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hersteller)), __LINE__);
        }
        $this->Hersteller = $hersteller;
        return $this;
    }
    /**
     * Get Typ value
     * @return string|null
     */
    public function getTyp()
    {
        return $this->Typ;
    }
    /**
     * Set Typ value
     * @param string $typ
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setTyp($typ = null)
    {
        // validation for constraint: string
        if (!is_null($typ) && !is_string($typ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typ, true), gettype($typ)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($typ) && mb_strlen($typ) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($typ)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($typ) && mb_strlen($typ) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($typ)), __LINE__);
        }
        $this->Typ = $typ;
        return $this;
    }
    /**
     * Get Nummer value
     * @return string|null
     */
    public function getNummer()
    {
        return $this->Nummer;
    }
    /**
     * Set Nummer value
     * @param string $nummer
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setNummer($nummer = null)
    {
        // validation for constraint: string
        if (!is_null($nummer) && !is_string($nummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nummer, true), gettype($nummer)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($nummer) && mb_strlen($nummer) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($nummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nummer) && mb_strlen($nummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nummer)), __LINE__);
        }
        $this->Nummer = $nummer;
        return $this;
    }
    /**
     * Get Zubehoer value
     * @return string|null
     */
    public function getZubehoer()
    {
        return $this->Zubehoer;
    }
    /**
     * Set Zubehoer value
     * @param string $zubehoer
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setZubehoer($zubehoer = null)
    {
        // validation for constraint: string
        if (!is_null($zubehoer) && !is_string($zubehoer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zubehoer, true), gettype($zubehoer)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($zubehoer) && mb_strlen($zubehoer) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($zubehoer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($zubehoer) && mb_strlen($zubehoer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($zubehoer)), __LINE__);
        }
        $this->Zubehoer = $zubehoer;
        return $this;
    }
    /**
     * Get Baujahr value
     * @return int|null
     */
    public function getBaujahr()
    {
        return $this->Baujahr;
    }
    /**
     * Set Baujahr value
     * @param int $baujahr
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setBaujahr($baujahr = null)
    {
        // validation for constraint: int
        if (!is_null($baujahr) && !(is_int($baujahr) || ctype_digit($baujahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baujahr, true), gettype($baujahr)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($baujahr) && mb_strlen(preg_replace('/(\D)/', '', $baujahr)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($baujahr, true), mb_strlen(preg_replace('/(\D)/', '', $baujahr))), __LINE__);
        }
        $this->Baujahr = $baujahr;
        return $this;
    }
    /**
     * Get Leistung value
     * @return float|null
     */
    public function getLeistung()
    {
        return $this->Leistung;
    }
    /**
     * Set Leistung value
     * @param float $leistung
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setLeistung($leistung = null)
    {
        // validation for constraint: float
        if (!is_null($leistung) && !(is_float($leistung) || is_numeric($leistung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($leistung, true), gettype($leistung)), __LINE__);
        }
        $this->Leistung = $leistung;
        return $this;
    }
    /**
     * Get LeistungWerteinheit value
     * @return string|null
     */
    public function getLeistungWerteinheit()
    {
        return $this->LeistungWerteinheit;
    }
    /**
     * Set LeistungWerteinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $leistungWerteinheit
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setLeistungWerteinheit($leistungWerteinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($leistungWerteinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($leistungWerteinheit) ? implode(', ', $leistungWerteinheit) : var_export($leistungWerteinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->LeistungWerteinheit = $leistungWerteinheit;
        return $this;
    }
    /**
     * Get Inventarnummer value
     * @return string|null
     */
    public function getInventarnummer()
    {
        return $this->Inventarnummer;
    }
    /**
     * Set Inventarnummer value
     * @param string $inventarnummer
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setInventarnummer($inventarnummer = null)
    {
        // validation for constraint: string
        if (!is_null($inventarnummer) && !is_string($inventarnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventarnummer, true), gettype($inventarnummer)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($inventarnummer) && mb_strlen($inventarnummer) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($inventarnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($inventarnummer) && mb_strlen($inventarnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($inventarnummer)), __LINE__);
        }
        $this->Inventarnummer = $inventarnummer;
        return $this;
    }
    /**
     * Get Kaufpreis value
     * @return \BiPRO\StructType\CT_Kaufpreis|null
     */
    public function getKaufpreis()
    {
        return $this->Kaufpreis;
    }
    /**
     * Set Kaufpreis value
     * @param \BiPRO\StructType\CT_Kaufpreis $kaufpreis
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setKaufpreis(\BiPRO\StructType\CT_Kaufpreis $kaufpreis = null)
    {
        $this->Kaufpreis = $kaufpreis;
        return $this;
    }
    /**
     * Get Neuwert value
     * @return \BiPRO\StructType\CT_Neuwert|null
     */
    public function getNeuwert()
    {
        return $this->Neuwert;
    }
    /**
     * Set Neuwert value
     * @param \BiPRO\StructType\CT_Neuwert $neuwert
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setNeuwert(\BiPRO\StructType\CT_Neuwert $neuwert = null)
    {
        $this->Neuwert = $neuwert;
        return $this;
    }
    /**
     * Get Betriebsstunden value
     * @return float|null
     */
    public function getBetriebsstunden()
    {
        return $this->Betriebsstunden;
    }
    /**
     * Set Betriebsstunden value
     * @param float $betriebsstunden
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setBetriebsstunden($betriebsstunden = null)
    {
        // validation for constraint: float
        if (!is_null($betriebsstunden) && !(is_float($betriebsstunden) || is_numeric($betriebsstunden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($betriebsstunden, true), gettype($betriebsstunden)), __LINE__);
        }
        $this->Betriebsstunden = $betriebsstunden;
        return $this;
    }
    /**
     * Get Sicherungsglaeubiger value
     * @return \BiPRO\StructType\CT_Sicherungsglaeubiger|null
     */
    public function getSicherungsglaeubiger()
    {
        return $this->Sicherungsglaeubiger;
    }
    /**
     * Set Sicherungsglaeubiger value
     * @param \BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger
     * @return \BiPRO\StructType\CT_Anlage
     */
    public function setSicherungsglaeubiger(\BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger = null)
    {
        $this->Sicherungsglaeubiger = $sicherungsglaeubiger;
        return $this;
    }
}
