<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_AnderweitigerVersicherungsschutz StructType
 * Meta information extracted from the WSDL
 * - documentation: Informationen zu einem Versicherungsschutz für den Schaden, der durch einen anderen Versicherungvertrag besteht als der Vertrag, gegen den der Anspruch geltend gemacht wird.
 * @subpackage Structs
 */
class CT_AnderweitigerVersicherungsschutz extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art des anderweitigen Versicherungsschutzes.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArtID;
    /**
     * The Beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Erläuterung zum anderweitigen Versicherungsschutz.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Beschreibung;
    /**
     * The SchadenAngezeigt
     * Meta information extracted from the WSDL
     * - documentation: Schaden beim Versicherer des anderweitigen Versicherungsschutzes angezeigt
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SchadenAngezeigt;
    /**
     * The Unternehmen
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsunternehmen, bei dem der Vertrag gedeckt ist, auf den sich der anderweitige Versicherungsschutz bezieht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Unternehmen
     */
    public $Unternehmen;
    /**
     * The Vertragsnummer
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsscheinnummer für den Vertrag, auf den sich der anderweitige Versicherungsschutz bezieht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Vertragsnummer
     */
    public $Vertragsnummer;
    /**
     * Constructor method for CT_AnderweitigerVersicherungsschutz
     * @uses CT_AnderweitigerVersicherungsschutz::setArtID()
     * @uses CT_AnderweitigerVersicherungsschutz::setBeschreibung()
     * @uses CT_AnderweitigerVersicherungsschutz::setSchadenAngezeigt()
     * @uses CT_AnderweitigerVersicherungsschutz::setUnternehmen()
     * @uses CT_AnderweitigerVersicherungsschutz::setVertragsnummer()
     * @param string $artID
     * @param string $beschreibung
     * @param bool $schadenAngezeigt
     * @param \BiPRO\StructType\CT_Unternehmen $unternehmen
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer
     */
    public function __construct($artID = null, $beschreibung = null, $schadenAngezeigt = null, \BiPRO\StructType\CT_Unternehmen $unternehmen = null, \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer = null)
    {
        $this
            ->setArtID($artID)
            ->setBeschreibung($beschreibung)
            ->setSchadenAngezeigt($schadenAngezeigt)
            ->setUnternehmen($unternehmen)
            ->setVertragsnummer($vertragsnummer);
    }
    /**
     * Get ArtID value
     * @return string
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_AnderweitigerVersicherungsschutz::valueIsValid()
     * @uses \BiPRO\EnumType\ST_AnderweitigerVersicherungsschutz::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_AnderweitigerVersicherungsschutz::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_AnderweitigerVersicherungsschutz', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_AnderweitigerVersicherungsschutz::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->Beschreibung;
    }
    /**
     * Set Beschreibung value
     * @param string $beschreibung
     * @return \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($beschreibung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($beschreibung) && mb_strlen($beschreibung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($beschreibung)), __LINE__);
        }
        $this->Beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get SchadenAngezeigt value
     * @return bool|null
     */
    public function getSchadenAngezeigt()
    {
        return $this->SchadenAngezeigt;
    }
    /**
     * Set SchadenAngezeigt value
     * @param bool $schadenAngezeigt
     * @return \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz
     */
    public function setSchadenAngezeigt($schadenAngezeigt = null)
    {
        // validation for constraint: boolean
        if (!is_null($schadenAngezeigt) && !is_bool($schadenAngezeigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($schadenAngezeigt, true), gettype($schadenAngezeigt)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($schadenAngezeigt) && !preg_match('/true|false/', $schadenAngezeigt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($schadenAngezeigt, true)), __LINE__);
        }
        $this->SchadenAngezeigt = $schadenAngezeigt;
        return $this;
    }
    /**
     * Get Unternehmen value
     * @return \BiPRO\StructType\CT_Unternehmen|null
     */
    public function getUnternehmen()
    {
        return $this->Unternehmen;
    }
    /**
     * Set Unternehmen value
     * @param \BiPRO\StructType\CT_Unternehmen $unternehmen
     * @return \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz
     */
    public function setUnternehmen(\BiPRO\StructType\CT_Unternehmen $unternehmen = null)
    {
        $this->Unternehmen = $unternehmen;
        return $this;
    }
    /**
     * Get Vertragsnummer value
     * @return \BiPRO\StructType\CT_Vertragsnummer|null
     */
    public function getVertragsnummer()
    {
        return $this->Vertragsnummer;
    }
    /**
     * Set Vertragsnummer value
     * @param \BiPRO\StructType\CT_Vertragsnummer $vertragsnummer
     * @return \BiPRO\StructType\CT_AnderweitigerVersicherungsschutz
     */
    public function setVertragsnummer(\BiPRO\StructType\CT_Vertragsnummer $vertragsnummer = null)
    {
        $this->Vertragsnummer = $vertragsnummer;
        return $this;
    }
}
