<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Aktivitaet StructType
 * @subpackage Structs
 */
abstract class CT_Aktivitaet extends CT_Objekt
{
    /**
     * The AktivitaetID
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige Identifikationsnummer zur Referenzierung des Objektes innerhalb des Datenaustauschs. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $AktivitaetID;
    /**
     * The Referenz
     * Meta information extracted from the WSDL
     * - documentation: Vom Provider generierte, eindeutige Referenznummer zur Identifizierung des Objektes über Prozesse hinweg, insbesondere zwischen Auskunfts- und Änderungsprozessen. | Allgemeiner Datentyp für alle externen, statischen Referenzen zur
     * Identifizierung von Objekten. Mit diesem Datentyp können Objekte über unterschiedliche Nachrichten (z.B. Auskunft und Änderung) hinweg identifiziert werden.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referenz;
    /**
     * Constructor method for CT_Aktivitaet
     * @uses CT_Aktivitaet::setAktivitaetID()
     * @uses CT_Aktivitaet::setReferenz()
     * @param string $aktivitaetID
     * @param string $referenz
     */
    public function __construct($aktivitaetID = null, $referenz = null)
    {
        $this
            ->setAktivitaetID($aktivitaetID)
            ->setReferenz($referenz);
    }
    /**
     * Get AktivitaetID value
     * @return string
     */
    public function getAktivitaetID()
    {
        return $this->AktivitaetID;
    }
    /**
     * Set AktivitaetID value
     * @param string $aktivitaetID
     * @return \BiPRO\StructType\CT_Aktivitaet
     */
    public function setAktivitaetID($aktivitaetID = null)
    {
        // validation for constraint: string
        if (!is_null($aktivitaetID) && !is_string($aktivitaetID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktivitaetID, true), gettype($aktivitaetID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($aktivitaetID) && mb_strlen($aktivitaetID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($aktivitaetID)), __LINE__);
        }
        $this->AktivitaetID = $aktivitaetID;
        return $this;
    }
    /**
     * Get Referenz value
     * @return string|null
     */
    public function getReferenz()
    {
        return $this->Referenz;
    }
    /**
     * Set Referenz value
     * @param string $referenz
     * @return \BiPRO\StructType\CT_Aktivitaet
     */
    public function setReferenz($referenz = null)
    {
        // validation for constraint: string
        if (!is_null($referenz) && !is_string($referenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenz, true), gettype($referenz)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenz) && mb_strlen($referenz) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenz)), __LINE__);
        }
        $this->Referenz = $referenz;
        return $this;
    }
}
