<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Adresse StructType
 * Meta information extracted from the WSDL
 * - documentation: Basisklasse von der alle Anschriften abgeleitet werden.
 * @subpackage Structs
 */
abstract class CT_Adresse extends CT_Objekt
{
    /**
     * The Strasse
     * Meta information extracted from the WSDL
     * - documentation: Strasse der AdresseHinweis: Es kann eine optionale Rückmeldung an die Datenquelle im Status erfolgen, wenn ein Abschneiden der Feldlänge des Attributes notwendig ist.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Strasse;
    /**
     * The Hausnummer
     * Meta information extracted from the WSDL
     * - documentation: Hausnummer der Adresse. Für Meldungen zur ZfA DARF die Hausnummer NICHT länger als 9-stellig übermittelt werden.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Hausnummer;
    /**
     * The Postleitzahl
     * Meta information extracted from the WSDL
     * - documentation: Postleitzahl der Adresse.Für Meldungen zur ZfA MUSS die Postleitzahl 5-stellig übermittelt werden: Bei Inlandanschriften wird die fünfstellige Postleitzahl eingetragen.Bei Auslandsanschriften sind für den Aufbau der
     * ausländischen Anschrift zwei Möglichkeiten vorgesehen:1. Das Länderkennzeichen wird im Attribut "Land" mit ST_Laenderkennzeichen aufgenommen. Das Feld "Postleitzahl" ist mit der fiktiven Postleitzahl "99999" zu füllen. Die tatsächliche
     * Postleitzahl ist gemäß den jeweiligen postalischen Ländervorgaben im Attribut "Ort" zu hinterlegen.2. Sofern das Länderkennzeichen nicht getrennt übermittelt werden kann, wird das Attribut "Land" nicht belegt. Das Attribut "Postleitzahl" wird
     * ebenfalls mit der fiktiven Postleitzahl "99999" gefüllt. Das Attribut "Ort" ist mit dem Länderkennzeichen1, der Postleitzahl und dem Wohnort gemäß den postalischen Ländervorgaben zu füllen.Beispiele für Auslandsanschriften:Land Postleitzahl
     * OrtAT 99999 1011 Wien99999 DK-8410 R0nde99999 New York, NY 10006-US
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Postleitzahl;
    /**
     * The Ort
     * Meta information extracted from the WSDL
     * - documentation: Ort der Adresse. Hinweis: Es kann eine optionale Rückmeldung an die Datenquelle im Status erfolgen, wenn ein Abschneiden der Feldlänge des Attributes notwendig ist.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Ort;
    /**
     * The Land
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Land;
    /**
     * The Landname
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Landname;
    /**
     * The Ortsteil
     * Meta information extracted from the WSDL
     * - documentation: Ortsteil (ggf. für ZÜRS relevant)
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Ortsteil;
    /**
     * The Referenz
     * Meta information extracted from the WSDL
     * - documentation: Vom Provider generierte, eindeutige Referenznummer zur Identifizierung des Objektes über Prozesse hinweg, insbesondere zwischen Auskunfts- und Änderungsprozessen. | Allgemeiner Datentyp für alle externen, statischen Referenzen zur
     * Identifizierung von Objekten. Mit diesem Datentyp können Objekte über unterschiedliche Nachrichten (z.B. Auskunft und Änderung) hinweg identifiziert werden.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Referenz;
    /**
     * The Geoposition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Geoposition
     */
    public $Geoposition;
    /**
     * Constructor method for CT_Adresse
     * @uses CT_Adresse::setStrasse()
     * @uses CT_Adresse::setHausnummer()
     * @uses CT_Adresse::setPostleitzahl()
     * @uses CT_Adresse::setOrt()
     * @uses CT_Adresse::setLand()
     * @uses CT_Adresse::setLandname()
     * @uses CT_Adresse::setOrtsteil()
     * @uses CT_Adresse::setReferenz()
     * @uses CT_Adresse::setGeoposition()
     * @param string $strasse
     * @param string $hausnummer
     * @param string $postleitzahl
     * @param string $ort
     * @param string $land
     * @param string $landname
     * @param string $ortsteil
     * @param string $referenz
     * @param \BiPRO\StructType\CT_Geoposition $geoposition
     */
    public function __construct($strasse = null, $hausnummer = null, $postleitzahl = null, $ort = null, $land = null, $landname = null, $ortsteil = null, $referenz = null, \BiPRO\StructType\CT_Geoposition $geoposition = null)
    {
        $this
            ->setStrasse($strasse)
            ->setHausnummer($hausnummer)
            ->setPostleitzahl($postleitzahl)
            ->setOrt($ort)
            ->setLand($land)
            ->setLandname($landname)
            ->setOrtsteil($ortsteil)
            ->setReferenz($referenz)
            ->setGeoposition($geoposition);
    }
    /**
     * Get Strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->Strasse;
    }
    /**
     * Set Strasse value
     * @param string $strasse
     * @return \BiPRO\StructType\CT_Adresse
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($strasse) && mb_strlen($strasse) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($strasse)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($strasse) && mb_strlen($strasse) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($strasse)), __LINE__);
        }
        $this->Strasse = $strasse;
        return $this;
    }
    /**
     * Get Hausnummer value
     * @return string|null
     */
    public function getHausnummer()
    {
        return $this->Hausnummer;
    }
    /**
     * Set Hausnummer value
     * @param string $hausnummer
     * @return \BiPRO\StructType\CT_Adresse
     */
    public function setHausnummer($hausnummer = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummer) && !is_string($hausnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummer, true), gettype($hausnummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($hausnummer) && mb_strlen($hausnummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($hausnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hausnummer) && mb_strlen($hausnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hausnummer)), __LINE__);
        }
        $this->Hausnummer = $hausnummer;
        return $this;
    }
    /**
     * Get Postleitzahl value
     * @return string|null
     */
    public function getPostleitzahl()
    {
        return $this->Postleitzahl;
    }
    /**
     * Set Postleitzahl value
     * @param string $postleitzahl
     * @return \BiPRO\StructType\CT_Adresse
     */
    public function setPostleitzahl($postleitzahl = null)
    {
        // validation for constraint: string
        if (!is_null($postleitzahl) && !is_string($postleitzahl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postleitzahl, true), gettype($postleitzahl)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postleitzahl) && mb_strlen($postleitzahl) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postleitzahl)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postleitzahl) && mb_strlen($postleitzahl) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postleitzahl)), __LINE__);
        }
        $this->Postleitzahl = $postleitzahl;
        return $this;
    }
    /**
     * Get Ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->Ort;
    }
    /**
     * Set Ort value
     * @param string $ort
     * @return \BiPRO\StructType\CT_Adresse
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($ort) && mb_strlen($ort) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($ort)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ort) && mb_strlen($ort) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ort)), __LINE__);
        }
        $this->Ort = $ort;
        return $this;
    }
    /**
     * Get Land value
     * @return string|null
     */
    public function getLand()
    {
        return $this->Land;
    }
    /**
     * Set Land value
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $land
     * @return \BiPRO\StructType\CT_Adresse
     */
    public function setLand($land = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Laenderkennzeichen', is_array($land) ? implode(', ', $land) : var_export($land, true), implode(', ', \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues())), __LINE__);
        }
        $this->Land = $land;
        return $this;
    }
    /**
     * Get Landname value
     * @return string|null
     */
    public function getLandname()
    {
        return $this->Landname;
    }
    /**
     * Set Landname value
     * @param string $landname
     * @return \BiPRO\StructType\CT_Adresse
     */
    public function setLandname($landname = null)
    {
        // validation for constraint: string
        if (!is_null($landname) && !is_string($landname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landname, true), gettype($landname)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($landname) && mb_strlen($landname) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($landname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($landname) && mb_strlen($landname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($landname)), __LINE__);
        }
        $this->Landname = $landname;
        return $this;
    }
    /**
     * Get Ortsteil value
     * @return string|null
     */
    public function getOrtsteil()
    {
        return $this->Ortsteil;
    }
    /**
     * Set Ortsteil value
     * @param string $ortsteil
     * @return \BiPRO\StructType\CT_Adresse
     */
    public function setOrtsteil($ortsteil = null)
    {
        // validation for constraint: string
        if (!is_null($ortsteil) && !is_string($ortsteil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ortsteil, true), gettype($ortsteil)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ortsteil) && mb_strlen($ortsteil) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($ortsteil)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ortsteil) && mb_strlen($ortsteil) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ortsteil)), __LINE__);
        }
        $this->Ortsteil = $ortsteil;
        return $this;
    }
    /**
     * Get Referenz value
     * @return string|null
     */
    public function getReferenz()
    {
        return $this->Referenz;
    }
    /**
     * Set Referenz value
     * @param string $referenz
     * @return \BiPRO\StructType\CT_Adresse
     */
    public function setReferenz($referenz = null)
    {
        // validation for constraint: string
        if (!is_null($referenz) && !is_string($referenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenz, true), gettype($referenz)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenz) && mb_strlen($referenz) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenz)), __LINE__);
        }
        $this->Referenz = $referenz;
        return $this;
    }
    /**
     * Get Geoposition value
     * @return \BiPRO\StructType\CT_Geoposition|null
     */
    public function getGeoposition()
    {
        return $this->Geoposition;
    }
    /**
     * Set Geoposition value
     * @param \BiPRO\StructType\CT_Geoposition $geoposition
     * @return \BiPRO\StructType\CT_Adresse
     */
    public function setGeoposition(\BiPRO\StructType\CT_Geoposition $geoposition = null)
    {
        $this->Geoposition = $geoposition;
        return $this;
    }
}
