<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Abtretungsglaeubiger StructType
 * Meta information extracted from the WSDL
 * - documentation: Gläubiger der abgetretenen Kapitalanlage.
 * @subpackage Structs
 */
class CT_Abtretungsglaeubiger extends CT_Partnerrolle
{
    /**
     * The DatumDerAbtretung
     * Meta information extracted from the WSDL
     * - documentation: Datum der Abtretung. | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $DatumDerAbtretung;
    /**
     * The Rangfolge
     * Meta information extracted from the WSDL
     * - documentation: Rangfolge des Abtretungsgläubigers.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Rangfolge;
    /**
     * The AnteiligerBetrag
     * Meta information extracted from the WSDL
     * - documentation: Anteiliger Betrag des Abtretungsgläubigers an der gesamten Kapitalanlage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_AnteiligerBetrag
     */
    public $AnteiligerBetrag;
    /**
     * Constructor method for CT_Abtretungsglaeubiger
     * @uses CT_Abtretungsglaeubiger::setDatumDerAbtretung()
     * @uses CT_Abtretungsglaeubiger::setRangfolge()
     * @uses CT_Abtretungsglaeubiger::setAnteiligerBetrag()
     * @param string $datumDerAbtretung
     * @param int $rangfolge
     * @param \BiPRO\StructType\CT_AnteiligerBetrag $anteiligerBetrag
     */
    public function __construct($datumDerAbtretung = null, $rangfolge = null, \BiPRO\StructType\CT_AnteiligerBetrag $anteiligerBetrag = null)
    {
        $this
            ->setDatumDerAbtretung($datumDerAbtretung)
            ->setRangfolge($rangfolge)
            ->setAnteiligerBetrag($anteiligerBetrag);
    }
    /**
     * Get DatumDerAbtretung value
     * @return string|null
     */
    public function getDatumDerAbtretung()
    {
        return $this->DatumDerAbtretung;
    }
    /**
     * Set DatumDerAbtretung value
     * @param string $datumDerAbtretung
     * @return \BiPRO\StructType\CT_Abtretungsglaeubiger
     */
    public function setDatumDerAbtretung($datumDerAbtretung = null)
    {
        // validation for constraint: string
        if (!is_null($datumDerAbtretung) && !is_string($datumDerAbtretung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumDerAbtretung, true), gettype($datumDerAbtretung)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($datumDerAbtretung) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $datumDerAbtretung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($datumDerAbtretung, true)), __LINE__);
        }
        $this->DatumDerAbtretung = $datumDerAbtretung;
        return $this;
    }
    /**
     * Get Rangfolge value
     * @return int|null
     */
    public function getRangfolge()
    {
        return $this->Rangfolge;
    }
    /**
     * Set Rangfolge value
     * @param int $rangfolge
     * @return \BiPRO\StructType\CT_Abtretungsglaeubiger
     */
    public function setRangfolge($rangfolge = null)
    {
        // validation for constraint: int
        if (!is_null($rangfolge) && !(is_int($rangfolge) || ctype_digit($rangfolge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rangfolge, true), gettype($rangfolge)), __LINE__);
        }
        $this->Rangfolge = $rangfolge;
        return $this;
    }
    /**
     * Get AnteiligerBetrag value
     * @return \BiPRO\StructType\CT_AnteiligerBetrag|null
     */
    public function getAnteiligerBetrag()
    {
        return $this->AnteiligerBetrag;
    }
    /**
     * Set AnteiligerBetrag value
     * @param \BiPRO\StructType\CT_AnteiligerBetrag $anteiligerBetrag
     * @return \BiPRO\StructType\CT_Abtretungsglaeubiger
     */
    public function setAnteiligerBetrag(\BiPRO\StructType\CT_AnteiligerBetrag $anteiligerBetrag = null)
    {
        $this->AnteiligerBetrag = $anteiligerBetrag;
        return $this;
    }
}
