<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Abhaengigkeit StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine Frage wird relevant, wenn der durch die Bedingung gebildete logische Ausdruck mit &bdquo;wahr&ldquo; bewertet wird. In der Klasse Abhängigkeit wird angegeben, mit welchem Vergleichsoperator die vom Anwender erfasste Antwort auf
 * eine bestimmte Frage mit einem vom Provider vorgebenen Antwortwert zu vergleichen ist.
 * @subpackage Structs
 */
class CT_Abhaengigkeit extends CT_Bedingung
{
    /**
     * The LinkerOperand
     * Meta information extracted from the WSDL
     * - documentation: Referenz auf die Frage, deren Antwort mit der vom Provider in der Abhängigkeit vorgegebenen Antwort zu vergleichen ist. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $LinkerOperand;
    /**
     * The Operator
     * Meta information extracted from the WSDL
     * - documentation: Vergleichsoperator zur Verknüpfung von Wert der Antwort und dem kritischen Wert.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Operator;
    /**
     * The RechterOperand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \BiPRO\StructType\CT_Antwort
     */
    public $RechterOperand;
    /**
     * Constructor method for CT_Abhaengigkeit
     * @uses CT_Abhaengigkeit::setLinkerOperand()
     * @uses CT_Abhaengigkeit::setOperator()
     * @uses CT_Abhaengigkeit::setRechterOperand()
     * @param string $linkerOperand
     * @param string $operator
     * @param \BiPRO\StructType\CT_Antwort $rechterOperand
     */
    public function __construct($linkerOperand = null, $operator = null, \BiPRO\StructType\CT_Antwort $rechterOperand = null)
    {
        $this
            ->setLinkerOperand($linkerOperand)
            ->setOperator($operator)
            ->setRechterOperand($rechterOperand);
    }
    /**
     * Get LinkerOperand value
     * @return string
     */
    public function getLinkerOperand()
    {
        return $this->LinkerOperand;
    }
    /**
     * Set LinkerOperand value
     * @param string $linkerOperand
     * @return \BiPRO\StructType\CT_Abhaengigkeit
     */
    public function setLinkerOperand($linkerOperand = null)
    {
        // validation for constraint: string
        if (!is_null($linkerOperand) && !is_string($linkerOperand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkerOperand, true), gettype($linkerOperand)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($linkerOperand) && mb_strlen($linkerOperand) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($linkerOperand)), __LINE__);
        }
        $this->LinkerOperand = $linkerOperand;
        return $this;
    }
    /**
     * Get Operator value
     * @return string
     */
    public function getOperator()
    {
        return $this->Operator;
    }
    /**
     * Set Operator value
     * @uses \BiPRO\EnumType\ST_Operator::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Operator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \BiPRO\StructType\CT_Abhaengigkeit
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Operator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Operator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \BiPRO\EnumType\ST_Operator::getValidValues())), __LINE__);
        }
        $this->Operator = $operator;
        return $this;
    }
    /**
     * Get RechterOperand value
     * @return \BiPRO\StructType\CT_Antwort
     */
    public function getRechterOperand()
    {
        return $this->RechterOperand;
    }
    /**
     * Set RechterOperand value
     * @param \BiPRO\StructType\CT_Antwort $rechterOperand
     * @return \BiPRO\StructType\CT_Abhaengigkeit
     */
    public function setRechterOperand(\BiPRO\StructType\CT_Antwort $rechterOperand = null)
    {
        $this->RechterOperand = $rechterOperand;
        return $this;
    }
}
