<?php

namespace BiPRO\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setNotification
     * Meta information extracted from the WSDL
     * - documentation: Meldung von Schäden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \BiPRO\StructType\SetNotification $parameters
     * @return \BiPRO\StructType\SetNotificationResponse|bool
     */
    public function setNotification(\BiPRO\StructType\SetNotification $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->setNotification($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \BiPRO\StructType\SetNotificationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
