<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_Unternehmensnummernart EnumType
 * @subpackage Enumerations
 */
class ST_Unternehmensnummernart extends AbstractStructEnumBase
{
    /**
     * Constant for value 'AGIK'
     * Meta information extracted from the WSDL
     * - documentation: Identifikation gem. der Nummer der Arbeitsgemeinschaft Institutionskennzeichen.Für folgende Träger und Einrichtungen gibt es diese IK-Nummer: KV-Träger; RV-Träger; UV-Träger; Sozialhilfeträger; Bundesagentur für Arbeit,
     * Versorgungsämter; Gesundheitsämter; Pflegekassen;Träger der Gemeinschaftsaufgaben und Medizinischer Dienst der Krankenkassen, Medizinischer Dienst der Sozialversicherungsträger; Rehabilitationseinrichtungen der Rentenversicherungsträger
     * einschließlich der Knappschaft-Bahn-See; Krankenversicherungsträger außerhalb der GKV; Behörden des Bundes und der Länder, Gerichte.
     * @return string 'AGIK'
     */
    const VALUE_AGIK = 'AGIK';
    /**
     * Constant for value 'BaFin'
     * Meta information extracted from the WSDL
     * - documentation: Identifikation gem. der Nummer der Bundesanstalt für Finanzdienstleistungsaufsicht
     * @return string 'BaFin'
     */
    const VALUE_BA_FIN = 'BaFin';
    /**
     * Constant for value 'AnbNr'
     * Meta information extracted from the WSDL
     * - documentation: Riesteranbieternummer der ZfA
     * @return string 'AnbNr'
     */
    const VALUE_ANB_NR = 'AnbNr';
    /**
     * Constant for value 'IHK'
     * Meta information extracted from the WSDL
     * - documentation: IHK-Nummer des Vermittlers bzw. Assekuradeurs.
     * @return string 'IHK'
     */
    const VALUE_IHK = 'IHK';
    /**
     * Return allowed values
     * @uses self::VALUE_AGIK
     * @uses self::VALUE_BA_FIN
     * @uses self::VALUE_ANB_NR
     * @uses self::VALUE_IHK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AGIK,
            self::VALUE_BA_FIN,
            self::VALUE_ANB_NR,
            self::VALUE_IHK,
        );
    }
}
