<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_TransportmittelSchluessel EnumType
 * Meta information extracted from the WSDL
 * - documentation: In Anlehnung an GDV-Anlage 57.
 * @subpackage Enumerations
 */
class ST_TransportmittelSchluessel extends AbstractStructEnumBase
{
    /**
     * Constant for value '01'
     * Meta information extracted from the WSDL
     * - documentation: Gewerbl. LKW-Verkehr, nicht WVK
     * @return string '01'
     */
    const VALUE_01 = '01';
    /**
     * Constant for value '02'
     * Meta information extracted from the WSDL
     * - documentation: Bahn
     * @return string '02'
     */
    const VALUE_02 = '02';
    /**
     * Constant for value '03'
     * Meta information extracted from the WSDL
     * - documentation: Combined Transport, kein Spediteursammelgut. Transport des Transportgutes in einem Container (oder anderer verschlossener Transporteinheit) vom Sender zum Empfänger, ohne dass der Container auf der Reise ausgepackt wird. Dadurch
     * wird die Gefahr für das Transportgut reduziert.Hinweis: In der GDV-Anlage 57 werden die Schlüssel 03 Combined Transport und 90 multimodal fachlich synonym verwendet werden.
     * @return string '03'
     */
    const VALUE_03 = '03';
    /**
     * Constant for value '04'
     * Meta information extracted from the WSDL
     * - documentation: Messe, Ausstellung
     * @return string '04'
     */
    const VALUE_04 = '04';
    /**
     * Constant for value '05'
     * Meta information extracted from the WSDL
     * - documentation: Flussschiff, Lagerschiff, Leichter
     * @return string '05'
     */
    const VALUE_05 = '05';
    /**
     * Constant for value '06'
     * Meta information extracted from the WSDL
     * - documentation: PKW, private Verkehrsmittel
     * @return string '06'
     */
    const VALUE_06 = '06';
    /**
     * Constant for value '07'
     * Meta information extracted from the WSDL
     * - documentation: Kran und alle Hebevorgänge
     * @return string '07'
     */
    const VALUE_07 = '07';
    /**
     * Constant for value '08'
     * Meta information extracted from the WSDL
     * - documentation: Flugzeuge
     * @return string '08'
     */
    const VALUE_08 = '08';
    /**
     * Constant for value '09'
     * Meta information extracted from the WSDL
     * - documentation: Magazin, fremdes Lager
     * @return string '09'
     */
    const VALUE_09 = '09';
    /**
     * Constant for value '10'
     * Meta information extracted from the WSDL
     * - documentation: Post
     * @return string '10'
     */
    const VALUE_10 = '10';
    /**
     * Constant for value '11'
     * Meta information extracted from the WSDL
     * - documentation: Seeschiff, auch Kümo
     * @return string '11'
     */
    const VALUE_11 = '11';
    /**
     * Constant for value '12'
     * Meta information extracted from the WSDL
     * - documentation: Träger, Bote, Mensch
     * @return string '12'
     */
    const VALUE_12 = '12';
    /**
     * Constant for value '90'
     * Meta information extracted from the WSDL
     * - documentation: "multimodal" (verschiedenartige Transportmittel). Multimodal bedeutet, dass mehrere Transportmittel und ein Umladen bei einem Transport vorkommen, also z.B. LKW zum Hafen, dann Umladen des Transportgutes in einen Container und
     * Weitertransport auf einem Schiff, und am Zielhafen Ausladen aus dem Container und wieder mit dem LKW zum Empfänger.Hinweis: Nicht in GDV-Anlage 57 enthalten, dort werden die Schlüssel 03 Combined Transport und 90 multimodal fachlich synonym
     * verwendet werden.
     * @return string '90'
     */
    const VALUE_90 = '90';
    /**
     * Constant for value '99'
     * Meta information extracted from the WSDL
     * - documentation: Sonstige
     * @return string '99'
     */
    const VALUE_99 = '99';
    /**
     * Return allowed values
     * @uses self::VALUE_01
     * @uses self::VALUE_02
     * @uses self::VALUE_03
     * @uses self::VALUE_04
     * @uses self::VALUE_05
     * @uses self::VALUE_06
     * @uses self::VALUE_07
     * @uses self::VALUE_08
     * @uses self::VALUE_09
     * @uses self::VALUE_10
     * @uses self::VALUE_11
     * @uses self::VALUE_12
     * @uses self::VALUE_90
     * @uses self::VALUE_99
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_01,
            self::VALUE_02,
            self::VALUE_03,
            self::VALUE_04,
            self::VALUE_05,
            self::VALUE_06,
            self::VALUE_07,
            self::VALUE_08,
            self::VALUE_09,
            self::VALUE_10,
            self::VALUE_11,
            self::VALUE_12,
            self::VALUE_90,
            self::VALUE_99,
        );
    }
}
