<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_SchadenartUnfall EnumType
 * Meta information extracted from the WSDL
 * - documentation: Schadenart-Unfall gemäß GDV-Anlage 157 (Statistikschlüssel).
 * @subpackage Enumerations
 */
class ST_SchadenartUnfall extends AbstractStructEnumBase
{
    /**
     * Constant for value '01'
     * Meta information extracted from the WSDL
     * - documentation: Wegeunfall (Unfall auf dem Weg zur oder von der Arbeitsstätte/Schule)
     * @return string '01'
     */
    const VALUE_01 = '01';
    /**
     * Constant for value '02'
     * Meta information extracted from the WSDL
     * - documentation: Berufs-/Schulunfall (ohne Wegeunfall) im privaten häuslichen Bereich
     * @return string '02'
     */
    const VALUE_02 = '02';
    /**
     * Constant for value '03'
     * Meta information extracted from the WSDL
     * - documentation: Berufs-/Schulunfall (ohne Wegeunfall) außerhalb des privaten häuslichen Bereiches
     * @return string '03'
     */
    const VALUE_03 = '03';
    /**
     * Constant for value '04'
     * Meta information extracted from the WSDL
     * - documentation: Unfall bei Tätigkeit für den Haushalt und Einkäufen - im privaten häusllichen Bereich
     * @return string '04'
     */
    const VALUE_04 = '04';
    /**
     * Constant for value '05'
     * Meta information extracted from the WSDL
     * - documentation: Unfall bei Tätigkeit für den Haushalt und Einkäufen - außerhalb des privaten häuslichen Bereiches
     * @return string '05'
     */
    const VALUE_05 = '05';
    /**
     * Constant for value '06'
     * Meta information extracted from the WSDL
     * - documentation: Sonstige Unfälle im privaten häuslichen Bereich ohne Beziehung zur Tätigkeit für Haushalt
     * @return string '06'
     */
    const VALUE_06 = '06';
    /**
     * Constant for value '07'
     * Meta information extracted from the WSDL
     * - documentation: Sonstige Unfälle außerhalb des privaten häuslichen Bereichs ohne Beziehung zur Tätigkeit für Haushalt
     * @return string '07'
     */
    const VALUE_07 = '07';
    /**
     * Constant for value '08'
     * Meta information extracted from the WSDL
     * - documentation: Unfallart noch nicht bekannt
     * @return string '08'
     */
    const VALUE_08 = '08';
    /**
     * Constant for value '99'
     * Meta information extracted from the WSDL
     * - documentation: Sonstiges
     * @return string '99'
     */
    const VALUE_99 = '99';
    /**
     * Return allowed values
     * @uses self::VALUE_01
     * @uses self::VALUE_02
     * @uses self::VALUE_03
     * @uses self::VALUE_04
     * @uses self::VALUE_05
     * @uses self::VALUE_06
     * @uses self::VALUE_07
     * @uses self::VALUE_08
     * @uses self::VALUE_99
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_01,
            self::VALUE_02,
            self::VALUE_03,
            self::VALUE_04,
            self::VALUE_05,
            self::VALUE_06,
            self::VALUE_07,
            self::VALUE_08,
            self::VALUE_99,
        );
    }
}
