<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_Nachweisstatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Status zur Prüfung oder Übermittlung eines Nachweises
 * @subpackage Enumerations
 */
class ST_Nachweisstatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'kommt'
     * Meta information extracted from the WSDL
     * - documentation: Der Vermittler hat den Nachweis vom Antragsteller angefordert und übermittelt den Nachweis an den Versicherer unabhängig von der elektronischen Nachricht.
     * @return string 'kommt'
     */
    const VALUE_KOMMT = 'kommt';
    /**
     * Constant for value 'anfordern'
     * Meta information extracted from the WSDL
     * - documentation: Der Versicherer soll den Nachweis vom Antragsteller angefordern.
     * @return string 'anfordern'
     */
    const VALUE_ANFORDERN = 'anfordern';
    /**
     * Constant for value 'beigefuegt'
     * Meta information extracted from the WSDL
     * - documentation: Der Vermittler hat den Nachweis vom Antragsteller angefordert und übermittelt den Nachweis an den Versicherer innerhalb der elektronischen Nachricht.
     * @return string 'beigefuegt'
     */
    const VALUE_BEIGEFUEGT = 'beigefuegt';
    /**
     * Constant for value 'geprueft'
     * Meta information extracted from the WSDL
     * - documentation: Der Vermittler hat den Nachweis geprüft.
     * @return string 'geprueft'
     */
    const VALUE_GEPRUEFT = 'geprueft';
    /**
     * Return allowed values
     * @uses self::VALUE_KOMMT
     * @uses self::VALUE_ANFORDERN
     * @uses self::VALUE_BEIGEFUEGT
     * @uses self::VALUE_GEPRUEFT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KOMMT,
            self::VALUE_ANFORDERN,
            self::VALUE_BEIGEFUEGT,
            self::VALUE_GEPRUEFT,
        );
    }
}
