<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_MandatStatus EnumType
 * @subpackage Enumerations
 */
class ST_MandatStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Schwebe'
     * Meta information extracted from the WSDL
     * - documentation: Ein Mandat ist dann in Schwebe, wenn noch nicht alle notwendigen Daten vorliegen (z.B. die Unterschrift).
     * @return string 'Schwebe'
     */
    const VALUE_SCHWEBE = 'Schwebe';
    /**
     * Constant for value 'Aktiv'
     * Meta information extracted from the WSDL
     * - documentation: Ein unterschriebenes Mandat liegt vor und das Mandat wird genutzt.
     * @return string 'Aktiv'
     */
    const VALUE_AKTIV = 'Aktiv';
    /**
     * Constant for value 'Ruhend'
     * Meta information extracted from the WSDL
     * - documentation: Ein derzeit nicht genutztes, aber gültiges Mandat. Innerhalb von 36 Monaten nach der letzten Nutzung kann ein ruhend gestelltes Mandat in Abstimmung mit dem Zahler wieder verwendet (aktiv) werden.
     * @return string 'Ruhend'
     */
    const VALUE_RUHEND = 'Ruhend';
    /**
     * Constant for value 'Ungueltig'
     * Meta information extracted from the WSDL
     * - documentation: Das Mandat wurde vom Zahler explizit gekündigt oder das Mandat wurde 36 Monate nicht mehr aktiv genutzt. Es kann nicht wieder reaktiviert werden.
     * @return string 'Ungueltig'
     */
    const VALUE_UNGUELTIG = 'Ungueltig';
    /**
     * Return allowed values
     * @uses self::VALUE_SCHWEBE
     * @uses self::VALUE_AKTIV
     * @uses self::VALUE_RUHEND
     * @uses self::VALUE_UNGUELTIG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SCHWEBE,
            self::VALUE_AKTIV,
            self::VALUE_RUHEND,
            self::VALUE_UNGUELTIG,
        );
    }
}
