<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_Luftfahrzeugtyp EnumType
 * @subpackage Enumerations
 */
class ST_Luftfahrzeugtyp extends AbstractStructEnumBase
{
    /**
     * Constant for value '01'
     * Meta information extracted from the WSDL
     * - documentation: Motorflugzeug (Ein Flugzeug bzw. Motorflugzeug ist ein Luftfahrzeug, das schwerer als Luft ist. Für den zum Fliegen erforderlichen Auftrieb und für die Steuerung werden aerodynamische Effekte genutzt.)
     * @return string '01'
     */
    const VALUE_01 = '01';
    /**
     * Constant for value '02'
     * Meta information extracted from the WSDL
     * - documentation: Drehflügler (Zu der Luftfahrzeugklasse Drehflügler gehören Tragschrauber, Hubschrauber und Flugschrauber.)
     * @return string '02'
     */
    const VALUE_02 = '02';
    /**
     * Constant for value '03'
     * Meta information extracted from the WSDL
     * - documentation: Luftschiff (Ein Luftschiff ist ein lenkbares Luftfahrzeug, dessen Auftrieb auf aerostatischen Kräften beruht und das über einen eigenen Antrieb verfügt.)
     * @return string '03'
     */
    const VALUE_03 = '03';
    /**
     * Constant for value '04'
     * Meta information extracted from the WSDL
     * - documentation: Segelflugzeug (Ein Segelflugzeug ist ein für den Segelflug, also für motorloses Fliegen (Steigen im Aufwind beziehungsweise Gleiten mit geringem Höhenverlust) konstruiertes Luftfahrzeug. In Deutschland werden Segelflugzeuge
     * luftrechtlich als eigene Luftfahrzeugklasse gewertet und dürfen bis zu 850 kg wiegen.)
     * @return string '04'
     */
    const VALUE_04 = '04';
    /**
     * Constant for value '05'
     * Meta information extracted from the WSDL
     * - documentation: Motorsegler (Motorsegelflugzeuge, oft auch kurz Motorsegler genannt, sind Flugzeuge, denen grundsätzlich alternativ die Betriebsarten Motorflug und Segelflug möglich sind. Sie stellen in Deutschland, Österreich und der Schweiz
     * eine eigene Luftfahrzeugklasse dar. Entsprechende Maschinen tragen Kennungen, die mit D-K&hellip;, OE-9&hellip; oder HB-2&hellip; beginnen.)
     * @return string '05'
     */
    const VALUE_05 = '05';
    /**
     * Constant for value '06'
     * Meta information extracted from the WSDL
     * - documentation: Frei- und Fesselballon (Ein Freiballon ist ein freifliegender Ballon. Er muss als Gasballon mit einem Traggas, welches leichter als Luft ist, gefüllt werden oder als Heißluftballon ausgeführt sein. Freiballone werden zusammen mit
     * Fesselballonen (welche durch eine Leine eine ständige Verbindung zum Boden haben) in Deutschland luftrechtlich als eigene Luftfahrzeugklasse angesehen.)
     * @return string '06'
     */
    const VALUE_06 = '06';
    /**
     * Constant for value '07'
     * Meta information extracted from the WSDL
     * - documentation: Drachen (Ein Drachen ist ein Spiel- und Sportgerät, das mit Wind betrieben wird. Er besteht in der einfachsten Ausführung aus einem Segel, das in der Regel durch ein Gestänge aufgespannt wird und einer am Gestänge befestigten
     * Leine, die vom Drachensteigenden (im Drachensport oft: Pilot) gehalten wird.)
     * @return string '07'
     */
    const VALUE_07 = '07';
    /**
     * Constant for value '08'
     * Meta information extracted from the WSDL
     * - documentation: Flugmodell (Ein Flugmodell ist meist eine verkleinerte Nachbildung eines Luftfahrzeuges (Flugzeug, Hubschrauber, Rakete), wobei es weder eine scharfe Abgrenzung zum Spielzeug oder Sportgerät, noch zu kommerziellen,
     * wissenschaftlichen oder militärischen Anwendungen gibt, wie zum Beispiel ferngelenkten Drohnen.)
     * @return string '08'
     */
    const VALUE_08 = '08';
    /**
     * Constant for value '09'
     * Meta information extracted from the WSDL
     * - documentation: Luftsportgerät (Die Luftsportgeräte umfassen eine Gruppe von Fluggeräten, bei denen die Sportausübung als Hauptverwendungsszweck angesehen werden kann.)
     * @return string '09'
     */
    const VALUE_09 = '09';
    /**
     * Return allowed values
     * @uses self::VALUE_01
     * @uses self::VALUE_02
     * @uses self::VALUE_03
     * @uses self::VALUE_04
     * @uses self::VALUE_05
     * @uses self::VALUE_06
     * @uses self::VALUE_07
     * @uses self::VALUE_08
     * @uses self::VALUE_09
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_01,
            self::VALUE_02,
            self::VALUE_03,
            self::VALUE_04,
            self::VALUE_05,
            self::VALUE_06,
            self::VALUE_07,
            self::VALUE_08,
            self::VALUE_09,
        );
    }
}
