<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_LeistungsartBereich EnumType
 * Meta information extracted from the WSDL
 * - documentation: Bereich auf den sich die Rechtsschutzversicherung erstreckt. Verwendung nur im Kontext BiPRO Rechtsschutz
 * @subpackage Enumerations
 */
class ST_LeistungsartBereich extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Privat'
     * @return string 'Privat'
     */
    const VALUE_PRIVAT = 'Privat';
    /**
     * Constant for value 'Verkehr'
     * @return string 'Verkehr'
     */
    const VALUE_VERKEHR = 'Verkehr';
    /**
     * Constant for value 'Immobilie'
     * @return string 'Immobilie'
     */
    const VALUE_IMMOBILIE = 'Immobilie';
    /**
     * Constant for value 'Beruf'
     * @return string 'Beruf'
     */
    const VALUE_BERUF = 'Beruf';
    /**
     * Constant for value 'Gewerbe'
     * Meta information extracted from the WSDL
     * - documentation: Enthält auch Sonder und Spezial
     * @return string 'Gewerbe'
     */
    const VALUE_GEWERBE = 'Gewerbe';
    /**
     * Return allowed values
     * @uses self::VALUE_PRIVAT
     * @uses self::VALUE_VERKEHR
     * @uses self::VALUE_IMMOBILIE
     * @uses self::VALUE_BERUF
     * @uses self::VALUE_GEWERBE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRIVAT,
            self::VALUE_VERKEHR,
            self::VALUE_IMMOBILIE,
            self::VALUE_BERUF,
            self::VALUE_GEWERBE,
        );
    }
}
