<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_Lastschriftart EnumType
 * @subpackage Enumerations
 */
class ST_Lastschriftart extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Basislastschrift'
     * Meta information extracted from the WSDL
     * - documentation: Alle SEPA-Lastschriften, sofern es sich nicht um eine Firmenlastschrift handelt.
     * @return string 'Basislastschrift'
     */
    const VALUE_BASISLASTSCHRIFT = 'Basislastschrift';
    /**
     * Constant for value 'Firmenlastschrift'
     * Meta information extracted from the WSDL
     * - documentation: Die SEPA-Firmenlastschrift (SEPA Business to Business Direct Debit) ist auf den Zahlungsverkehr zwischen Unternehmen ausgelegt. Dementsprechend darf es sich beim Debitor nicht um einen privaten Endkunden handeln, sondern
     * ausschließlich um einen Geschäfts- oder Firmenkunden. Nach der Einlösung der SEPA-Firmenlastschrift ist keine Rückbuchung durch den Zahlungspflichtigen mehr möglich.
     * @return string 'Firmenlastschrift'
     */
    const VALUE_FIRMENLASTSCHRIFT = 'Firmenlastschrift';
    /**
     * Return allowed values
     * @uses self::VALUE_BASISLASTSCHRIFT
     * @uses self::VALUE_FIRMENLASTSCHRIFT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASISLASTSCHRIFT,
            self::VALUE_FIRMENLASTSCHRIFT,
        );
    }
}
