<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_KrankenVorversicherungsschutz EnumType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zur Art des Vorversicherungsschutz. "Keine Vorversicherung" zur Angabe, dass kein Vorversicherungsschutz bestand, z.B. kein unmittelbarer Vorversicherungsschutz bei Zuzug aus dem Ausland oder wenn Eltern nicht versichert
 * sind.
 * @subpackage Enumerations
 */
class ST_KrankenVorversicherungsschutz extends AbstractStructEnumBase
{
    /**
     * Constant for value '01'
     * Meta information extracted from the WSDL
     * - documentation: gesetzlich freiwillig krankenversichert
     * @return string '01'
     */
    const VALUE_01 = '01';
    /**
     * Constant for value '02'
     * Meta information extracted from the WSDL
     * - documentation: gesetzlich pflichtig krankenversichert
     * @return string '02'
     */
    const VALUE_02 = '02';
    /**
     * Constant for value '03'
     * Meta information extracted from the WSDL
     * - documentation: gesetzlich krankenversichert (ohne nähere Zuordnung)
     * @return string '03'
     */
    const VALUE_03 = '03';
    /**
     * Constant for value '04'
     * Meta information extracted from the WSDL
     * - documentation: privat krankenversichert
     * @return string '04'
     */
    const VALUE_04 = '04';
    /**
     * Constant for value '05'
     * Meta information extracted from the WSDL
     * - documentation: freie Heilfürsorge
     * @return string '05'
     */
    const VALUE_05 = '05';
    /**
     * Constant for value '06'
     * Meta information extracted from the WSDL
     * - documentation: ausländisch gesetzlich krankenversichert
     * @return string '06'
     */
    const VALUE_06 = '06';
    /**
     * Constant for value '07'
     * Meta information extracted from the WSDL
     * - documentation: ausländisch privat krankenversichert
     * @return string '07'
     */
    const VALUE_07 = '07';
    /**
     * Constant for value '99'
     * Meta information extracted from the WSDL
     * - documentation: keine Vorversicherung
     * @return string '99'
     */
    const VALUE_99 = '99';
    /**
     * Return allowed values
     * @uses self::VALUE_01
     * @uses self::VALUE_02
     * @uses self::VALUE_03
     * @uses self::VALUE_04
     * @uses self::VALUE_05
     * @uses self::VALUE_06
     * @uses self::VALUE_07
     * @uses self::VALUE_99
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_01,
            self::VALUE_02,
            self::VALUE_03,
            self::VALUE_04,
            self::VALUE_05,
            self::VALUE_06,
            self::VALUE_07,
            self::VALUE_99,
        );
    }
}
