<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_DokumentartID EnumType
 * Meta information extracted from the WSDL
 * - documentation: Auspraegungen gemaess oder in Anlehnung an GDV-Standard.
 * @subpackage Enumerations
 */
class ST_DokumentartID extends AbstractStructEnumBase
{
    /**
     * Constant for value 'A-Bescheinigung'
     * Meta information extracted from the WSDL
     * - documentation: Agrarier-Bescheinigung
     * @return string 'A-Bescheinigung'
     */
    const VALUE_A_BESCHEINIGUNG = 'A-Bescheinigung';
    /**
     * Constant for value 'Ablehnungsschreiben'
     * @return string 'Ablehnungsschreiben'
     */
    const VALUE_ABLEHNUNGSSCHREIBEN = 'Ablehnungsschreiben';
    /**
     * Constant for value 'Abnahmebestaetigung'
     * @return string 'Abnahmebestaetigung'
     */
    const VALUE_ABNAHMEBESTAETIGUNG = 'Abnahmebestaetigung';
    /**
     * Constant for value 'Abrechnung'
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichnet Abrechnungsdokumente
     * @return string 'Abrechnung'
     */
    const VALUE_ABRECHNUNG = 'Abrechnung';
    /**
     * Constant for value 'Abtretungserklaerung'
     * @return string 'Abtretungserklaerung'
     */
    const VALUE_ABTRETUNGSERKLAERUNG = 'Abtretungserklaerung';
    /**
     * Constant for value 'Aenderungsantrag'
     * Meta information extracted from the WSDL
     * - documentation: Antrag eines Service Consumers zur Änderung von Informationen (z.B. zu einem Partner oder Vertrag) beim Service Provider.
     * @return string 'Aenderungsantrag'
     */
    const VALUE_AENDERUNGSANTRAG = 'Aenderungsantrag';
    /**
     * Constant for value 'Angebot'
     * @return string 'Angebot'
     */
    const VALUE_ANGEBOT = 'Angebot';
    /**
     * Constant for value 'Angebotsanforderung'
     * Meta information extracted from the WSDL
     * - documentation: Angebotsanforderung=Formular für die Aufforderung zur Abgabe eines verbindlichen Angebotes im Sinne des Invitatiomodells
     * @return string 'Angebotsanforderung'
     */
    const VALUE_ANGEBOTSANFORDERUNG = 'Angebotsanforderung';
    /**
     * Constant for value 'Annahmebestaetigung'
     * @return string 'Annahmebestaetigung'
     */
    const VALUE_ANNAHMEBESTAETIGUNG = 'Annahmebestaetigung';
    /**
     * Constant for value 'Anschaffungsbeleg'
     * @return string 'Anschaffungsbeleg'
     */
    const VALUE_ANSCHAFFUNGSBELEG = 'Anschaffungsbeleg';
    /**
     * Constant for value 'Anschreiben'
     * @return string 'Anschreiben'
     */
    const VALUE_ANSCHREIBEN = 'Anschreiben';
    /**
     * Constant for value 'Anschuldigungsschrift'
     * @return string 'Anschuldigungsschrift'
     */
    const VALUE_ANSCHULDIGUNGSSCHRIFT = 'Anschuldigungsschrift';
    /**
     * Constant for value 'Antrag'
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsantrag ohne der nach VVG und VVG-Infoverordnung relevanten Informationen sowie ohne den Allgemeinen und Besonderen Bedingungen und Klauseln
     * @return string 'Antrag'
     */
    const VALUE_ANTRAG = 'Antrag';
    /**
     * Constant for value 'AntragAufZahlungAVWL'
     * Meta information extracted from the WSDL
     * - documentation: Antrag auf Zahlung AVWL
     * @return string 'AntragAufZahlungAVWL'
     */
    const VALUE_ANTRAG_AUF_ZAHLUNG_AVWL = 'AntragAufZahlungAVWL';
    /**
     * Constant for value 'AntragFondswechsel'
     * Meta information extracted from the WSDL
     * - documentation: Antragsformular für einen Fondswechsel.
     * @return string 'AntragFondswechsel'
     */
    const VALUE_ANTRAG_FONDSWECHSEL = 'AntragFondswechsel';
    /**
     * Constant for value 'AntragVVG'
     * Meta information extracted from the WSDL
     * - documentation: VVG-konformer Versicherungsantrag inkl. der nach VVG und VVG-Infoverordnung relevanten Informationen sowie den Allgemeinen und Besonderen edingungen inkl. Klauseln
     * @return string 'AntragVVG'
     */
    const VALUE_ANTRAG_VVG = 'AntragVVG';
    /**
     * Constant for value 'AntragZuzahlung'
     * Meta information extracted from the WSDL
     * - documentation: Formular für die Zuzahlung zu einem bestehenden Vertrag
     * @return string 'AntragZuzahlung'
     */
    const VALUE_ANTRAG_ZUZAHLUNG = 'AntragZuzahlung';
    /**
     * Constant for value 'Arbeitsnachweis'
     * @return string 'Arbeitsnachweis'
     */
    const VALUE_ARBEITSNACHWEIS = 'Arbeitsnachweis';
    /**
     * Constant for value 'Arztbericht'
     * @return string 'Arztbericht'
     */
    const VALUE_ARZTBERICHT = 'Arztbericht';
    /**
     * Constant for value 'Attest'
     * @return string 'Attest'
     */
    const VALUE_ATTEST = 'Attest';
    /**
     * Constant for value 'Auftrag'
     * @return string 'Auftrag'
     */
    const VALUE_AUFTRAG = 'Auftrag';
    /**
     * Constant for value 'AussergerichtlicheKorrespondenz'
     * Meta information extracted from the WSDL
     * - documentation: AussergerichtlicheKorrespondenz
     * @return string 'AussergerichtlicheKorrespondenz'
     */
    const VALUE_AUSSERGERICHTLICHE_KORRESPONDENZ = 'AussergerichtlicheKorrespondenz';
    /**
     * Constant for value 'AVB'
     * @return string 'AVB'
     */
    const VALUE_AVB = 'AVB';
    /**
     * Constant for value 'AZV-Belehrung'
     * Meta information extracted from the WSDL
     * - documentation: Anzeigepflichtverletzung-Belehrung
     * @return string 'AZV-Belehrung'
     */
    const VALUE_AZV_BELEHRUNG = 'AZV-Belehrung';
    /**
     * Constant for value 'B-Bescheinigung'
     * Meta information extracted from the WSDL
     * - documentation: Beamten-Bescheinigung
     * @return string 'B-Bescheinigung'
     */
    const VALUE_B_BESCHEINIGUNG = 'B-Bescheinigung';
    /**
     * Constant for value 'bAVUebertrag'
     * Meta information extracted from the WSDL
     * - documentation: Formular für die Übertragung einer bAV im Rahmen des Übertragungsabkommens (bAV)
     * @return string 'bAVUebertrag'
     */
    const VALUE_B_AVUEBERTRAG = 'bAVUebertrag';
    /**
     * Constant for value 'BeitragsbescheinigungFuerFinanzamt'
     * Meta information extracted from the WSDL
     * - documentation: Beitragsbescheinigung nach Norm ??? Vorschrift Finanzamt
     * @return string 'BeitragsbescheinigungFuerFinanzamt'
     */
    const VALUE_BEITRAGSBESCHEINIGUNG_FUER_FINANZAMT = 'BeitragsbescheinigungFuerFinanzamt';
    /**
     * Constant for value 'Beratungsprotokoll'
     * Meta information extracted from the WSDL
     * - documentation: Dokument, dass die Beratung protokolliert.
     * @return string 'Beratungsprotokoll'
     */
    const VALUE_BERATUNGSPROTOKOLL = 'Beratungsprotokoll';
    /**
     * Constant for value 'Berufung'
     * @return string 'Berufung'
     */
    const VALUE_BERUFUNG = 'Berufung';
    /**
     * Constant for value 'BescheinigungAblaufleistung'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung über die Ablaufleistung des Vertrags. Mögliche Inhalte: garantierte Werte (Kapital oder Rente), Werte inklusive angenommener Überschussbeteiligung, Werte zu Beginn der Abrufphase (Tarife mit Abrufoption),
     * Hochrechnung mit gleichmäßiger Wertsteigerung (Investment), Hochrechnung inklusive Überschüsse (Riester).
     * @return string 'BescheinigungAblaufleistung'
     */
    const VALUE_BESCHEINIGUNG_ABLAUFLEISTUNG = 'BescheinigungAblaufleistung';
    /**
     * Constant for value 'BescheinigungBeitraegeBisRueckkauf'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung über die bis zum Rückkauf eingezahlten Beiträge gemäß § 20 Abs. 2 Nr. 6 EStG
     * @return string 'BescheinigungBeitraegeBisRueckkauf'
     */
    const VALUE_BESCHEINIGUNG_BEITRAEGE_BIS_RUECKKAUF = 'BescheinigungBeitraegeBisRueckkauf';
    /**
     * Constant for value 'BescheinigungFuerArbeitsagentur'
     * Meta information extracted from the WSDL
     * - documentation: Information für die Agentur für Arbeit (Jobcenter) über Vertragswert (Rückkaufswert), eingezahlte Beiträge, Beginn und Ablauf/ Rentenbeginn, Ablauf Beitragszahlung, aktueller Beitrag, beitragsfreie Summe gemäß § 60 SGB II.
     * @return string 'BescheinigungFuerArbeitsagentur'
     */
    const VALUE_BESCHEINIGUNG_FUER_ARBEITSAGENTUR = 'BescheinigungFuerArbeitsagentur';
    /**
     * Constant for value 'BescheinigungFuerBAfoeGAmt'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung zur Vorlage beim Amt für Ausbildungsförderung. Mögliche Inhalte: Altersvorsorgebeitrag, Rückkaufswert, Rentenleistungen und Art und Umfang der Krankenversicherung.
     * @return string 'BescheinigungFuerBAfoeGAmt'
     */
    const VALUE_BESCHEINIGUNG_FUER_BAFOE_GAMT = 'BescheinigungFuerBAfoeGAmt';
    /**
     * Constant for value 'BescheinigungFuerSozialamt'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung zur Vorlage beim Sozialamt: Mögliche Inhalte: Altersvorsorgebeitrag, Rückkaufswert und Rentenleistungen.
     * @return string 'BescheinigungFuerSozialamt'
     */
    const VALUE_BESCHEINIGUNG_FUER_SOZIALAMT = 'BescheinigungFuerSozialamt';
    /**
     * Constant for value 'BescheinigungRueckkaufswert'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung über den Rückkaufswert des Vertrags zum angegebenen Stichtag. Mögliche Inhalte: garantierter Rückkaufswert, Überschüsse, Mindestbeteiligung an den Bewertungsreserven, Kapitalertragssteuer (inkl. Soli).
     * @return string 'BescheinigungRueckkaufswert'
     */
    const VALUE_BESCHEINIGUNG_RUECKKAUFSWERT = 'BescheinigungRueckkaufswert';
    /**
     * Constant for value 'BescheinigungSteuerschaedlicheVerwendungRiester'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung über die einbehaltenen und abgeführten Beträge im Rahmen einer steuerschädlichen Verwendung von Riester gemäß § 94 Abs. 1 Satz 4 und § 95 Abs. 1 EStG.
     * @return string 'BescheinigungSteuerschaedlicheVerwendungRiester'
     */
    const VALUE_BESCHEINIGUNG_STEUERSCHAEDLICHE_VERWENDUNG_RIESTER = 'BescheinigungSteuerschaedlicheVerwendungRiester';
    /**
     * Constant for value 'BesondereBedingungen'
     * Meta information extracted from the WSDL
     * - documentation: Kontextspezifische Bedingungen, die über die allgemeinen Vertragsbedingungen hinaus gehen.
     * @return string 'BesondereBedingungen'
     */
    const VALUE_BESONDERE_BEDINGUNGEN = 'BesondereBedingungen';
    /**
     * Constant for value 'Beweisbeschluss'
     * @return string 'Beweisbeschluss'
     */
    const VALUE_BEWEISBESCHLUSS = 'Beweisbeschluss';
    /**
     * Constant for value 'Datenschutzerklaerung'
     * Meta information extracted from the WSDL
     * - documentation: Bestimmungen zur Speicherung und Verarbeitung sowie der Weitergabe von Daten gem gesetzlichen Datenschutzgesetz
     * @return string 'Datenschutzerklaerung'
     */
    const VALUE_DATENSCHUTZERKLAERUNG = 'Datenschutzerklaerung';
    /**
     * Constant for value 'Deckungsnote'
     * @return string 'Deckungsnote'
     */
    const VALUE_DECKUNGSNOTE = 'Deckungsnote';
    /**
     * Constant for value 'EigenerSchriftsatz'
     * @return string 'EigenerSchriftsatz'
     */
    const VALUE_EIGENER_SCHRIFTSATZ = 'EigenerSchriftsatz';
    /**
     * Constant for value 'Eingangsbestaetigung'
     * Meta information extracted from the WSDL
     * - documentation: Bestätigung durch den Service Provider, dass der Request von Service Consumer fehlerfrei empfangen wurde.
     * @return string 'Eingangsbestaetigung'
     */
    const VALUE_EINGANGSBESTAETIGUNG = 'Eingangsbestaetigung';
    /**
     * Constant for value 'EinwilligungZurUebermittlungBeiBeamten'
     * Meta information extracted from the WSDL
     * - documentation: Einwilligung zur Übermittlung bei Beamten.
     * @return string 'EinwilligungZurUebermittlungBeiBeamten'
     */
    const VALUE_EINWILLIGUNG_ZUR_UEBERMITTLUNG_BEI_BEAMTEN = 'EinwilligungZurUebermittlungBeiBeamten';
    /**
     * Constant for value 'EmpfangsbestaetigungVVGDokumente'
     * @return string 'EmpfangsbestaetigungVVGDokumente'
     */
    const VALUE_EMPFANGSBESTAETIGUNG_VVGDOKUMENTE = 'EmpfangsbestaetigungVVGDokumente';
    /**
     * Constant for value 'EntnahmeAntrag'
     * Meta information extracted from the WSDL
     * - documentation: Antrag über die Entnahme von Fonds aus dem Vertrag, die zu einem bestimmten Stichtag verkauft werden.
     * @return string 'EntnahmeAntrag'
     */
    const VALUE_ENTNAHME_ANTRAG = 'EntnahmeAntrag';
    /**
     * Constant for value 'Erinnerung'
     * @return string 'Erinnerung'
     */
    const VALUE_ERINNERUNG = 'Erinnerung';
    /**
     * Constant for value 'Ermittlungsakte'
     * @return string 'Ermittlungsakte'
     */
    const VALUE_ERMITTLUNGSAKTE = 'Ermittlungsakte';
    /**
     * Constant for value 'Ersatzpolice'
     * Meta information extracted from the WSDL
     * - documentation: Neue Police, d.h. neue Inhaberurkunde
     * @return string 'Ersatzpolice'
     */
    const VALUE_ERSATZPOLICE = 'Ersatzpolice';
    /**
     * Constant for value 'Ersatzsteuerbescheinigung'
     * Meta information extracted from the WSDL
     * - documentation: Ersatzbescheinigung über die Kapitalerträge und die dafür bereits abgeführten Steuern eines Kalenderjahres gemäß § 45a Abs. 5 EStG
     * @return string 'Ersatzsteuerbescheinigung'
     */
    const VALUE_ERSATZSTEUERBESCHEINIGUNG = 'Ersatzsteuerbescheinigung';
    /**
     * Constant for value 'EWSEE'
     * Meta information extracted from the WSDL
     * - documentation: Einwilligungs- / Schweigepflichtentbindungserklärung
     * @return string 'EWSEE'
     */
    const VALUE_EWSEE = 'EWSEE';
    /**
     * Constant for value 'Fahrzeugbewertung'
     * @return string 'Fahrzeugbewertung'
     */
    const VALUE_FAHRZEUGBEWERTUNG = 'Fahrzeugbewertung';
    /**
     * Constant for value 'FATCA'
     * Meta information extracted from the WSDL
     * - documentation: FATCA-Fragebogen für natürliche oder juristische Personen
     * @return string 'FATCA'
     */
    const VALUE_FATCA = 'FATCA';
    /**
     * Constant for value 'FestsetzungsantragZulagen'
     * Meta information extracted from the WSDL
     * - documentation: Antragsformular für die Korrektur bzw. Festsetzung der Zulage gemäß § 90 Abs. 4 EStG
     * @return string 'FestsetzungsantragZulagen'
     */
    const VALUE_FESTSETZUNGSANTRAG_ZULAGEN = 'FestsetzungsantragZulagen';
    /**
     * Constant for value 'Fondsuebersicht'
     * Meta information extracted from the WSDL
     * - documentation: Aktuelle Übersicht der Fonds, in die investiert werden kann
     * @return string 'Fondsuebersicht'
     */
    const VALUE_FONDSUEBERSICHT = 'Fondsuebersicht';
    /**
     * Constant for value 'Forderungsschreiben'
     * @return string 'Forderungsschreiben'
     */
    const VALUE_FORDERUNGSSCHREIBEN = 'Forderungsschreiben';
    /**
     * Constant for value 'Foto'
     * @return string 'Foto'
     */
    const VALUE_FOTO = 'Foto';
    /**
     * Constant for value 'Fragebogen'
     * @return string 'Fragebogen'
     */
    const VALUE_FRAGEBOGEN = 'Fragebogen';
    /**
     * Constant for value 'Freistellungsauftrag'
     * Meta information extracted from the WSDL
     * - documentation: Freistellungsauftrag für Kapitalerträge und Antrag auf ehegattenübergreifende/lebenspartnerübergreifende Verlustverrechnung
     * @return string 'Freistellungsauftrag'
     */
    const VALUE_FREISTELLUNGSAUFTRAG = 'Freistellungsauftrag';
    /**
     * Constant for value 'Freistellungsbescheinigung'
     * @return string 'Freistellungsbescheinigung'
     */
    const VALUE_FREISTELLUNGSBESCHEINIGUNG = 'Freistellungsbescheinigung';
    /**
     * Constant for value 'Fuehrerscheinkopie'
     * Meta information extracted from the WSDL
     * - documentation: Elektronische Kopie eines Führerscheins
     * @return string 'Fuehrerscheinkopie'
     */
    const VALUE_FUEHRERSCHEINKOPIE = 'Fuehrerscheinkopie';
    /**
     * Constant for value 'GerichtlicheVerfuegung'
     * @return string 'GerichtlicheVerfuegung'
     */
    const VALUE_GERICHTLICHE_VERFUEGUNG = 'GerichtlicheVerfuegung';
    /**
     * Constant for value 'Gutachten'
     * @return string 'Gutachten'
     */
    const VALUE_GUTACHTEN = 'Gutachten';
    /**
     * Constant for value 'Handlungsanweisung'
     * @return string 'Handlungsanweisung'
     */
    const VALUE_HANDLUNGSANWEISUNG = 'Handlungsanweisung';
    /**
     * Constant for value 'Identifikation'
     * Meta information extracted from the WSDL
     * - documentation: Formular zur Unterschriftenprobe/Identifikation (getDocument) bzw. Kopie des Ausweises (Request setChange)
     * @return string 'Identifikation'
     */
    const VALUE_IDENTIFIKATION = 'Identifikation';
    /**
     * Constant for value 'InfoMeldungAnZfA'
     * Meta information extracted from the WSDL
     * - documentation: Information über die Übermittlung von Daten an die ZfA (z.B. Rentenbezüge, geleistete Beiträge) gemäß § 22a EStG
     * @return string 'InfoMeldungAnZfA'
     */
    const VALUE_INFO_MELDUNG_AN_ZF_A = 'InfoMeldungAnZfA';
    /**
     * Constant for value 'InternesDokumentFuerVermittler'
     * @return string 'InternesDokumentFuerVermittler'
     */
    const VALUE_INTERNES_DOKUMENT_FUER_VERMITTLER = 'InternesDokumentFuerVermittler';
    /**
     * Constant for value 'Jahressteuerbescheinigung'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung über die Kapitalerträge und die dafür bereits abgeführten Steuern eines Kalenderjahres gemäß § 45a Abs. 2 und 3 EStG
     * @return string 'Jahressteuerbescheinigung'
     */
    const VALUE_JAHRESSTEUERBESCHEINIGUNG = 'Jahressteuerbescheinigung';
    /**
     * Constant for value 'JahresbescheinigungBasisRente'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung über die Höhe der geleisteten Beiträge für das jeweilige Kalenderjahr gemäß § 10 Abs. 2 Buchstabe a EStG
     * @return string 'JahresbescheinigungBasisRente'
     */
    const VALUE_JAHRESBESCHEINIGUNG_BASIS_RENTE = 'JahresbescheinigungBasisRente';
    /**
     * Constant for value 'JahresbescheinigungRiester'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung über Altersvorsorgebeiträge, Zulagen, Stand des Altersvorsorgevermögens und Stand des Wohnförderkontos gemäß § 92 EStG
     * @return string 'JahresbescheinigungRiester'
     */
    const VALUE_JAHRESBESCHEINIGUNG_RIESTER = 'JahresbescheinigungRiester';
    /**
     * Constant for value 'Jahresinformation'
     * Meta information extracted from the WSDL
     * - documentation: Information des Versicherers an den Versicherungsnehmer gemäß § 155 VVG über den Wertstand des Vertrags mit Werten zum vorgegebenen Stichtag. Dies kann auch die Kopie der Jahresinformation des letzten Jahres sein.
     * @return string 'Jahresinformation'
     */
    const VALUE_JAHRESINFORMATION = 'Jahresinformation';
    /**
     * Constant for value 'Klage'
     * @return string 'Klage'
     */
    const VALUE_KLAGE = 'Klage';
    /**
     * Constant for value 'Klauseln'
     * Meta information extracted from the WSDL
     * - documentation: Vertraglich vereinbarte Klausen, die die Bedingungen abändern oder ergänzen.
     * @return string 'Klauseln'
     */
    const VALUE_KLAUSELN = 'Klauseln';
    /**
     * Constant for value 'Kompaktvorschlag'
     * Meta information extracted from the WSDL
     * - documentation: Werbliche Übersicht über ein Produkt, die versicherten Leistungen und die entsprechenden Beiträge in Kurzform. Häufig auch Datenblatt genannt.
     * @return string 'Kompaktvorschlag'
     */
    const VALUE_KOMPAKTVORSCHLAG = 'Kompaktvorschlag';
    /**
     * Constant for value 'Kostenuebernahmeerklaerung'
     * @return string 'Kostenuebernahmeerklaerung'
     */
    const VALUE_KOSTENUEBERNAHMEERKLAERUNG = 'Kostenuebernahmeerklaerung';
    /**
     * Constant for value 'Kostenvoranschlag'
     * @return string 'Kostenvoranschlag'
     */
    const VALUE_KOSTENVORANSCHLAG = 'Kostenvoranschlag';
    /**
     * Constant for value 'Messprotokoll'
     * @return string 'Messprotokoll'
     */
    const VALUE_MESSPROTOKOLL = 'Messprotokoll';
    /**
     * Constant for value 'Nachtrag'
     * Meta information extracted from the WSDL
     * - documentation: Dokumentierung einer Änderung zu einem Vertrag
     * @return string 'Nachtrag'
     */
    const VALUE_NACHTRAG = 'Nachtrag';
    /**
     * Constant for value 'Nachversichererbescheinigung'
     * Meta information extracted from the WSDL
     * - documentation: Nachversichererbescheinigung zur Vorlage beim Vorversicherer.
     * @return string 'Nachversichererbescheinigung'
     */
    const VALUE_NACHVERSICHERERBESCHEINIGUNG = 'Nachversichererbescheinigung';
    /**
     * Constant for value 'PiB'
     * Meta information extracted from the WSDL
     * - documentation: Produktinformationsblatt
     * @return string 'PiB'
     */
    const VALUE_PI_B = 'PiB';
    /**
     * Constant for value 'PiBVI'
     * Meta information extracted from the WSDL
     * - documentation: Produktinformationsblatt inkl. Vertragsinformationen
     * @return string 'PiBVI'
     */
    const VALUE_PI_BVI = 'PiBVI';
    /**
     * Constant for value 'Police'
     * @return string 'Police'
     */
    const VALUE_POLICE = 'Police';
    /**
     * Constant for value 'Prospekt'
     * Meta information extracted from the WSDL
     * - documentation: Werblich aufbereitete Erläuterung zum Produkt.
     * @return string 'Prospekt'
     */
    const VALUE_PROSPEKT = 'Prospekt';
    /**
     * Constant for value 'Protokoll'
     * @return string 'Protokoll'
     */
    const VALUE_PROTOKOLL = 'Protokoll';
    /**
     * Constant for value 'Pruefbericht'
     * @return string 'Pruefbericht'
     */
    const VALUE_PRUEFBERICHT = 'Pruefbericht';
    /**
     * Constant for value 'PruefungGWG'
     * Meta information extracted from the WSDL
     * - documentation: Formulare zur GwG Überprüfung des Kunden (juristische oder natürliche Person)
     * @return string 'PruefungGWG'
     */
    const VALUE_PRUEFUNG_GWG = 'PruefungGWG';
    /**
     * Constant for value 'Rechnung'
     * @return string 'Rechnung'
     */
    const VALUE_RECHNUNG = 'Rechnung';
    /**
     * Constant for value 'Reparaturbestaetigung'
     * @return string 'Reparaturbestaetigung'
     */
    const VALUE_REPARATURBESTAETIGUNG = 'Reparaturbestaetigung';
    /**
     * Constant for value 'RiesterwechselFormular'
     * Meta information extracted from the WSDL
     * - documentation: Riesterwechsel-Formular
     * @return string 'RiesterwechselFormular'
     */
    const VALUE_RIESTERWECHSEL_FORMULAR = 'RiesterwechselFormular';
    /**
     * Constant for value 'Risikoanalyse'
     * Meta information extracted from the WSDL
     * - documentation: Fragebogen zur Analyse der zu versichernden Risiken je Sparten
     * @return string 'Risikoanalyse'
     */
    const VALUE_RISIKOANALYSE = 'Risikoanalyse';
    /**
     * Constant for value 'Risikofragebogen'
     * Meta information extracted from the WSDL
     * - documentation: Fragebogen zur Erfassung von risikorelevanten Informationen über juristisch eindeutig und im Klartext formulierte Fragen.
     * @return string 'Risikofragebogen'
     */
    const VALUE_RISIKOFRAGEBOGEN = 'Risikofragebogen';
    /**
     * Constant for value 'RuecknahmeAenderung'
     * Meta information extracted from the WSDL
     * - documentation: Formular zur Rücknahme einer Änderung, z.B. Beitragsreduzierung, Kündigung, Beitragsfreistellung
     * @return string 'RuecknahmeAenderung'
     */
    const VALUE_RUECKNAHME_AENDERUNG = 'RuecknahmeAenderung';
    /**
     * Constant for value 'Schadenerledigung'
     * @return string 'Schadenerledigung'
     */
    const VALUE_SCHADENERLEDIGUNG = 'Schadenerledigung';
    /**
     * Constant for value 'Schadenmeldung'
     * @return string 'Schadenmeldung'
     */
    const VALUE_SCHADENMELDUNG = 'Schadenmeldung';
    /**
     * Constant for value 'SchriftsatzDerGegenseite'
     * @return string 'SchriftsatzDerGegenseite'
     */
    const VALUE_SCHRIFTSATZ_DER_GEGENSEITE = 'SchriftsatzDerGegenseite';
    /**
     * Constant for value 'SEPAMandatAntrag'
     * Meta information extracted from the WSDL
     * - documentation: Formular zur Beantragung eines SEPA-Mandats
     * @return string 'SEPAMandatAntrag'
     */
    const VALUE_SEPAMANDAT_ANTRAG = 'SEPAMandatAntrag';
    /**
     * Constant for value 'SEPAMandatKopie'
     * Meta information extracted from the WSDL
     * - documentation: Kopie eines (unterschriebenen) SEPA-Mandats
     * @return string 'SEPAMandatKopie'
     */
    const VALUE_SEPAMANDAT_KOPIE = 'SEPAMandatKopie';
    /**
     * Constant for value 'SEPANotifikation'
     * Meta information extracted from the WSDL
     * - documentation: SEPA-PreNotifikationsschreiben
     * @return string 'SEPANotifikation'
     */
    const VALUE_SEPANOTIFIKATION = 'SEPANotifikation';
    /**
     * Constant for value 'Sicherungsschein'
     * Meta information extracted from the WSDL
     * - documentation: Sicherungsschein an den Gläubiger.
     * @return string 'Sicherungsschein'
     */
    const VALUE_SICHERUNGSSCHEIN = 'Sicherungsschein';
    /**
     * Constant for value 'SFR-Uebertragungsformular'
     * Meta information extracted from the WSDL
     * - documentation: Formular zur Übertragung des Schadenfreiheitsrabatts
     * @return string 'SFR-Uebertragungsformular'
     */
    const VALUE_SFR_UEBERTRAGUNGSFORMULAR = 'SFR-Uebertragungsformular';
    /**
     * Constant for value 'SonstigesDokument'
     * @return string 'SonstigesDokument'
     */
    const VALUE_SONSTIGES_DOKUMENT = 'SonstigesDokument';
    /**
     * Constant for value 'Stehlgutliste'
     * Meta information extracted from the WSDL
     * - documentation: Liste gestohlener Gegenstände bzw. Güter.
     * @return string 'Stehlgutliste'
     */
    const VALUE_STEHLGUTLISTE = 'Stehlgutliste';
    /**
     * Constant for value 'UnterlagenZurSchadenhoehe'
     * @return string 'UnterlagenZurSchadenhoehe'
     */
    const VALUE_UNTERLAGEN_ZUR_SCHADENHOEHE = 'UnterlagenZurSchadenhoehe';
    /**
     * Constant for value 'Unterschriftenblatt'
     * Meta information extracted from the WSDL
     * - documentation: Ein standardisiertes Dokument zur Abgabe einer Willenserklärung per Unterschrift
     * @return string 'Unterschriftenblatt'
     */
    const VALUE_UNTERSCHRIFTENBLATT = 'Unterschriftenblatt';
    /**
     * Constant for value 'Urteil'
     * @return string 'Urteil'
     */
    const VALUE_URTEIL = 'Urteil';
    /**
     * Constant for value 'Vergleich'
     * @return string 'Vergleich'
     */
    const VALUE_VERGLEICH = 'Vergleich';
    /**
     * Constant for value 'Verlustbescheinigung'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung über die Höhe der nicht ausgeglichenen Verluste gemäß § 43a Abs. 3 Satz 4 EStG
     * @return string 'Verlustbescheinigung'
     */
    const VALUE_VERLUSTBESCHEINIGUNG = 'Verlustbescheinigung';
    /**
     * Constant for value 'Verlusterklaerung'
     * Meta information extracted from the WSDL
     * - documentation: Bei Kündigung oder bei Nichtauffinden des original Versicherungsscheines wird eine Verlusterklärung an den VN gesendet.
     * @return string 'Verlusterklaerung'
     */
    const VALUE_VERLUSTERKLAERUNG = 'Verlusterklaerung';
    /**
     * Constant for value 'Versicherungsbestaetigung'
     * Meta information extracted from the WSDL
     * - documentation: Bestätigung über Art und Umfang einer bestehenden Versicherung. DARF NICHT für Industrie- und Gewerbeversicherungen genutzt werden, da es dafür granulare Ausprägungen (einfache, erweiterte, individuelle
     * Versicherungsbestätigungen) gibt.
     * @return string 'Versicherungsbestaetigung'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG = 'Versicherungsbestaetigung';
    /**
     * Constant for value 'VersicherungsbestaetigungEinfachHaftpflicht'
     * Meta information extracted from the WSDL
     * - documentation: Bei einer einfachen Haftpflicht-Versicherungsbestätigung wird das Vorhandensein einer Haftpflichtversicherung mit Deckungssummen bestätigt.
     * @return string 'VersicherungsbestaetigungEinfachHaftpflicht'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_HAFTPFLICHT = 'VersicherungsbestaetigungEinfachHaftpflicht';
    /**
     * Constant for value 'VersicherungsbestaetigungEinfachSach'
     * Meta information extracted from the WSDL
     * - documentation: Bei einer einfachen Sach-Versicherungsbestätigung wird das Vorhandensein einer Sachversicherung mit einer eingeschlossenen Versicherungssumme bestätigt.
     * @return string 'VersicherungsbestaetigungEinfachSach'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_SACH = 'VersicherungsbestaetigungEinfachSach';
    /**
     * Constant for value 'VersicherungsbestaetigungEinfachTransport'
     * Meta information extracted from the WSDL
     * - documentation: Bei einer einfachen Transport-Versicherungsbestätigung wird das Vorhandensein einer Transportversicherung mit einer eingeschlossenen Versicherungssumme bestätigt.
     * @return string 'VersicherungsbestaetigungEinfachTransport'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_TRANSPORT = 'VersicherungsbestaetigungEinfachTransport';
    /**
     * Constant for value 'VersicherungsbestaetigungEinfachTV'
     * Meta information extracted from the WSDL
     * - documentation: Bei der einfachen Versicherungsbestätigung für eine technische Versicherung wird das Vorhandensein mit der eingeschlossenen Versicherungssumme bestätigt.
     * @return string 'VersicherungsbestaetigungEinfachTV'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_TV = 'VersicherungsbestaetigungEinfachTV';
    /**
     * Constant for value 'VersicherungsbestaetigungErweitertHaftpflicht'
     * Meta information extracted from the WSDL
     * - documentation: Bei einer erweiterten Haftpflicht-Versicherungsbestätigung werden über die einfache Versicherungsbestätigung hinaus die erweiterte Produkthaftpflicht und die versicherten Deckungsbausteine bestätigt.
     * @return string 'VersicherungsbestaetigungErweitertHaftpflicht'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_ERWEITERT_HAFTPFLICHT = 'VersicherungsbestaetigungErweitertHaftpflicht';
    /**
     * Constant for value 'VersicherungsbestaetigungErweitertTransport'
     * Meta information extracted from the WSDL
     * - documentation: Bei einer erweiterten Transport-Versicherungsbestätigung werden über das Vorhandensein einer Transportversicherung mit der eingeschlossenen Versicherungssumme hinaus die versicherten Deckungsbausteine bestätigt.
     * @return string 'VersicherungsbestaetigungErweitertTransport'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_ERWEITERT_TRANSPORT = 'VersicherungsbestaetigungErweitertTransport';
    /**
     * Constant for value 'VersicherungsbestaetigungIndividuellHaftpflicht'
     * Meta information extracted from the WSDL
     * - documentation: Eine individuelle Versicherungsbestätigung für eine gewerbliche Haftpflichtversicherung. Bei der Dokumentanforderung MUSS im Attribut Freitext des Geschäftsvorgangs die gewünschte Art und der gewünschte Umfang der Bestätigung
     * beschrieben werden.
     * @return string 'VersicherungsbestaetigungIndividuellHaftpflicht'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_INDIVIDUELL_HAFTPFLICHT = 'VersicherungsbestaetigungIndividuellHaftpflicht';
    /**
     * Constant for value 'VersicherungsbestaetigungIndividuellSach'
     * Meta information extracted from the WSDL
     * - documentation: Eine individuelle Versicherungsbestätigung für eine Sachversicherung. Bei der Dokumentanforderung MUSS im Attribut Freitext des Geschäftsvorgangs die gewünschte Art und der gewünschte Umfang der Bestätigung beschrieben werden.
     * @return string 'VersicherungsbestaetigungIndividuellSach'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_INDIVIDUELL_SACH = 'VersicherungsbestaetigungIndividuellSach';
    /**
     * Constant for value 'VersicherungsbestaetigungIndividuellTransport'
     * Meta information extracted from the WSDL
     * - documentation: Eine individuelle Versicherungsbestätigung für eine Transportversicherung. Bei der Dokumentanforderung MUSS im Attribut Freitext des Geschäftsvorgangs die gewünschte Art und der gewünschte Umfang der Bestätigung beschrieben
     * werden.
     * @return string 'VersicherungsbestaetigungIndividuellTransport'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_INDIVIDUELL_TRANSPORT = 'VersicherungsbestaetigungIndividuellTransport';
    /**
     * Constant for value 'VersicherungsbestaetigungPflichtversicherungHaftpflicht'
     * Meta information extracted from the WSDL
     * - documentation: Eine Versicherungsbestätigung zu einer Pflichtversicherung. Diese dient zur Vorlage bei Behörden oder Kammern.
     * @return string 'VersicherungsbestaetigungPflichtversicherungHaftpflicht'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_PFLICHTVERSICHERUNG_HAFTPFLICHT = 'VersicherungsbestaetigungPflichtversicherungHaftpflicht';
    /**
     * Constant for value 'VersicherungsbestaetigungPflichtversicherungTransport'
     * Meta information extracted from the WSDL
     * - documentation: Die Pflichtversicherung wird nach §7a GüKG (Güterkraftverkehrsgesetz) bestätigt.
     * @return string 'VersicherungsbestaetigungPflichtversicherungTransport'
     */
    const VALUE_VERSICHERUNGSBESTAETIGUNG_PFLICHTVERSICHERUNG_TRANSPORT = 'VersicherungsbestaetigungPflichtversicherungTransport';
    /**
     * Constant for value 'VersorgungsausgleichInformation'
     * Meta information extracted from the WSDL
     * - documentation: Information für das Familiengericht über Ehezeit, Ehezeitanteil und Ausgleichswert gemäß § 5 VersAusglG
     * @return string 'VersorgungsausgleichInformation'
     */
    const VALUE_VERSORGUNGSAUSGLEICH_INFORMATION = 'VersorgungsausgleichInformation';
    /**
     * Constant for value 'Vertrag'
     * @return string 'Vertrag'
     */
    const VALUE_VERTRAG = 'Vertrag';
    /**
     * Constant for value 'Verwertungsausschluss'
     * Meta information extracted from the WSDL
     * - documentation: Formular zum Schutz vor Pfändung bzw. Insolvenz
     * @return string 'Verwertungsausschluss'
     */
    const VALUE_VERWERTUNGSAUSSCHLUSS = 'Verwertungsausschluss';
    /**
     * Constant for value 'VI'
     * Meta information extracted from the WSDL
     * - documentation: Vertragsinformationen
     * @return string 'VI'
     */
    const VALUE_VI = 'VI';
    /**
     * Constant for value 'Video'
     * @return string 'Video'
     */
    const VALUE_VIDEO = 'Video';
    /**
     * Constant for value 'Vollmacht'
     * Meta information extracted from the WSDL
     * - documentation: Dokument zur Erteilung einer Vollmacht
     * @return string 'Vollmacht'
     */
    const VALUE_VOLLMACHT = 'Vollmacht';
    /**
     * Constant for value 'VollstreckbarerTitel'
     * @return string 'VollstreckbarerTitel'
     */
    const VALUE_VOLLSTRECKBARER_TITEL = 'VollstreckbarerTitel';
    /**
     * Constant for value 'Vorladung'
     * @return string 'Vorladung'
     */
    const VALUE_VORLADUNG = 'Vorladung';
    /**
     * Constant for value 'VorlaeufigeDeckung'
     * @return string 'VorlaeufigeDeckung'
     */
    const VALUE_VORLAEUFIGE_DECKUNG = 'VorlaeufigeDeckung';
    /**
     * Constant for value 'Vorschlag'
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsvorschlag ohne der nach VVG und VVG-Infoverordnung relevanten Informationen sowie ohne den Allgemeinen und Besonderen Bedingungen und Klauseln
     * @return string 'Vorschlag'
     */
    const VALUE_VORSCHLAG = 'Vorschlag';
    /**
     * Constant for value 'VorschlagVVG'
     * Meta information extracted from the WSDL
     * - documentation: VVG-konformer Versicherungsvorschlag inkl. der nach VVG und VVG-Infoverordnung relevanten Informationen sowie den Allgemeinen und Besonderen Bedingungen inkl. Klauseln
     * @return string 'VorschlagVVG'
     */
    const VALUE_VORSCHLAG_VVG = 'VorschlagVVG';
    /**
     * Constant for value 'VZR-Bescheinigung'
     * Meta information extracted from the WSDL
     * - documentation: Bescheinigung des Verkehrszentralregisters
     * @return string 'VZR-Bescheinigung'
     */
    const VALUE_VZR_BESCHEINIGUNG = 'VZR-Bescheinigung';
    /**
     * Constant for value 'WechselVertragspartner'
     * Meta information extracted from the WSDL
     * - documentation: Formular für die Änderung von Vertragspartnern
     * @return string 'WechselVertragspartner'
     */
    const VALUE_WECHSEL_VERTRAGSPARTNER = 'WechselVertragspartner';
    /**
     * Constant for value 'Widerrufsbelehrung'
     * @return string 'Widerrufsbelehrung'
     */
    const VALUE_WIDERRUFSBELEHRUNG = 'Widerrufsbelehrung';
    /**
     * Constant for value 'Zahlungsbestaetigung'
     * @return string 'Zahlungsbestaetigung'
     */
    const VALUE_ZAHLUNGSBESTAETIGUNG = 'Zahlungsbestaetigung';
    /**
     * Constant for value 'Zeugenbericht'
     * @return string 'Zeugenbericht'
     */
    const VALUE_ZEUGENBERICHT = 'Zeugenbericht';
    /**
     * Constant for value 'Zulagenantrag'
     * Meta information extracted from the WSDL
     * - documentation: Formular zur Beantragung von Zulagen gemäß § 89 Abs. 1 EStG
     * @return string 'Zulagenantrag'
     */
    const VALUE_ZULAGENANTRAG = 'Zulagenantrag';
    /**
     * Constant for value 'Zulassungsbescheinigung'
     * Meta information extracted from the WSDL
     * - documentation: Elektronische Kopie des Fahrzeugscheins oder -briefs
     * @return string 'Zulassungsbescheinigung'
     */
    const VALUE_ZULASSUNGSBESCHEINIGUNG = 'Zulassungsbescheinigung';
    /**
     * Constant for value 'Zweitschrift'
     * Meta information extracted from the WSDL
     * - documentation: Beglaubigte Kopie eines Originaldokuments
     * @return string 'Zweitschrift'
     */
    const VALUE_ZWEITSCHRIFT = 'Zweitschrift';
    /**
     * Return allowed values
     * @uses self::VALUE_A_BESCHEINIGUNG
     * @uses self::VALUE_ABLEHNUNGSSCHREIBEN
     * @uses self::VALUE_ABNAHMEBESTAETIGUNG
     * @uses self::VALUE_ABRECHNUNG
     * @uses self::VALUE_ABTRETUNGSERKLAERUNG
     * @uses self::VALUE_AENDERUNGSANTRAG
     * @uses self::VALUE_ANGEBOT
     * @uses self::VALUE_ANGEBOTSANFORDERUNG
     * @uses self::VALUE_ANNAHMEBESTAETIGUNG
     * @uses self::VALUE_ANSCHAFFUNGSBELEG
     * @uses self::VALUE_ANSCHREIBEN
     * @uses self::VALUE_ANSCHULDIGUNGSSCHRIFT
     * @uses self::VALUE_ANTRAG
     * @uses self::VALUE_ANTRAG_AUF_ZAHLUNG_AVWL
     * @uses self::VALUE_ANTRAG_FONDSWECHSEL
     * @uses self::VALUE_ANTRAG_VVG
     * @uses self::VALUE_ANTRAG_ZUZAHLUNG
     * @uses self::VALUE_ARBEITSNACHWEIS
     * @uses self::VALUE_ARZTBERICHT
     * @uses self::VALUE_ATTEST
     * @uses self::VALUE_AUFTRAG
     * @uses self::VALUE_AUSSERGERICHTLICHE_KORRESPONDENZ
     * @uses self::VALUE_AVB
     * @uses self::VALUE_AZV_BELEHRUNG
     * @uses self::VALUE_B_BESCHEINIGUNG
     * @uses self::VALUE_B_AVUEBERTRAG
     * @uses self::VALUE_BEITRAGSBESCHEINIGUNG_FUER_FINANZAMT
     * @uses self::VALUE_BERATUNGSPROTOKOLL
     * @uses self::VALUE_BERUFUNG
     * @uses self::VALUE_BESCHEINIGUNG_ABLAUFLEISTUNG
     * @uses self::VALUE_BESCHEINIGUNG_BEITRAEGE_BIS_RUECKKAUF
     * @uses self::VALUE_BESCHEINIGUNG_FUER_ARBEITSAGENTUR
     * @uses self::VALUE_BESCHEINIGUNG_FUER_BAFOE_GAMT
     * @uses self::VALUE_BESCHEINIGUNG_FUER_SOZIALAMT
     * @uses self::VALUE_BESCHEINIGUNG_RUECKKAUFSWERT
     * @uses self::VALUE_BESCHEINIGUNG_STEUERSCHAEDLICHE_VERWENDUNG_RIESTER
     * @uses self::VALUE_BESONDERE_BEDINGUNGEN
     * @uses self::VALUE_BEWEISBESCHLUSS
     * @uses self::VALUE_DATENSCHUTZERKLAERUNG
     * @uses self::VALUE_DECKUNGSNOTE
     * @uses self::VALUE_EIGENER_SCHRIFTSATZ
     * @uses self::VALUE_EINGANGSBESTAETIGUNG
     * @uses self::VALUE_EINWILLIGUNG_ZUR_UEBERMITTLUNG_BEI_BEAMTEN
     * @uses self::VALUE_EMPFANGSBESTAETIGUNG_VVGDOKUMENTE
     * @uses self::VALUE_ENTNAHME_ANTRAG
     * @uses self::VALUE_ERINNERUNG
     * @uses self::VALUE_ERMITTLUNGSAKTE
     * @uses self::VALUE_ERSATZPOLICE
     * @uses self::VALUE_ERSATZSTEUERBESCHEINIGUNG
     * @uses self::VALUE_EWSEE
     * @uses self::VALUE_FAHRZEUGBEWERTUNG
     * @uses self::VALUE_FATCA
     * @uses self::VALUE_FESTSETZUNGSANTRAG_ZULAGEN
     * @uses self::VALUE_FONDSUEBERSICHT
     * @uses self::VALUE_FORDERUNGSSCHREIBEN
     * @uses self::VALUE_FOTO
     * @uses self::VALUE_FRAGEBOGEN
     * @uses self::VALUE_FREISTELLUNGSAUFTRAG
     * @uses self::VALUE_FREISTELLUNGSBESCHEINIGUNG
     * @uses self::VALUE_FUEHRERSCHEINKOPIE
     * @uses self::VALUE_GERICHTLICHE_VERFUEGUNG
     * @uses self::VALUE_GUTACHTEN
     * @uses self::VALUE_HANDLUNGSANWEISUNG
     * @uses self::VALUE_IDENTIFIKATION
     * @uses self::VALUE_INFO_MELDUNG_AN_ZF_A
     * @uses self::VALUE_INTERNES_DOKUMENT_FUER_VERMITTLER
     * @uses self::VALUE_JAHRESSTEUERBESCHEINIGUNG
     * @uses self::VALUE_JAHRESBESCHEINIGUNG_BASIS_RENTE
     * @uses self::VALUE_JAHRESBESCHEINIGUNG_RIESTER
     * @uses self::VALUE_JAHRESINFORMATION
     * @uses self::VALUE_KLAGE
     * @uses self::VALUE_KLAUSELN
     * @uses self::VALUE_KOMPAKTVORSCHLAG
     * @uses self::VALUE_KOSTENUEBERNAHMEERKLAERUNG
     * @uses self::VALUE_KOSTENVORANSCHLAG
     * @uses self::VALUE_MESSPROTOKOLL
     * @uses self::VALUE_NACHTRAG
     * @uses self::VALUE_NACHVERSICHERERBESCHEINIGUNG
     * @uses self::VALUE_PI_B
     * @uses self::VALUE_PI_BVI
     * @uses self::VALUE_POLICE
     * @uses self::VALUE_PROSPEKT
     * @uses self::VALUE_PROTOKOLL
     * @uses self::VALUE_PRUEFBERICHT
     * @uses self::VALUE_PRUEFUNG_GWG
     * @uses self::VALUE_RECHNUNG
     * @uses self::VALUE_REPARATURBESTAETIGUNG
     * @uses self::VALUE_RIESTERWECHSEL_FORMULAR
     * @uses self::VALUE_RISIKOANALYSE
     * @uses self::VALUE_RISIKOFRAGEBOGEN
     * @uses self::VALUE_RUECKNAHME_AENDERUNG
     * @uses self::VALUE_SCHADENERLEDIGUNG
     * @uses self::VALUE_SCHADENMELDUNG
     * @uses self::VALUE_SCHRIFTSATZ_DER_GEGENSEITE
     * @uses self::VALUE_SEPAMANDAT_ANTRAG
     * @uses self::VALUE_SEPAMANDAT_KOPIE
     * @uses self::VALUE_SEPANOTIFIKATION
     * @uses self::VALUE_SICHERUNGSSCHEIN
     * @uses self::VALUE_SFR_UEBERTRAGUNGSFORMULAR
     * @uses self::VALUE_SONSTIGES_DOKUMENT
     * @uses self::VALUE_STEHLGUTLISTE
     * @uses self::VALUE_UNTERLAGEN_ZUR_SCHADENHOEHE
     * @uses self::VALUE_UNTERSCHRIFTENBLATT
     * @uses self::VALUE_URTEIL
     * @uses self::VALUE_VERGLEICH
     * @uses self::VALUE_VERLUSTBESCHEINIGUNG
     * @uses self::VALUE_VERLUSTERKLAERUNG
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_HAFTPFLICHT
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_SACH
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_TRANSPORT
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_TV
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_ERWEITERT_HAFTPFLICHT
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_ERWEITERT_TRANSPORT
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_INDIVIDUELL_HAFTPFLICHT
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_INDIVIDUELL_SACH
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_INDIVIDUELL_TRANSPORT
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_PFLICHTVERSICHERUNG_HAFTPFLICHT
     * @uses self::VALUE_VERSICHERUNGSBESTAETIGUNG_PFLICHTVERSICHERUNG_TRANSPORT
     * @uses self::VALUE_VERSORGUNGSAUSGLEICH_INFORMATION
     * @uses self::VALUE_VERTRAG
     * @uses self::VALUE_VERWERTUNGSAUSSCHLUSS
     * @uses self::VALUE_VI
     * @uses self::VALUE_VIDEO
     * @uses self::VALUE_VOLLMACHT
     * @uses self::VALUE_VOLLSTRECKBARER_TITEL
     * @uses self::VALUE_VORLADUNG
     * @uses self::VALUE_VORLAEUFIGE_DECKUNG
     * @uses self::VALUE_VORSCHLAG
     * @uses self::VALUE_VORSCHLAG_VVG
     * @uses self::VALUE_VZR_BESCHEINIGUNG
     * @uses self::VALUE_WECHSEL_VERTRAGSPARTNER
     * @uses self::VALUE_WIDERRUFSBELEHRUNG
     * @uses self::VALUE_ZAHLUNGSBESTAETIGUNG
     * @uses self::VALUE_ZEUGENBERICHT
     * @uses self::VALUE_ZULAGENANTRAG
     * @uses self::VALUE_ZULASSUNGSBESCHEINIGUNG
     * @uses self::VALUE_ZWEITSCHRIFT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_A_BESCHEINIGUNG,
            self::VALUE_ABLEHNUNGSSCHREIBEN,
            self::VALUE_ABNAHMEBESTAETIGUNG,
            self::VALUE_ABRECHNUNG,
            self::VALUE_ABTRETUNGSERKLAERUNG,
            self::VALUE_AENDERUNGSANTRAG,
            self::VALUE_ANGEBOT,
            self::VALUE_ANGEBOTSANFORDERUNG,
            self::VALUE_ANNAHMEBESTAETIGUNG,
            self::VALUE_ANSCHAFFUNGSBELEG,
            self::VALUE_ANSCHREIBEN,
            self::VALUE_ANSCHULDIGUNGSSCHRIFT,
            self::VALUE_ANTRAG,
            self::VALUE_ANTRAG_AUF_ZAHLUNG_AVWL,
            self::VALUE_ANTRAG_FONDSWECHSEL,
            self::VALUE_ANTRAG_VVG,
            self::VALUE_ANTRAG_ZUZAHLUNG,
            self::VALUE_ARBEITSNACHWEIS,
            self::VALUE_ARZTBERICHT,
            self::VALUE_ATTEST,
            self::VALUE_AUFTRAG,
            self::VALUE_AUSSERGERICHTLICHE_KORRESPONDENZ,
            self::VALUE_AVB,
            self::VALUE_AZV_BELEHRUNG,
            self::VALUE_B_BESCHEINIGUNG,
            self::VALUE_B_AVUEBERTRAG,
            self::VALUE_BEITRAGSBESCHEINIGUNG_FUER_FINANZAMT,
            self::VALUE_BERATUNGSPROTOKOLL,
            self::VALUE_BERUFUNG,
            self::VALUE_BESCHEINIGUNG_ABLAUFLEISTUNG,
            self::VALUE_BESCHEINIGUNG_BEITRAEGE_BIS_RUECKKAUF,
            self::VALUE_BESCHEINIGUNG_FUER_ARBEITSAGENTUR,
            self::VALUE_BESCHEINIGUNG_FUER_BAFOE_GAMT,
            self::VALUE_BESCHEINIGUNG_FUER_SOZIALAMT,
            self::VALUE_BESCHEINIGUNG_RUECKKAUFSWERT,
            self::VALUE_BESCHEINIGUNG_STEUERSCHAEDLICHE_VERWENDUNG_RIESTER,
            self::VALUE_BESONDERE_BEDINGUNGEN,
            self::VALUE_BEWEISBESCHLUSS,
            self::VALUE_DATENSCHUTZERKLAERUNG,
            self::VALUE_DECKUNGSNOTE,
            self::VALUE_EIGENER_SCHRIFTSATZ,
            self::VALUE_EINGANGSBESTAETIGUNG,
            self::VALUE_EINWILLIGUNG_ZUR_UEBERMITTLUNG_BEI_BEAMTEN,
            self::VALUE_EMPFANGSBESTAETIGUNG_VVGDOKUMENTE,
            self::VALUE_ENTNAHME_ANTRAG,
            self::VALUE_ERINNERUNG,
            self::VALUE_ERMITTLUNGSAKTE,
            self::VALUE_ERSATZPOLICE,
            self::VALUE_ERSATZSTEUERBESCHEINIGUNG,
            self::VALUE_EWSEE,
            self::VALUE_FAHRZEUGBEWERTUNG,
            self::VALUE_FATCA,
            self::VALUE_FESTSETZUNGSANTRAG_ZULAGEN,
            self::VALUE_FONDSUEBERSICHT,
            self::VALUE_FORDERUNGSSCHREIBEN,
            self::VALUE_FOTO,
            self::VALUE_FRAGEBOGEN,
            self::VALUE_FREISTELLUNGSAUFTRAG,
            self::VALUE_FREISTELLUNGSBESCHEINIGUNG,
            self::VALUE_FUEHRERSCHEINKOPIE,
            self::VALUE_GERICHTLICHE_VERFUEGUNG,
            self::VALUE_GUTACHTEN,
            self::VALUE_HANDLUNGSANWEISUNG,
            self::VALUE_IDENTIFIKATION,
            self::VALUE_INFO_MELDUNG_AN_ZF_A,
            self::VALUE_INTERNES_DOKUMENT_FUER_VERMITTLER,
            self::VALUE_JAHRESSTEUERBESCHEINIGUNG,
            self::VALUE_JAHRESBESCHEINIGUNG_BASIS_RENTE,
            self::VALUE_JAHRESBESCHEINIGUNG_RIESTER,
            self::VALUE_JAHRESINFORMATION,
            self::VALUE_KLAGE,
            self::VALUE_KLAUSELN,
            self::VALUE_KOMPAKTVORSCHLAG,
            self::VALUE_KOSTENUEBERNAHMEERKLAERUNG,
            self::VALUE_KOSTENVORANSCHLAG,
            self::VALUE_MESSPROTOKOLL,
            self::VALUE_NACHTRAG,
            self::VALUE_NACHVERSICHERERBESCHEINIGUNG,
            self::VALUE_PI_B,
            self::VALUE_PI_BVI,
            self::VALUE_POLICE,
            self::VALUE_PROSPEKT,
            self::VALUE_PROTOKOLL,
            self::VALUE_PRUEFBERICHT,
            self::VALUE_PRUEFUNG_GWG,
            self::VALUE_RECHNUNG,
            self::VALUE_REPARATURBESTAETIGUNG,
            self::VALUE_RIESTERWECHSEL_FORMULAR,
            self::VALUE_RISIKOANALYSE,
            self::VALUE_RISIKOFRAGEBOGEN,
            self::VALUE_RUECKNAHME_AENDERUNG,
            self::VALUE_SCHADENERLEDIGUNG,
            self::VALUE_SCHADENMELDUNG,
            self::VALUE_SCHRIFTSATZ_DER_GEGENSEITE,
            self::VALUE_SEPAMANDAT_ANTRAG,
            self::VALUE_SEPAMANDAT_KOPIE,
            self::VALUE_SEPANOTIFIKATION,
            self::VALUE_SICHERUNGSSCHEIN,
            self::VALUE_SFR_UEBERTRAGUNGSFORMULAR,
            self::VALUE_SONSTIGES_DOKUMENT,
            self::VALUE_STEHLGUTLISTE,
            self::VALUE_UNTERLAGEN_ZUR_SCHADENHOEHE,
            self::VALUE_UNTERSCHRIFTENBLATT,
            self::VALUE_URTEIL,
            self::VALUE_VERGLEICH,
            self::VALUE_VERLUSTBESCHEINIGUNG,
            self::VALUE_VERLUSTERKLAERUNG,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_HAFTPFLICHT,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_SACH,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_TRANSPORT,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_EINFACH_TV,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_ERWEITERT_HAFTPFLICHT,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_ERWEITERT_TRANSPORT,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_INDIVIDUELL_HAFTPFLICHT,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_INDIVIDUELL_SACH,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_INDIVIDUELL_TRANSPORT,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_PFLICHTVERSICHERUNG_HAFTPFLICHT,
            self::VALUE_VERSICHERUNGSBESTAETIGUNG_PFLICHTVERSICHERUNG_TRANSPORT,
            self::VALUE_VERSORGUNGSAUSGLEICH_INFORMATION,
            self::VALUE_VERTRAG,
            self::VALUE_VERWERTUNGSAUSSCHLUSS,
            self::VALUE_VI,
            self::VALUE_VIDEO,
            self::VALUE_VOLLMACHT,
            self::VALUE_VOLLSTRECKBARER_TITEL,
            self::VALUE_VORLADUNG,
            self::VALUE_VORLAEUFIGE_DECKUNG,
            self::VALUE_VORSCHLAG,
            self::VALUE_VORSCHLAG_VVG,
            self::VALUE_VZR_BESCHEINIGUNG,
            self::VALUE_WECHSEL_VERTRAGSPARTNER,
            self::VALUE_WIDERRUFSBELEHRUNG,
            self::VALUE_ZAHLUNGSBESTAETIGUNG,
            self::VALUE_ZEUGENBERICHT,
            self::VALUE_ZULAGENANTRAG,
            self::VALUE_ZULASSUNGSBESCHEINIGUNG,
            self::VALUE_ZWEITSCHRIFT,
        );
    }
}
