<?php

namespace BiPRO\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ST_DeckungsartKU EnumType
 * Meta information extracted from the WSDL
 * - documentation: Art der Deckung der Kraftfahrtunfallversicherung gemäß GDV-Schlüssel SA 0220.054/1 Feld 11
 * @subpackage Enumerations
 */
class ST_DeckungsartKU extends AbstractStructEnumBase
{
    /**
     * Constant for value '1'
     * Meta information extracted from the WSDL
     * - documentation: Insassenversicherung nach dem Pauschalsystem außer WKZ 001, 002, 003, 005, 012, 018, 022, 028, 760, 761, 765, 766
     * @return string '1'
     */
    const VALUE_1 = '1';
    /**
     * Constant for value '2'
     * Meta information extracted from the WSDL
     * - documentation: Insassenversicherung nach dem Platzsystem außer WKZ 001, 002, 003, 005, 012, 018, 022, 028, 760, 761, 765, 766
     * @return string '2'
     */
    const VALUE_2 = '2';
    /**
     * Constant for value '3'
     * Meta information extracted from the WSDL
     * - documentation: Insassenversicherung nach dem Pauschalsystem für WKZ 001, 002, 003, 005, 012, 018, 022, 028, 760, 761, 765, 766
     * @return string '3'
     */
    const VALUE_3 = '3';
    /**
     * Constant for value '4'
     * Meta information extracted from the WSDL
     * - documentation: Berufs- und Beifahrerversicherung unter Ausschluss der Kraftradbenutzung
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '5'
     * Meta information extracted from the WSDL
     * - documentation: Berufs- und Beifahrerversicherung mit Einschluss der Kraftradbenutzung
     * @return string '5'
     */
    const VALUE_5 = '5';
    /**
     * Constant for value '9'
     * Meta information extracted from the WSDL
     * - documentation: Namentliche Unfallversicherung
     * @return string '9'
     */
    const VALUE_9 = '9';
    /**
     * Return allowed values
     * @uses self::VALUE_1
     * @uses self::VALUE_2
     * @uses self::VALUE_3
     * @uses self::VALUE_4
     * @uses self::VALUE_5
     * @uses self::VALUE_9
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_1,
            self::VALUE_2,
            self::VALUE_3,
            self::VALUE_4,
            self::VALUE_5,
            self::VALUE_9,
        );
    }
}
