<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Zertifizierungsdaten StructType
 * Meta information extracted from the WSDL
 * - documentation: Zertifizierungsdaten zum Produkt.
 * @subpackage Structs
 */
class CT_Zertifizierungsdaten extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Art der Zertifizierung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Zertifizierungsnummer
     * Meta information extracted from the WSDL
     * - documentation: Zertifizierungsnummer des Produkts gemäß ArtID.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Zertifizierungsnummer;
    /**
     * Constructor method for CT_Zertifizierungsdaten
     * @uses CT_Zertifizierungsdaten::setArtID()
     * @uses CT_Zertifizierungsdaten::setZertifizierungsnummer()
     * @param string $artID
     * @param string $zertifizierungsnummer
     */
    public function __construct($artID = null, $zertifizierungsnummer = null)
    {
        $this
            ->setArtID($artID)
            ->setZertifizierungsnummer($zertifizierungsnummer);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_ZertifizierungsArt::valueIsValid()
     * @uses \BiPRO\EnumType\ST_ZertifizierungsArt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Zertifizierungsdaten
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_ZertifizierungsArt::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_ZertifizierungsArt', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_ZertifizierungsArt::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Zertifizierungsnummer value
     * @return string|null
     */
    public function getZertifizierungsnummer()
    {
        return $this->Zertifizierungsnummer;
    }
    /**
     * Set Zertifizierungsnummer value
     * @param string $zertifizierungsnummer
     * @return \BiPRO\StructType\CT_Zertifizierungsdaten
     */
    public function setZertifizierungsnummer($zertifizierungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($zertifizierungsnummer) && !is_string($zertifizierungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zertifizierungsnummer, true), gettype($zertifizierungsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($zertifizierungsnummer) && mb_strlen($zertifizierungsnummer) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($zertifizierungsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($zertifizierungsnummer) && mb_strlen($zertifizierungsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($zertifizierungsnummer)), __LINE__);
        }
        $this->Zertifizierungsnummer = $zertifizierungsnummer;
        return $this;
    }
}
