<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Zeitraum2 StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Abbildung von Zeiträumen und Dauern. Die Angaben MÜSSEN einen Zeitraum eindeutig definieren. Es MUSS also mindestens beide Zeitpunkte (Beginn, Ende) oder ein Zeitpunkt und eine Dauer (AnzahlJahre, AnzahlMonate,
 * AnzahlTage) angegeben werden.Wenn aus fachlichen Gründen eine konkrete Angabe nicht möglich ist, DARF auf die Angabe verzichtet werden (z.B. Ende der Rentenzahlung = Tod, Ende der Versicherungsdauer in KV = Tod)WENN in der Dokumentation der
 * Refernzierung der Klasse Zeitraum ein "weicher" Bezugszeitpunkt (z.B. Eintritt des Schadenfalls) angegeben ist, MUSS NUR die Dauer (AnzahlJahre, AnzahlMonate bzw AnzahlTage) des Zeitraums angegeben werden.Bei Anfragen (Requests) im Kontext TAA DARF
 * der Consumer auf die vollständige Angabe konkreter Zeitpunkte oder der Dauer verzichten, da die korrekte Ermittlung der dieser Größen in der Hand des Produktgebers liegt. Der Produktgeber MUSS die fehlenden Größen ermitteln und in der Antwort
 * zurückliefern.Die Angabe einer Dauer MUSS entweder als AnzahlJahre und AnzahlMonate erfolgen oder als AnzahlTage.Ist die Anzahl größer 11, MÜSSEN die vollen Jahre nach AnzahlJahre übertragen werden.Beispiel: Die Darstellung einer Dauer von 15
 * Monaten erfolgt also als AnzahlJahre=1, AnzahlMonate=3; 12 Monate erfolgt als AnzahlJahre=1, AnzahlMonate=0.Diese Klasse nutzende Assoziationen MÜSSEN in ihrer Dokumentation die Genauigkeit und Optionalität der Zeitzone in den Attributen Beginn und
 * Ende explizit definieren.
 * @subpackage Structs
 */
class CT_Zeitraum2 extends CT_Objekt
{
    /**
     * The Beginn
     * Meta information extracted from the WSDL
     * - documentation: Der Beginn des abzubildenden Zeitraums. | Datentyp zur Angabe eines Zeitpunkts mit beliebiger Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt entspricht die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp
     * nutzende Attribute MÜSSEN in ihrer Dokumentation die gewünschte Genauigkeit und die Optionalität der Zeitzone explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt interpretiert werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht
     * UTC +5 Stunden.Gültige Werte sind zum Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $Beginn;
    /**
     * The Ende
     * Meta information extracted from the WSDL
     * - documentation: Das Ende des abzubildenden Zeitraums. | Datentyp zur Angabe eines Zeitpunkts mit beliebiger Genauigkeit und optionaler Zeitzone. Vollständig ausgeprägt entspricht die Darstellung ISO 8601 und dem W3C TimeStamp.Diesen Datentyp
     * nutzende Attribute MÜSSEN in ihrer Dokumentation die gewünschte Genauigkeit und die Optionalität der Zeitzone explizit definieren.Angaben zur Zeitzone MÜSSEN wie folgt interpretiert werden:Z = Zeitzone entspricht UTC.+05:00 = Zeitzone entspricht
     * UTC +5 Stunden.Gültige Werte sind zum Beispiel:2015-01-192015-01-19T20:152015-01-19T20:15:312015-01-19T20:15:31.3332015-01-19T20:15:31+05:002015-01-19Z2015-01-19+05:002015-01-19T20:15-03:30
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?
     * @var string
     */
    public $Ende;
    /**
     * The AnzahlJahre
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Jahre der abzubildenden Dauer.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlJahre;
    /**
     * The AnzahlMonate
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Monate der abzubildenden Dauer.Ist die Anzahl größer 11, MÜSSEN die vollen Jahre nach AnzahlJahre übertragen werden. Beispiel: Die Darstellung einer Dauer von 15 Monaten erfolgt also als AnzahlJahre=1, AnzahlMonate=3;
     * 12 Monate erfolgt als AnzahlJahre=1, AnzahlMonate=0.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlMonate;
    /**
     * The AnzahlTage
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der Tage der abzubildenden Dauer.Dient zur expliziten Angabe von Dauern in Tagen (z.B. Karrenzeit = 42 Tage)DARF NICHT zusammen mit AnzahlMonate und/oder AnzahlJahre genutzt werden.
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlTage;
    /**
     * Constructor method for CT_Zeitraum2
     * @uses CT_Zeitraum2::setBeginn()
     * @uses CT_Zeitraum2::setEnde()
     * @uses CT_Zeitraum2::setAnzahlJahre()
     * @uses CT_Zeitraum2::setAnzahlMonate()
     * @uses CT_Zeitraum2::setAnzahlTage()
     * @param string $beginn
     * @param string $ende
     * @param int $anzahlJahre
     * @param int $anzahlMonate
     * @param int $anzahlTage
     */
    public function __construct($beginn = null, $ende = null, $anzahlJahre = null, $anzahlMonate = null, $anzahlTage = null)
    {
        $this
            ->setBeginn($beginn)
            ->setEnde($ende)
            ->setAnzahlJahre($anzahlJahre)
            ->setAnzahlMonate($anzahlMonate)
            ->setAnzahlTage($anzahlTage);
    }
    /**
     * Get Beginn value
     * @return string|null
     */
    public function getBeginn()
    {
        return $this->Beginn;
    }
    /**
     * Set Beginn value
     * @param string $beginn
     * @return \BiPRO\StructType\CT_Zeitraum2
     */
    public function setBeginn($beginn = null)
    {
        // validation for constraint: string
        if (!is_null($beginn) && !is_string($beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginn, true), gettype($beginn)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($beginn) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $beginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($beginn, true)), __LINE__);
        }
        $this->Beginn = $beginn;
        return $this;
    }
    /**
     * Get Ende value
     * @return string|null
     */
    public function getEnde()
    {
        return $this->Ende;
    }
    /**
     * Set Ende value
     * @param string $ende
     * @return \BiPRO\StructType\CT_Zeitraum2
     */
    public function setEnde($ende = null)
    {
        // validation for constraint: string
        if (!is_null($ende) && !is_string($ende)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ende, true), gettype($ende)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?)
        if (!is_null($ende) && !preg_match('/[0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?/', $ende)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-1][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9](:[0-5][0-9](.[0-9]{3})?)?)?([+-][0-2][0-9]:[0-5][0-9]|Z)?', var_export($ende, true)), __LINE__);
        }
        $this->Ende = $ende;
        return $this;
    }
    /**
     * Get AnzahlJahre value
     * @return int|null
     */
    public function getAnzahlJahre()
    {
        return $this->AnzahlJahre;
    }
    /**
     * Set AnzahlJahre value
     * @param int $anzahlJahre
     * @return \BiPRO\StructType\CT_Zeitraum2
     */
    public function setAnzahlJahre($anzahlJahre = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlJahre) && !(is_int($anzahlJahre) || ctype_digit($anzahlJahre))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlJahre, true), gettype($anzahlJahre)), __LINE__);
        }
        $this->AnzahlJahre = $anzahlJahre;
        return $this;
    }
    /**
     * Get AnzahlMonate value
     * @return int|null
     */
    public function getAnzahlMonate()
    {
        return $this->AnzahlMonate;
    }
    /**
     * Set AnzahlMonate value
     * @param int $anzahlMonate
     * @return \BiPRO\StructType\CT_Zeitraum2
     */
    public function setAnzahlMonate($anzahlMonate = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlMonate) && !(is_int($anzahlMonate) || ctype_digit($anzahlMonate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlMonate, true), gettype($anzahlMonate)), __LINE__);
        }
        $this->AnzahlMonate = $anzahlMonate;
        return $this;
    }
    /**
     * Get AnzahlTage value
     * @return int|null
     */
    public function getAnzahlTage()
    {
        return $this->AnzahlTage;
    }
    /**
     * Set AnzahlTage value
     * @param int $anzahlTage
     * @return \BiPRO\StructType\CT_Zeitraum2
     */
    public function setAnzahlTage($anzahlTage = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlTage) && !(is_int($anzahlTage) || ctype_digit($anzahlTage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlTage, true), gettype($anzahlTage)), __LINE__);
        }
        $this->AnzahlTage = $anzahlTage;
        return $this;
    }
}
