<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Wasserfahrzeug StructType
 * Meta information extracted from the WSDL
 * - documentation: Wasserfahrzeuge sind Fahrzeuge, die zur Fortbewegung auf dem oder im Wasser bestimmt sind.
 * @subpackage Structs
 */
class CT_Wasserfahrzeug extends CT_Gegenstand
{
    /**
     * The Wasserfahrzeugtyp
     * Meta information extracted from the WSDL
     * - documentation: Typ des Wasserfahrzeugs
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Wasserfahrzeugtyp;
    /**
     * The StaendigerLiegeplatz
     * Meta information extracted from the WSDL
     * - documentation: Land des ständigen Liegeplatzes
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StaendigerLiegeplatz;
    /**
     * The Registrierung
     * Meta information extracted from the WSDL
     * - documentation: Registriernummer des Wasserfahrzeuges
     * - base: xsd:string
     * - length: 17
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Registrierung;
    /**
     * The Motornummer
     * Meta information extracted from the WSDL
     * - documentation: Motornummer des Wasserfahrzeuges
     * - base: xsd:string
     * - length: 17
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Motornummer;
    /**
     * The Motorlage
     * Meta information extracted from the WSDL
     * - documentation: Lage des Motors des Wasserfahrzeugs
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Motorlage;
    /**
     * The Baujahr
     * Meta information extracted from the WSDL
     * - documentation: Baujahr des Wasserfahrzeugs
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Baujahr;
    /**
     * The Ladefaehigkeit
     * Meta information extracted from the WSDL
     * - documentation: Die Ladefähigkeit ist die gesamte Ladung, die das Schiff in den Laderäumen aufnehmen kann und/oder die es bis zur Ladelinie tragen kann.Rechtsschutz: Die Angabe dazu ist tarifierungsrelevant für die Wasserfahrzeugtypen [03; 04;
     * 06; 08; 09]
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Ladefaehigkeit;
    /**
     * The LadefaehigkeitEinheit
     * Meta information extracted from the WSDL
     * - documentation: Einheit zum Attribut Ladefaehigkeit
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LadefaehigkeitEinheit;
    /**
     * The Motorleistung
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Motorleistung in "kW". Umrechnung von "PS" in "kW" 1 PS = 0,74 kW Rechtsschutz: Die Angabe dazu ist tarifierungsrelevant für die Wasserfahrzeugtypen [01; 05; 07; 13]
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Motorleistung;
    /**
     * The AnzahlFassendePersonen
     * Meta information extracted from the WSDL
     * - documentation: Die Angabe dazu ist für Rechtsschutz tarifierungsrelevant für den Wasserfahrzeugtyp [02]
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AnzahlFassendePersonen;
    /**
     * The Segelflaeche
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Segelflaeche in "qm". Die Angabe dazu ist tarifierungsrelevant für den Wasserfahrzeugtyp 12 [Segelboote und -yachten].
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Segelflaeche;
    /**
     * The EingetragenerNameSchiffsregister
     * Meta information extracted from the WSDL
     * - documentation: Im Schiffsregister eingetragener Schiffsname
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $EingetragenerNameSchiffsregister;
    /**
     * The SchiffsregisterOrt
     * Meta information extracted from the WSDL
     * - documentation: Ort der Schiffsregistereintragung, z.B. Amtsgericht Bremen
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $SchiffsregisterOrt;
    /**
     * Constructor method for CT_Wasserfahrzeug
     * @uses CT_Wasserfahrzeug::setWasserfahrzeugtyp()
     * @uses CT_Wasserfahrzeug::setStaendigerLiegeplatz()
     * @uses CT_Wasserfahrzeug::setRegistrierung()
     * @uses CT_Wasserfahrzeug::setMotornummer()
     * @uses CT_Wasserfahrzeug::setMotorlage()
     * @uses CT_Wasserfahrzeug::setBaujahr()
     * @uses CT_Wasserfahrzeug::setLadefaehigkeit()
     * @uses CT_Wasserfahrzeug::setLadefaehigkeitEinheit()
     * @uses CT_Wasserfahrzeug::setMotorleistung()
     * @uses CT_Wasserfahrzeug::setAnzahlFassendePersonen()
     * @uses CT_Wasserfahrzeug::setSegelflaeche()
     * @uses CT_Wasserfahrzeug::setEingetragenerNameSchiffsregister()
     * @uses CT_Wasserfahrzeug::setSchiffsregisterOrt()
     * @param string $wasserfahrzeugtyp
     * @param string $staendigerLiegeplatz
     * @param string $registrierung
     * @param string $motornummer
     * @param string $motorlage
     * @param int $baujahr
     * @param float $ladefaehigkeit
     * @param string $ladefaehigkeitEinheit
     * @param float $motorleistung
     * @param int $anzahlFassendePersonen
     * @param int $segelflaeche
     * @param string $eingetragenerNameSchiffsregister
     * @param string $schiffsregisterOrt
     */
    public function __construct($wasserfahrzeugtyp = null, $staendigerLiegeplatz = null, $registrierung = null, $motornummer = null, $motorlage = null, $baujahr = null, $ladefaehigkeit = null, $ladefaehigkeitEinheit = null, $motorleistung = null, $anzahlFassendePersonen = null, $segelflaeche = null, $eingetragenerNameSchiffsregister = null, $schiffsregisterOrt = null)
    {
        $this
            ->setWasserfahrzeugtyp($wasserfahrzeugtyp)
            ->setStaendigerLiegeplatz($staendigerLiegeplatz)
            ->setRegistrierung($registrierung)
            ->setMotornummer($motornummer)
            ->setMotorlage($motorlage)
            ->setBaujahr($baujahr)
            ->setLadefaehigkeit($ladefaehigkeit)
            ->setLadefaehigkeitEinheit($ladefaehigkeitEinheit)
            ->setMotorleistung($motorleistung)
            ->setAnzahlFassendePersonen($anzahlFassendePersonen)
            ->setSegelflaeche($segelflaeche)
            ->setEingetragenerNameSchiffsregister($eingetragenerNameSchiffsregister)
            ->setSchiffsregisterOrt($schiffsregisterOrt);
    }
    /**
     * Get Wasserfahrzeugtyp value
     * @return string|null
     */
    public function getWasserfahrzeugtyp()
    {
        return $this->Wasserfahrzeugtyp;
    }
    /**
     * Set Wasserfahrzeugtyp value
     * @uses \BiPRO\EnumType\ST_Wasserfahrzeugtyp::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Wasserfahrzeugtyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wasserfahrzeugtyp
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setWasserfahrzeugtyp($wasserfahrzeugtyp = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Wasserfahrzeugtyp::valueIsValid($wasserfahrzeugtyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Wasserfahrzeugtyp', is_array($wasserfahrzeugtyp) ? implode(', ', $wasserfahrzeugtyp) : var_export($wasserfahrzeugtyp, true), implode(', ', \BiPRO\EnumType\ST_Wasserfahrzeugtyp::getValidValues())), __LINE__);
        }
        $this->Wasserfahrzeugtyp = $wasserfahrzeugtyp;
        return $this;
    }
    /**
     * Get StaendigerLiegeplatz value
     * @return string|null
     */
    public function getStaendigerLiegeplatz()
    {
        return $this->StaendigerLiegeplatz;
    }
    /**
     * Set StaendigerLiegeplatz value
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $staendigerLiegeplatz
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setStaendigerLiegeplatz($staendigerLiegeplatz = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Laenderkennzeichen::valueIsValid($staendigerLiegeplatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Laenderkennzeichen', is_array($staendigerLiegeplatz) ? implode(', ', $staendigerLiegeplatz) : var_export($staendigerLiegeplatz, true), implode(', ', \BiPRO\EnumType\ST_Laenderkennzeichen::getValidValues())), __LINE__);
        }
        $this->StaendigerLiegeplatz = $staendigerLiegeplatz;
        return $this;
    }
    /**
     * Get Registrierung value
     * @return string|null
     */
    public function getRegistrierung()
    {
        return $this->Registrierung;
    }
    /**
     * Set Registrierung value
     * @param string $registrierung
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setRegistrierung($registrierung = null)
    {
        // validation for constraint: string
        if (!is_null($registrierung) && !is_string($registrierung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrierung, true), gettype($registrierung)), __LINE__);
        }
        // validation for constraint: length(17)
        if (!is_null($registrierung) && mb_strlen($registrierung) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 17', mb_strlen($registrierung)), __LINE__);
        }
        $this->Registrierung = $registrierung;
        return $this;
    }
    /**
     * Get Motornummer value
     * @return string|null
     */
    public function getMotornummer()
    {
        return $this->Motornummer;
    }
    /**
     * Set Motornummer value
     * @param string $motornummer
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setMotornummer($motornummer = null)
    {
        // validation for constraint: string
        if (!is_null($motornummer) && !is_string($motornummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motornummer, true), gettype($motornummer)), __LINE__);
        }
        // validation for constraint: length(17)
        if (!is_null($motornummer) && mb_strlen($motornummer) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 17', mb_strlen($motornummer)), __LINE__);
        }
        $this->Motornummer = $motornummer;
        return $this;
    }
    /**
     * Get Motorlage value
     * @return string|null
     */
    public function getMotorlage()
    {
        return $this->Motorlage;
    }
    /**
     * Set Motorlage value
     * @uses \BiPRO\EnumType\ST_BootMotorlage::valueIsValid()
     * @uses \BiPRO\EnumType\ST_BootMotorlage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $motorlage
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setMotorlage($motorlage = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_BootMotorlage::valueIsValid($motorlage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_BootMotorlage', is_array($motorlage) ? implode(', ', $motorlage) : var_export($motorlage, true), implode(', ', \BiPRO\EnumType\ST_BootMotorlage::getValidValues())), __LINE__);
        }
        $this->Motorlage = $motorlage;
        return $this;
    }
    /**
     * Get Baujahr value
     * @return int|null
     */
    public function getBaujahr()
    {
        return $this->Baujahr;
    }
    /**
     * Set Baujahr value
     * @param int $baujahr
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setBaujahr($baujahr = null)
    {
        // validation for constraint: int
        if (!is_null($baujahr) && !(is_int($baujahr) || ctype_digit($baujahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baujahr, true), gettype($baujahr)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($baujahr) && mb_strlen(preg_replace('/(\D)/', '', $baujahr)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($baujahr, true), mb_strlen(preg_replace('/(\D)/', '', $baujahr))), __LINE__);
        }
        $this->Baujahr = $baujahr;
        return $this;
    }
    /**
     * Get Ladefaehigkeit value
     * @return float|null
     */
    public function getLadefaehigkeit()
    {
        return $this->Ladefaehigkeit;
    }
    /**
     * Set Ladefaehigkeit value
     * @param float $ladefaehigkeit
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setLadefaehigkeit($ladefaehigkeit = null)
    {
        // validation for constraint: float
        if (!is_null($ladefaehigkeit) && !(is_float($ladefaehigkeit) || is_numeric($ladefaehigkeit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ladefaehigkeit, true), gettype($ladefaehigkeit)), __LINE__);
        }
        $this->Ladefaehigkeit = $ladefaehigkeit;
        return $this;
    }
    /**
     * Get LadefaehigkeitEinheit value
     * @return string|null
     */
    public function getLadefaehigkeitEinheit()
    {
        return $this->LadefaehigkeitEinheit;
    }
    /**
     * Set LadefaehigkeitEinheit value
     * @uses \BiPRO\EnumType\ST_Werteinheit::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Werteinheit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ladefaehigkeitEinheit
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setLadefaehigkeitEinheit($ladefaehigkeitEinheit = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Werteinheit::valueIsValid($ladefaehigkeitEinheit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Werteinheit', is_array($ladefaehigkeitEinheit) ? implode(', ', $ladefaehigkeitEinheit) : var_export($ladefaehigkeitEinheit, true), implode(', ', \BiPRO\EnumType\ST_Werteinheit::getValidValues())), __LINE__);
        }
        $this->LadefaehigkeitEinheit = $ladefaehigkeitEinheit;
        return $this;
    }
    /**
     * Get Motorleistung value
     * @return float|null
     */
    public function getMotorleistung()
    {
        return $this->Motorleistung;
    }
    /**
     * Set Motorleistung value
     * @param float $motorleistung
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setMotorleistung($motorleistung = null)
    {
        // validation for constraint: float
        if (!is_null($motorleistung) && !(is_float($motorleistung) || is_numeric($motorleistung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($motorleistung, true), gettype($motorleistung)), __LINE__);
        }
        $this->Motorleistung = $motorleistung;
        return $this;
    }
    /**
     * Get AnzahlFassendePersonen value
     * @return int|null
     */
    public function getAnzahlFassendePersonen()
    {
        return $this->AnzahlFassendePersonen;
    }
    /**
     * Set AnzahlFassendePersonen value
     * @param int $anzahlFassendePersonen
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setAnzahlFassendePersonen($anzahlFassendePersonen = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlFassendePersonen) && !(is_int($anzahlFassendePersonen) || ctype_digit($anzahlFassendePersonen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlFassendePersonen, true), gettype($anzahlFassendePersonen)), __LINE__);
        }
        $this->AnzahlFassendePersonen = $anzahlFassendePersonen;
        return $this;
    }
    /**
     * Get Segelflaeche value
     * @return int|null
     */
    public function getSegelflaeche()
    {
        return $this->Segelflaeche;
    }
    /**
     * Set Segelflaeche value
     * @param int $segelflaeche
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setSegelflaeche($segelflaeche = null)
    {
        // validation for constraint: int
        if (!is_null($segelflaeche) && !(is_int($segelflaeche) || ctype_digit($segelflaeche))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($segelflaeche, true), gettype($segelflaeche)), __LINE__);
        }
        $this->Segelflaeche = $segelflaeche;
        return $this;
    }
    /**
     * Get EingetragenerNameSchiffsregister value
     * @return string|null
     */
    public function getEingetragenerNameSchiffsregister()
    {
        return $this->EingetragenerNameSchiffsregister;
    }
    /**
     * Set EingetragenerNameSchiffsregister value
     * @param string $eingetragenerNameSchiffsregister
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setEingetragenerNameSchiffsregister($eingetragenerNameSchiffsregister = null)
    {
        // validation for constraint: string
        if (!is_null($eingetragenerNameSchiffsregister) && !is_string($eingetragenerNameSchiffsregister)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eingetragenerNameSchiffsregister, true), gettype($eingetragenerNameSchiffsregister)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($eingetragenerNameSchiffsregister) && mb_strlen($eingetragenerNameSchiffsregister) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($eingetragenerNameSchiffsregister)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($eingetragenerNameSchiffsregister) && mb_strlen($eingetragenerNameSchiffsregister) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($eingetragenerNameSchiffsregister)), __LINE__);
        }
        $this->EingetragenerNameSchiffsregister = $eingetragenerNameSchiffsregister;
        return $this;
    }
    /**
     * Get SchiffsregisterOrt value
     * @return string|null
     */
    public function getSchiffsregisterOrt()
    {
        return $this->SchiffsregisterOrt;
    }
    /**
     * Set SchiffsregisterOrt value
     * @param string $schiffsregisterOrt
     * @return \BiPRO\StructType\CT_Wasserfahrzeug
     */
    public function setSchiffsregisterOrt($schiffsregisterOrt = null)
    {
        // validation for constraint: string
        if (!is_null($schiffsregisterOrt) && !is_string($schiffsregisterOrt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schiffsregisterOrt, true), gettype($schiffsregisterOrt)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($schiffsregisterOrt) && mb_strlen($schiffsregisterOrt) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($schiffsregisterOrt)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($schiffsregisterOrt) && mb_strlen($schiffsregisterOrt) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($schiffsregisterOrt)), __LINE__);
        }
        $this->SchiffsregisterOrt = $schiffsregisterOrt;
        return $this;
    }
}
