<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Vorfahrzeug StructType
 * @subpackage Structs
 */
class CT_Vorfahrzeug extends CT_ZusaetzlicheAntragsdaten
{
    /**
     * The AmtlichesKennzeichen
     * Meta information extracted from the WSDL
     * - documentation: Amtliches Kfz-Kennzeichen
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $AmtlichesKennzeichen;
    /**
     * The Verbleib
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Verbleib;
    /**
     * The VerkauftAm
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $VerkauftAm;
    /**
     * The VorfahrzeugVersichertFuer
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsnehmer des Vorfahrzeugs
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VorfahrzeugVersichertFuer;
    /**
     * Constructor method for CT_Vorfahrzeug
     * @uses CT_Vorfahrzeug::setAmtlichesKennzeichen()
     * @uses CT_Vorfahrzeug::setVerbleib()
     * @uses CT_Vorfahrzeug::setVerkauftAm()
     * @uses CT_Vorfahrzeug::setVorfahrzeugVersichertFuer()
     * @param string $amtlichesKennzeichen
     * @param string $verbleib
     * @param string $verkauftAm
     * @param string $vorfahrzeugVersichertFuer
     */
    public function __construct($amtlichesKennzeichen = null, $verbleib = null, $verkauftAm = null, $vorfahrzeugVersichertFuer = null)
    {
        $this
            ->setAmtlichesKennzeichen($amtlichesKennzeichen)
            ->setVerbleib($verbleib)
            ->setVerkauftAm($verkauftAm)
            ->setVorfahrzeugVersichertFuer($vorfahrzeugVersichertFuer);
    }
    /**
     * Get AmtlichesKennzeichen value
     * @return string|null
     */
    public function getAmtlichesKennzeichen()
    {
        return $this->AmtlichesKennzeichen;
    }
    /**
     * Set AmtlichesKennzeichen value
     * @param string $amtlichesKennzeichen
     * @return \BiPRO\StructType\CT_Vorfahrzeug
     */
    public function setAmtlichesKennzeichen($amtlichesKennzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($amtlichesKennzeichen) && !is_string($amtlichesKennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amtlichesKennzeichen, true), gettype($amtlichesKennzeichen)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($amtlichesKennzeichen) && mb_strlen($amtlichesKennzeichen) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($amtlichesKennzeichen)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($amtlichesKennzeichen) && mb_strlen($amtlichesKennzeichen) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($amtlichesKennzeichen)), __LINE__);
        }
        $this->AmtlichesKennzeichen = $amtlichesKennzeichen;
        return $this;
    }
    /**
     * Get Verbleib value
     * @return string|null
     */
    public function getVerbleib()
    {
        return $this->Verbleib;
    }
    /**
     * Set Verbleib value
     * @uses \BiPRO\EnumType\ST_Verbleib::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Verbleib::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $verbleib
     * @return \BiPRO\StructType\CT_Vorfahrzeug
     */
    public function setVerbleib($verbleib = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Verbleib::valueIsValid($verbleib)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Verbleib', is_array($verbleib) ? implode(', ', $verbleib) : var_export($verbleib, true), implode(', ', \BiPRO\EnumType\ST_Verbleib::getValidValues())), __LINE__);
        }
        $this->Verbleib = $verbleib;
        return $this;
    }
    /**
     * Get VerkauftAm value
     * @return string|null
     */
    public function getVerkauftAm()
    {
        return $this->VerkauftAm;
    }
    /**
     * Set VerkauftAm value
     * @param string $verkauftAm
     * @return \BiPRO\StructType\CT_Vorfahrzeug
     */
    public function setVerkauftAm($verkauftAm = null)
    {
        // validation for constraint: string
        if (!is_null($verkauftAm) && !is_string($verkauftAm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verkauftAm, true), gettype($verkauftAm)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($verkauftAm) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $verkauftAm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($verkauftAm, true)), __LINE__);
        }
        $this->VerkauftAm = $verkauftAm;
        return $this;
    }
    /**
     * Get VorfahrzeugVersichertFuer value
     * @return string|null
     */
    public function getVorfahrzeugVersichertFuer()
    {
        return $this->VorfahrzeugVersichertFuer;
    }
    /**
     * Set VorfahrzeugVersichertFuer value
     * @uses \BiPRO\EnumType\ST_VorfahrzeugVersichertFuer::valueIsValid()
     * @uses \BiPRO\EnumType\ST_VorfahrzeugVersichertFuer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vorfahrzeugVersichertFuer
     * @return \BiPRO\StructType\CT_Vorfahrzeug
     */
    public function setVorfahrzeugVersichertFuer($vorfahrzeugVersichertFuer = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_VorfahrzeugVersichertFuer::valueIsValid($vorfahrzeugVersichertFuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_VorfahrzeugVersichertFuer', is_array($vorfahrzeugVersichertFuer) ? implode(', ', $vorfahrzeugVersichertFuer) : var_export($vorfahrzeugVersichertFuer, true), implode(', ', \BiPRO\EnumType\ST_VorfahrzeugVersichertFuer::getValidValues())), __LINE__);
        }
        $this->VorfahrzeugVersichertFuer = $vorfahrzeugVersichertFuer;
        return $this;
    }
}
