<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_VorNebenVertrag StructType
 * Meta information extracted from the WSDL
 * - documentation: Angaben zu bestehenden oder beendeten Vor- bzw. Nebenverträgen.
 * @subpackage Structs
 */
class CT_VorNebenVertrag extends CT_Vertrag
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Ablehnungsgrund
     * Meta information extracted from the WSDL
     * - documentation: Grund/Ursache aus welchem ein Antrag von einem anderen Versicherer bereits abgelehnt wurde
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Ablehnungsgrund;
    /**
     * Constructor method for CT_VorNebenVertrag
     * @uses CT_VorNebenVertrag::setArtID()
     * @uses CT_VorNebenVertrag::setAblehnungsgrund()
     * @param string $artID
     * @param string $ablehnungsgrund
     */
    public function __construct($artID = null, $ablehnungsgrund = null)
    {
        $this
            ->setArtID($artID)
            ->setAblehnungsgrund($ablehnungsgrund);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Fremdversicherungsart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Fremdversicherungsart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_VorNebenVertrag
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Fremdversicherungsart::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Fremdversicherungsart', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Fremdversicherungsart::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Ablehnungsgrund value
     * @return string|null
     */
    public function getAblehnungsgrund()
    {
        return $this->Ablehnungsgrund;
    }
    /**
     * Set Ablehnungsgrund value
     * @param string $ablehnungsgrund
     * @return \BiPRO\StructType\CT_VorNebenVertrag
     */
    public function setAblehnungsgrund($ablehnungsgrund = null)
    {
        // validation for constraint: string
        if (!is_null($ablehnungsgrund) && !is_string($ablehnungsgrund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ablehnungsgrund, true), gettype($ablehnungsgrund)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($ablehnungsgrund) && mb_strlen($ablehnungsgrund) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($ablehnungsgrund)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ablehnungsgrund) && mb_strlen($ablehnungsgrund) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ablehnungsgrund)), __LINE__);
        }
        $this->Ablehnungsgrund = $ablehnungsgrund;
        return $this;
    }
}
