<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Verursacher StructType
 * Meta information extracted from the WSDL
 * - documentation: Partner, der etwas verursacht hat. Z.B. Kfz-Unfall, Haftpflichtschaden.
 * @subpackage Structs
 */
class CT_Verursacher extends CT_Partnerrolle
{
    /**
     * The InErstausbildung
     * Meta information extracted from the WSDL
     * - documentation: JA = Schadenverursacher befindet sich in ErstausbildungNEIN = Schadenverursacher befindet sich nicht in ErstausbildungIst vorwiegend bei Haftpflichtschadenereignissen relevant.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $InErstausbildung;
    /**
     * The InHaeuslicherGemeinschaft
     * Meta information extracted from the WSDL
     * - documentation: JA = Schadenverursacher lebt in häuslicher Gemeinschaft mit VersicherungsnehmerNEIN = Schadenverursacher lebt nicht in häuslicher Gemeinschaft mit VersicherungsnehmerIst vorwiegend bei Haftpflichtschadenereignissen relevant.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $InHaeuslicherGemeinschaft;
    /**
     * Constructor method for CT_Verursacher
     * @uses CT_Verursacher::setInErstausbildung()
     * @uses CT_Verursacher::setInHaeuslicherGemeinschaft()
     * @param bool $inErstausbildung
     * @param bool $inHaeuslicherGemeinschaft
     */
    public function __construct($inErstausbildung = null, $inHaeuslicherGemeinschaft = null)
    {
        $this
            ->setInErstausbildung($inErstausbildung)
            ->setInHaeuslicherGemeinschaft($inHaeuslicherGemeinschaft);
    }
    /**
     * Get InErstausbildung value
     * @return bool|null
     */
    public function getInErstausbildung()
    {
        return $this->InErstausbildung;
    }
    /**
     * Set InErstausbildung value
     * @param bool $inErstausbildung
     * @return \BiPRO\StructType\CT_Verursacher
     */
    public function setInErstausbildung($inErstausbildung = null)
    {
        // validation for constraint: boolean
        if (!is_null($inErstausbildung) && !is_bool($inErstausbildung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inErstausbildung, true), gettype($inErstausbildung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($inErstausbildung) && !preg_match('/true|false/', $inErstausbildung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($inErstausbildung, true)), __LINE__);
        }
        $this->InErstausbildung = $inErstausbildung;
        return $this;
    }
    /**
     * Get InHaeuslicherGemeinschaft value
     * @return bool|null
     */
    public function getInHaeuslicherGemeinschaft()
    {
        return $this->InHaeuslicherGemeinschaft;
    }
    /**
     * Set InHaeuslicherGemeinschaft value
     * @param bool $inHaeuslicherGemeinschaft
     * @return \BiPRO\StructType\CT_Verursacher
     */
    public function setInHaeuslicherGemeinschaft($inHaeuslicherGemeinschaft = null)
    {
        // validation for constraint: boolean
        if (!is_null($inHaeuslicherGemeinschaft) && !is_bool($inHaeuslicherGemeinschaft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inHaeuslicherGemeinschaft, true), gettype($inHaeuslicherGemeinschaft)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($inHaeuslicherGemeinschaft) && !preg_match('/true|false/', $inHaeuslicherGemeinschaft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($inHaeuslicherGemeinschaft, true)), __LINE__);
        }
        $this->InHaeuslicherGemeinschaft = $inHaeuslicherGemeinschaft;
        return $this;
    }
}
