<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_VersicherungsbestaetigungKfz StructType
 * @subpackage Structs
 */
class CT_VersicherungsbestaetigungKfz extends CT_Objekt
{
    /**
     * The Versicherungsbestaetigungsnummer
     * Meta information extracted from the WSDL
     * - documentation: Auspraegungen gemaess GDV-VB Schnittstelle VU – Zentrale Stelle: Nachrichtenkopf.
     * - base: xsd:string
     * - length: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Versicherungsbestaetigungsnummer;
    /**
     * The VbArt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VbArt;
    /**
     * The VbAbrufbarAb
     * Meta information extracted from the WSDL
     * - documentation: wie ST_DatumZeit ergänzt um Sekunden
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]
     * @var string
     */
    public $VbAbrufbarAb;
    /**
     * The VbAbrufbarBis
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $VbAbrufbarBis;
    /**
     * The Zulassungsfahrten
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Zulassungsfahrten;
    /**
     * The MietfahrzeugFuerSelbstfahrer
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $MietfahrzeugFuerSelbstfahrer;
    /**
     * The DatumVersicherungsbeginn
     * Meta information extracted from the WSDL
     * - documentation: nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $DatumVersicherungsbeginn;
    /**
     * The HalterAbweichendVonVersicherungsnehmer
     * Meta information extracted from the WSDL
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $HalterAbweichendVonVersicherungsnehmer;
    /**
     * The VbAusgegebenDurch
     * Meta information extracted from the WSDL
     * - documentation: VB ausgegeben durch Vermittler oder Versicherer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VbAusgegebenDurch;
    /**
     * The Ablaufdatum
     * Meta information extracted from the WSDL
     * - documentation: Ablaufdatum der Versicherungsbestätigung für eVB insbesondere im Kontingent | nur Jahr, Monat, Tag
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}\-[0-1][0-9]-[0-3][0-9]
     * @var string
     */
    public $Ablaufdatum;
    /**
     * The KFZFuerBehinderteSchuelerKindergartentraeger
     * Meta information extracted from the WSDL
     * - documentation: Dieses KFZ wird für Behinderte, Schüler oder Kindergartenträger verwendet.Nach §6 FZV (Fahrzeugzulassungsverordnung) ist der Verwendungszweck eines Farzeuges bei der Erstellung einer eVB anzugeben.Wird dieses Attribut nicht
     * geliefert, MUSS es als "Nein" interpretiert werden
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $KFZFuerBehinderteSchuelerKindergartentraeger;
    /**
     * The Krankenwagen
     * Meta information extracted from the WSDL
     * - documentation: Dieses KFZ wird als Krankenwagen verwendet.Nach §6 FZV (Fahrzeugzulassungsverordnung) ist der Verwendungszweck eines Farzeuges bei der Erstellung einer eVB anzugeben.Wird dieses Attribut nicht geliefert, MUSS es als "Nein"
     * interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Krankenwagen;
    /**
     * The Mietfahrzeug
     * Meta information extracted from the WSDL
     * - documentation: Dieses KFZ wird als Mietfahrzeug verwendet. Mietwagen sind im gesetzlichen Sinne Fahrzeuge, deren Einsatz gemietet wird einschließlich der Fahrer-Dienste.Nach §6 FZV (Fahrzeugzulassungsverordnung) ist der Verwendungszweck eines
     * Fahrzeuges bei der Erstellung einer eVB anzugeben.Wird dieses Attribut nicht geliefert, MUSS es als "Nein" interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Mietfahrzeug;
    /**
     * The Linienbus
     * Meta information extracted from the WSDL
     * - documentation: Dieses KFZ wird als Linienbus verwendet.Nach §6 FZV (Fahrzeugzulassungsverordnung) ist der Verwendungszweck eines Farzeuges bei der Erstellung einer eVB anzugeben.Wird dieses Attribut nicht geliefert, MUSS es als "Nein"
     * interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Linienbus;
    /**
     * The Taxi
     * Meta information extracted from the WSDL
     * - documentation: Dieses KFZ wird als Taxi verwendet.Nach §6 FZV (Fahrzeugzulassungsverordnung) ist der Verwendungszweck eines Fahrzeuges bei der Erstellung einer eVB anzugeben.Wird dieses Attribut nicht geliefert, MUSS es als "Nein" interpretiert
     * werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $Taxi;
    /**
     * The SonstigeBesondereVerwendung
     * Meta information extracted from the WSDL
     * - documentation: Dieses KFZ wird zur sonstiger besonderen Verwendung genutzt.Nach §6 FZV (Fahrzeugzulassungsverordnung) ist der Verwendungszweck eines Farzeuges bei der Erstellung einer eVB anzugeben.Wird dieses Attribut nicht geliefert, MUSS es als
     * "Nein" interpretiert werden.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $SonstigeBesondereVerwendung;
    /**
     * The OhneBesondereVerwendung
     * Meta information extracted from the WSDL
     * - documentation: Dieses KFZ wird ohne besonderen Verwendung genutzt.Nach §6 FZV (Fahrzeugzulassungsverordnung) ist der Verwendungszweck eines Farzeuges bei der Erstellung einer eVB anzugeben.
     * - base: xsd:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: true|false
     * @var bool
     */
    public $OhneBesondereVerwendung;
    /**
     * Constructor method for CT_VersicherungsbestaetigungKfz
     * @uses CT_VersicherungsbestaetigungKfz::setVersicherungsbestaetigungsnummer()
     * @uses CT_VersicherungsbestaetigungKfz::setVbArt()
     * @uses CT_VersicherungsbestaetigungKfz::setVbAbrufbarAb()
     * @uses CT_VersicherungsbestaetigungKfz::setVbAbrufbarBis()
     * @uses CT_VersicherungsbestaetigungKfz::setZulassungsfahrten()
     * @uses CT_VersicherungsbestaetigungKfz::setMietfahrzeugFuerSelbstfahrer()
     * @uses CT_VersicherungsbestaetigungKfz::setDatumVersicherungsbeginn()
     * @uses CT_VersicherungsbestaetigungKfz::setHalterAbweichendVonVersicherungsnehmer()
     * @uses CT_VersicherungsbestaetigungKfz::setVbAusgegebenDurch()
     * @uses CT_VersicherungsbestaetigungKfz::setAblaufdatum()
     * @uses CT_VersicherungsbestaetigungKfz::setKFZFuerBehinderteSchuelerKindergartentraeger()
     * @uses CT_VersicherungsbestaetigungKfz::setKrankenwagen()
     * @uses CT_VersicherungsbestaetigungKfz::setMietfahrzeug()
     * @uses CT_VersicherungsbestaetigungKfz::setLinienbus()
     * @uses CT_VersicherungsbestaetigungKfz::setTaxi()
     * @uses CT_VersicherungsbestaetigungKfz::setSonstigeBesondereVerwendung()
     * @uses CT_VersicherungsbestaetigungKfz::setOhneBesondereVerwendung()
     * @param string $versicherungsbestaetigungsnummer
     * @param string $vbArt
     * @param string $vbAbrufbarAb
     * @param string $vbAbrufbarBis
     * @param bool $zulassungsfahrten
     * @param bool $mietfahrzeugFuerSelbstfahrer
     * @param string $datumVersicherungsbeginn
     * @param bool $halterAbweichendVonVersicherungsnehmer
     * @param string $vbAusgegebenDurch
     * @param string $ablaufdatum
     * @param bool $kFZFuerBehinderteSchuelerKindergartentraeger
     * @param bool $krankenwagen
     * @param bool $mietfahrzeug
     * @param bool $linienbus
     * @param bool $taxi
     * @param bool $sonstigeBesondereVerwendung
     * @param bool $ohneBesondereVerwendung
     */
    public function __construct($versicherungsbestaetigungsnummer = null, $vbArt = null, $vbAbrufbarAb = null, $vbAbrufbarBis = null, $zulassungsfahrten = null, $mietfahrzeugFuerSelbstfahrer = null, $datumVersicherungsbeginn = null, $halterAbweichendVonVersicherungsnehmer = null, $vbAusgegebenDurch = null, $ablaufdatum = null, $kFZFuerBehinderteSchuelerKindergartentraeger = null, $krankenwagen = null, $mietfahrzeug = null, $linienbus = null, $taxi = null, $sonstigeBesondereVerwendung = null, $ohneBesondereVerwendung = null)
    {
        $this
            ->setVersicherungsbestaetigungsnummer($versicherungsbestaetigungsnummer)
            ->setVbArt($vbArt)
            ->setVbAbrufbarAb($vbAbrufbarAb)
            ->setVbAbrufbarBis($vbAbrufbarBis)
            ->setZulassungsfahrten($zulassungsfahrten)
            ->setMietfahrzeugFuerSelbstfahrer($mietfahrzeugFuerSelbstfahrer)
            ->setDatumVersicherungsbeginn($datumVersicherungsbeginn)
            ->setHalterAbweichendVonVersicherungsnehmer($halterAbweichendVonVersicherungsnehmer)
            ->setVbAusgegebenDurch($vbAusgegebenDurch)
            ->setAblaufdatum($ablaufdatum)
            ->setKFZFuerBehinderteSchuelerKindergartentraeger($kFZFuerBehinderteSchuelerKindergartentraeger)
            ->setKrankenwagen($krankenwagen)
            ->setMietfahrzeug($mietfahrzeug)
            ->setLinienbus($linienbus)
            ->setTaxi($taxi)
            ->setSonstigeBesondereVerwendung($sonstigeBesondereVerwendung)
            ->setOhneBesondereVerwendung($ohneBesondereVerwendung);
    }
    /**
     * Get Versicherungsbestaetigungsnummer value
     * @return string|null
     */
    public function getVersicherungsbestaetigungsnummer()
    {
        return $this->Versicherungsbestaetigungsnummer;
    }
    /**
     * Set Versicherungsbestaetigungsnummer value
     * @param string $versicherungsbestaetigungsnummer
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setVersicherungsbestaetigungsnummer($versicherungsbestaetigungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($versicherungsbestaetigungsnummer) && !is_string($versicherungsbestaetigungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versicherungsbestaetigungsnummer, true), gettype($versicherungsbestaetigungsnummer)), __LINE__);
        }
        // validation for constraint: length(7)
        if (!is_null($versicherungsbestaetigungsnummer) && mb_strlen($versicherungsbestaetigungsnummer) !== 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 7', mb_strlen($versicherungsbestaetigungsnummer)), __LINE__);
        }
        $this->Versicherungsbestaetigungsnummer = $versicherungsbestaetigungsnummer;
        return $this;
    }
    /**
     * Get VbArt value
     * @return string|null
     */
    public function getVbArt()
    {
        return $this->VbArt;
    }
    /**
     * Set VbArt value
     * @uses \BiPRO\EnumType\ST_VbArt::valueIsValid()
     * @uses \BiPRO\EnumType\ST_VbArt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vbArt
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setVbArt($vbArt = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_VbArt::valueIsValid($vbArt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_VbArt', is_array($vbArt) ? implode(', ', $vbArt) : var_export($vbArt, true), implode(', ', \BiPRO\EnumType\ST_VbArt::getValidValues())), __LINE__);
        }
        $this->VbArt = $vbArt;
        return $this;
    }
    /**
     * Get VbAbrufbarAb value
     * @return string|null
     */
    public function getVbAbrufbarAb()
    {
        return $this->VbAbrufbarAb;
    }
    /**
     * Set VbAbrufbarAb value
     * @param string $vbAbrufbarAb
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setVbAbrufbarAb($vbAbrufbarAb = null)
    {
        // validation for constraint: string
        if (!is_null($vbAbrufbarAb) && !is_string($vbAbrufbarAb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vbAbrufbarAb, true), gettype($vbAbrufbarAb)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9])
        if (!is_null($vbAbrufbarAb) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]/', $vbAbrufbarAb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9]', var_export($vbAbrufbarAb, true)), __LINE__);
        }
        $this->VbAbrufbarAb = $vbAbrufbarAb;
        return $this;
    }
    /**
     * Get VbAbrufbarBis value
     * @return string|null
     */
    public function getVbAbrufbarBis()
    {
        return $this->VbAbrufbarBis;
    }
    /**
     * Set VbAbrufbarBis value
     * @param string $vbAbrufbarBis
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setVbAbrufbarBis($vbAbrufbarBis = null)
    {
        // validation for constraint: string
        if (!is_null($vbAbrufbarBis) && !is_string($vbAbrufbarBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vbAbrufbarBis, true), gettype($vbAbrufbarBis)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($vbAbrufbarBis) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $vbAbrufbarBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($vbAbrufbarBis, true)), __LINE__);
        }
        $this->VbAbrufbarBis = $vbAbrufbarBis;
        return $this;
    }
    /**
     * Get Zulassungsfahrten value
     * @return bool|null
     */
    public function getZulassungsfahrten()
    {
        return $this->Zulassungsfahrten;
    }
    /**
     * Set Zulassungsfahrten value
     * @param bool $zulassungsfahrten
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setZulassungsfahrten($zulassungsfahrten = null)
    {
        // validation for constraint: boolean
        if (!is_null($zulassungsfahrten) && !is_bool($zulassungsfahrten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($zulassungsfahrten, true), gettype($zulassungsfahrten)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($zulassungsfahrten) && !preg_match('/true|false/', $zulassungsfahrten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($zulassungsfahrten, true)), __LINE__);
        }
        $this->Zulassungsfahrten = $zulassungsfahrten;
        return $this;
    }
    /**
     * Get MietfahrzeugFuerSelbstfahrer value
     * @return bool|null
     */
    public function getMietfahrzeugFuerSelbstfahrer()
    {
        return $this->MietfahrzeugFuerSelbstfahrer;
    }
    /**
     * Set MietfahrzeugFuerSelbstfahrer value
     * @param bool $mietfahrzeugFuerSelbstfahrer
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setMietfahrzeugFuerSelbstfahrer($mietfahrzeugFuerSelbstfahrer = null)
    {
        // validation for constraint: boolean
        if (!is_null($mietfahrzeugFuerSelbstfahrer) && !is_bool($mietfahrzeugFuerSelbstfahrer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mietfahrzeugFuerSelbstfahrer, true), gettype($mietfahrzeugFuerSelbstfahrer)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($mietfahrzeugFuerSelbstfahrer) && !preg_match('/true|false/', $mietfahrzeugFuerSelbstfahrer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($mietfahrzeugFuerSelbstfahrer, true)), __LINE__);
        }
        $this->MietfahrzeugFuerSelbstfahrer = $mietfahrzeugFuerSelbstfahrer;
        return $this;
    }
    /**
     * Get DatumVersicherungsbeginn value
     * @return string|null
     */
    public function getDatumVersicherungsbeginn()
    {
        return $this->DatumVersicherungsbeginn;
    }
    /**
     * Set DatumVersicherungsbeginn value
     * @param string $datumVersicherungsbeginn
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setDatumVersicherungsbeginn($datumVersicherungsbeginn = null)
    {
        // validation for constraint: string
        if (!is_null($datumVersicherungsbeginn) && !is_string($datumVersicherungsbeginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumVersicherungsbeginn, true), gettype($datumVersicherungsbeginn)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($datumVersicherungsbeginn) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $datumVersicherungsbeginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($datumVersicherungsbeginn, true)), __LINE__);
        }
        $this->DatumVersicherungsbeginn = $datumVersicherungsbeginn;
        return $this;
    }
    /**
     * Get HalterAbweichendVonVersicherungsnehmer value
     * @return bool|null
     */
    public function getHalterAbweichendVonVersicherungsnehmer()
    {
        return $this->HalterAbweichendVonVersicherungsnehmer;
    }
    /**
     * Set HalterAbweichendVonVersicherungsnehmer value
     * @param bool $halterAbweichendVonVersicherungsnehmer
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setHalterAbweichendVonVersicherungsnehmer($halterAbweichendVonVersicherungsnehmer = null)
    {
        // validation for constraint: boolean
        if (!is_null($halterAbweichendVonVersicherungsnehmer) && !is_bool($halterAbweichendVonVersicherungsnehmer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($halterAbweichendVonVersicherungsnehmer, true), gettype($halterAbweichendVonVersicherungsnehmer)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($halterAbweichendVonVersicherungsnehmer) && !preg_match('/true|false/', $halterAbweichendVonVersicherungsnehmer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($halterAbweichendVonVersicherungsnehmer, true)), __LINE__);
        }
        $this->HalterAbweichendVonVersicherungsnehmer = $halterAbweichendVonVersicherungsnehmer;
        return $this;
    }
    /**
     * Get VbAusgegebenDurch value
     * @return string|null
     */
    public function getVbAusgegebenDurch()
    {
        return $this->VbAusgegebenDurch;
    }
    /**
     * Set VbAusgegebenDurch value
     * @uses \BiPRO\EnumType\ST_VbAusgegebenDurch::valueIsValid()
     * @uses \BiPRO\EnumType\ST_VbAusgegebenDurch::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vbAusgegebenDurch
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setVbAusgegebenDurch($vbAusgegebenDurch = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_VbAusgegebenDurch::valueIsValid($vbAusgegebenDurch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_VbAusgegebenDurch', is_array($vbAusgegebenDurch) ? implode(', ', $vbAusgegebenDurch) : var_export($vbAusgegebenDurch, true), implode(', ', \BiPRO\EnumType\ST_VbAusgegebenDurch::getValidValues())), __LINE__);
        }
        $this->VbAusgegebenDurch = $vbAusgegebenDurch;
        return $this;
    }
    /**
     * Get Ablaufdatum value
     * @return string|null
     */
    public function getAblaufdatum()
    {
        return $this->Ablaufdatum;
    }
    /**
     * Set Ablaufdatum value
     * @param string $ablaufdatum
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setAblaufdatum($ablaufdatum = null)
    {
        // validation for constraint: string
        if (!is_null($ablaufdatum) && !is_string($ablaufdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ablaufdatum, true), gettype($ablaufdatum)), __LINE__);
        }
        // validation for constraint: pattern(\d{4}\-[0-1][0-9]-[0-3][0-9])
        if (!is_null($ablaufdatum) && !preg_match('/\\d{4}\\-[0-1][0-9]-[0-3][0-9]/', $ablaufdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}\-[0-1][0-9]-[0-3][0-9]', var_export($ablaufdatum, true)), __LINE__);
        }
        $this->Ablaufdatum = $ablaufdatum;
        return $this;
    }
    /**
     * Get KFZFuerBehinderteSchuelerKindergartentraeger value
     * @return bool|null
     */
    public function getKFZFuerBehinderteSchuelerKindergartentraeger()
    {
        return $this->KFZFuerBehinderteSchuelerKindergartentraeger;
    }
    /**
     * Set KFZFuerBehinderteSchuelerKindergartentraeger value
     * @param bool $kFZFuerBehinderteSchuelerKindergartentraeger
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setKFZFuerBehinderteSchuelerKindergartentraeger($kFZFuerBehinderteSchuelerKindergartentraeger = null)
    {
        // validation for constraint: boolean
        if (!is_null($kFZFuerBehinderteSchuelerKindergartentraeger) && !is_bool($kFZFuerBehinderteSchuelerKindergartentraeger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kFZFuerBehinderteSchuelerKindergartentraeger, true), gettype($kFZFuerBehinderteSchuelerKindergartentraeger)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($kFZFuerBehinderteSchuelerKindergartentraeger) && !preg_match('/true|false/', $kFZFuerBehinderteSchuelerKindergartentraeger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($kFZFuerBehinderteSchuelerKindergartentraeger, true)), __LINE__);
        }
        $this->KFZFuerBehinderteSchuelerKindergartentraeger = $kFZFuerBehinderteSchuelerKindergartentraeger;
        return $this;
    }
    /**
     * Get Krankenwagen value
     * @return bool|null
     */
    public function getKrankenwagen()
    {
        return $this->Krankenwagen;
    }
    /**
     * Set Krankenwagen value
     * @param bool $krankenwagen
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setKrankenwagen($krankenwagen = null)
    {
        // validation for constraint: boolean
        if (!is_null($krankenwagen) && !is_bool($krankenwagen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($krankenwagen, true), gettype($krankenwagen)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($krankenwagen) && !preg_match('/true|false/', $krankenwagen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($krankenwagen, true)), __LINE__);
        }
        $this->Krankenwagen = $krankenwagen;
        return $this;
    }
    /**
     * Get Mietfahrzeug value
     * @return bool|null
     */
    public function getMietfahrzeug()
    {
        return $this->Mietfahrzeug;
    }
    /**
     * Set Mietfahrzeug value
     * @param bool $mietfahrzeug
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setMietfahrzeug($mietfahrzeug = null)
    {
        // validation for constraint: boolean
        if (!is_null($mietfahrzeug) && !is_bool($mietfahrzeug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mietfahrzeug, true), gettype($mietfahrzeug)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($mietfahrzeug) && !preg_match('/true|false/', $mietfahrzeug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($mietfahrzeug, true)), __LINE__);
        }
        $this->Mietfahrzeug = $mietfahrzeug;
        return $this;
    }
    /**
     * Get Linienbus value
     * @return bool|null
     */
    public function getLinienbus()
    {
        return $this->Linienbus;
    }
    /**
     * Set Linienbus value
     * @param bool $linienbus
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setLinienbus($linienbus = null)
    {
        // validation for constraint: boolean
        if (!is_null($linienbus) && !is_bool($linienbus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($linienbus, true), gettype($linienbus)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($linienbus) && !preg_match('/true|false/', $linienbus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($linienbus, true)), __LINE__);
        }
        $this->Linienbus = $linienbus;
        return $this;
    }
    /**
     * Get Taxi value
     * @return bool|null
     */
    public function getTaxi()
    {
        return $this->Taxi;
    }
    /**
     * Set Taxi value
     * @param bool $taxi
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setTaxi($taxi = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxi) && !is_bool($taxi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxi, true), gettype($taxi)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($taxi) && !preg_match('/true|false/', $taxi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($taxi, true)), __LINE__);
        }
        $this->Taxi = $taxi;
        return $this;
    }
    /**
     * Get SonstigeBesondereVerwendung value
     * @return bool|null
     */
    public function getSonstigeBesondereVerwendung()
    {
        return $this->SonstigeBesondereVerwendung;
    }
    /**
     * Set SonstigeBesondereVerwendung value
     * @param bool $sonstigeBesondereVerwendung
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setSonstigeBesondereVerwendung($sonstigeBesondereVerwendung = null)
    {
        // validation for constraint: boolean
        if (!is_null($sonstigeBesondereVerwendung) && !is_bool($sonstigeBesondereVerwendung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sonstigeBesondereVerwendung, true), gettype($sonstigeBesondereVerwendung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($sonstigeBesondereVerwendung) && !preg_match('/true|false/', $sonstigeBesondereVerwendung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($sonstigeBesondereVerwendung, true)), __LINE__);
        }
        $this->SonstigeBesondereVerwendung = $sonstigeBesondereVerwendung;
        return $this;
    }
    /**
     * Get OhneBesondereVerwendung value
     * @return bool|null
     */
    public function getOhneBesondereVerwendung()
    {
        return $this->OhneBesondereVerwendung;
    }
    /**
     * Set OhneBesondereVerwendung value
     * @param bool $ohneBesondereVerwendung
     * @return \BiPRO\StructType\CT_VersicherungsbestaetigungKfz
     */
    public function setOhneBesondereVerwendung($ohneBesondereVerwendung = null)
    {
        // validation for constraint: boolean
        if (!is_null($ohneBesondereVerwendung) && !is_bool($ohneBesondereVerwendung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ohneBesondereVerwendung, true), gettype($ohneBesondereVerwendung)), __LINE__);
        }
        // validation for constraint: pattern(true|false)
        if (!is_null($ohneBesondereVerwendung) && !preg_match('/true|false/', $ohneBesondereVerwendung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression true|false', var_export($ohneBesondereVerwendung, true)), __LINE__);
        }
        $this->OhneBesondereVerwendung = $ohneBesondereVerwendung;
        return $this;
    }
}
