<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Versicherungsbestaetigung StructType
 * Meta information extracted from the WSDL
 * - documentation: Diese Klasse definiert sämtliche Bestätigungen an Dritte wie z.B. Sicherungsschein, Pflichtversicherungsbestätigung, Hypothekengläubiger, Bestätigung für Leasinggeber u.s.w
 * @subpackage Structs
 */
class CT_Versicherungsbestaetigung extends CT_Objekt
{
    /**
     * The ArtID
     * Meta information extracted from the WSDL
     * - documentation: Zeigt um welche Art von Versicherungsbestätigung es sich handelt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArtID;
    /**
     * The Aktenzeichen
     * Meta information extracted from the WSDL
     * - documentation: Aktenzeichen der Versicherungsbestätigung.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Aktenzeichen;
    /**
     * The Bestaetigungssumme
     * Meta information extracted from the WSDL
     * - documentation: Referenziert die Bestätigungssumme als Geldwert einer Versicherungsbestätigung.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Bestaetigungssumme
     */
    public $Bestaetigungssumme;
    /**
     * The Bestaetigungsempfaenger
     * Meta information extracted from the WSDL
     * - documentation: Gilt für versicherte Wagnisse.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Bestaetigungsempfaenger
     */
    public $Bestaetigungsempfaenger;
    /**
     * The Sicherungsglaeubiger
     * Meta information extracted from the WSDL
     * - documentation: Gilt für versicherte Objekte
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Sicherungsglaeubiger
     */
    public $Sicherungsglaeubiger;
    /**
     * Constructor method for CT_Versicherungsbestaetigung
     * @uses CT_Versicherungsbestaetigung::setArtID()
     * @uses CT_Versicherungsbestaetigung::setAktenzeichen()
     * @uses CT_Versicherungsbestaetigung::setBestaetigungssumme()
     * @uses CT_Versicherungsbestaetigung::setBestaetigungsempfaenger()
     * @uses CT_Versicherungsbestaetigung::setSicherungsglaeubiger()
     * @param string $artID
     * @param string $aktenzeichen
     * @param \BiPRO\StructType\CT_Bestaetigungssumme $bestaetigungssumme
     * @param \BiPRO\StructType\CT_Bestaetigungsempfaenger $bestaetigungsempfaenger
     * @param \BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger
     */
    public function __construct($artID = null, $aktenzeichen = null, \BiPRO\StructType\CT_Bestaetigungssumme $bestaetigungssumme = null, \BiPRO\StructType\CT_Bestaetigungsempfaenger $bestaetigungsempfaenger = null, \BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger = null)
    {
        $this
            ->setArtID($artID)
            ->setAktenzeichen($aktenzeichen)
            ->setBestaetigungssumme($bestaetigungssumme)
            ->setBestaetigungsempfaenger($bestaetigungsempfaenger)
            ->setSicherungsglaeubiger($sicherungsglaeubiger);
    }
    /**
     * Get ArtID value
     * @return string|null
     */
    public function getArtID()
    {
        return $this->ArtID;
    }
    /**
     * Set ArtID value
     * @uses \BiPRO\EnumType\ST_Versicherungsbestaetigung::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Versicherungsbestaetigung::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $artID
     * @return \BiPRO\StructType\CT_Versicherungsbestaetigung
     */
    public function setArtID($artID = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Versicherungsbestaetigung::valueIsValid($artID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Versicherungsbestaetigung', is_array($artID) ? implode(', ', $artID) : var_export($artID, true), implode(', ', \BiPRO\EnumType\ST_Versicherungsbestaetigung::getValidValues())), __LINE__);
        }
        $this->ArtID = $artID;
        return $this;
    }
    /**
     * Get Aktenzeichen value
     * @return string|null
     */
    public function getAktenzeichen()
    {
        return $this->Aktenzeichen;
    }
    /**
     * Set Aktenzeichen value
     * @param string $aktenzeichen
     * @return \BiPRO\StructType\CT_Versicherungsbestaetigung
     */
    public function setAktenzeichen($aktenzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($aktenzeichen) && !is_string($aktenzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aktenzeichen, true), gettype($aktenzeichen)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aktenzeichen) && mb_strlen($aktenzeichen) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aktenzeichen)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($aktenzeichen) && mb_strlen($aktenzeichen) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($aktenzeichen)), __LINE__);
        }
        $this->Aktenzeichen = $aktenzeichen;
        return $this;
    }
    /**
     * Get Bestaetigungssumme value
     * @return \BiPRO\StructType\CT_Bestaetigungssumme|null
     */
    public function getBestaetigungssumme()
    {
        return $this->Bestaetigungssumme;
    }
    /**
     * Set Bestaetigungssumme value
     * @param \BiPRO\StructType\CT_Bestaetigungssumme $bestaetigungssumme
     * @return \BiPRO\StructType\CT_Versicherungsbestaetigung
     */
    public function setBestaetigungssumme(\BiPRO\StructType\CT_Bestaetigungssumme $bestaetigungssumme = null)
    {
        $this->Bestaetigungssumme = $bestaetigungssumme;
        return $this;
    }
    /**
     * Get Bestaetigungsempfaenger value
     * @return \BiPRO\StructType\CT_Bestaetigungsempfaenger|null
     */
    public function getBestaetigungsempfaenger()
    {
        return $this->Bestaetigungsempfaenger;
    }
    /**
     * Set Bestaetigungsempfaenger value
     * @param \BiPRO\StructType\CT_Bestaetigungsempfaenger $bestaetigungsempfaenger
     * @return \BiPRO\StructType\CT_Versicherungsbestaetigung
     */
    public function setBestaetigungsempfaenger(\BiPRO\StructType\CT_Bestaetigungsempfaenger $bestaetigungsempfaenger = null)
    {
        $this->Bestaetigungsempfaenger = $bestaetigungsempfaenger;
        return $this;
    }
    /**
     * Get Sicherungsglaeubiger value
     * @return \BiPRO\StructType\CT_Sicherungsglaeubiger|null
     */
    public function getSicherungsglaeubiger()
    {
        return $this->Sicherungsglaeubiger;
    }
    /**
     * Set Sicherungsglaeubiger value
     * @param \BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger
     * @return \BiPRO\StructType\CT_Versicherungsbestaetigung
     */
    public function setSicherungsglaeubiger(\BiPRO\StructType\CT_Sicherungsglaeubiger $sicherungsglaeubiger = null)
    {
        $this->Sicherungsglaeubiger = $sicherungsglaeubiger;
        return $this;
    }
}
