<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Unternehmen StructType
 * Meta information extracted from the WSDL
 * - documentation: Daten eines produktgebenden Unternehmens, z.B. Versicherungsunternehmen, Kapitalanlageunternehmen, Bausparunternehmen, gesetzlicher Krankenversicherer.
 * @subpackage Structs
 */
class CT_Unternehmen extends CT_Objekt
{
    /**
     * The Nummer
     * Meta information extracted from the WSDL
     * - documentation: Die Nummer dient der eindeutigen Identifizierung des Unternehmens. Die Art der Nummer wird über das Attribut Nummernart näher spezifiziert. | gemäß Unternehmensdatenbank der BaFin
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Nummer;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Ort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Ort;
    /**
     * The Geschaeftsstelle
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \d{4}
     * @var string
     */
    public $Geschaeftsstelle;
    /**
     * The Nummernart
     * Meta information extracted from the WSDL
     * - documentation: Spezifizierung der Herkunft einer identifizierenden Nummer im Attribut Nummer. Sofern das Attribut keinen Wert enthält handelt es sich bei der identifizierenden Nummer immer um die BaFin-Nummer des Unternehmens.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nummernart;
    /**
     * The PartnerID
     * Meta information extracted from the WSDL
     * - documentation: Referenz auf die eindeutige Identifikationsnummer des Partners im Nachrichtenaustausch. In einigen Kontexten kann es sinnvoll sein, Kommunikationsdaten und Adressen, etc. des Providers zu übertragen. Eine Modellierung des Providers
     * über eine Ableitung von Partnerrolle ist zum Zeitpunkt der Anforderung (04.2009) abwärtsinkompatibel. Aus diesem Grund wurde das Attribut PartnerID als Referenz auf einen im Nachrichtenaustausch gelieferten Partner modelliert. Vergleiche hierzu
     * auch Vermittler.PartnerID. | Typ fuer alle IDs.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerID;
    /**
     * Constructor method for CT_Unternehmen
     * @uses CT_Unternehmen::setNummer()
     * @uses CT_Unternehmen::setName()
     * @uses CT_Unternehmen::setOrt()
     * @uses CT_Unternehmen::setGeschaeftsstelle()
     * @uses CT_Unternehmen::setNummernart()
     * @uses CT_Unternehmen::setPartnerID()
     * @param string $nummer
     * @param string $name
     * @param string $ort
     * @param string $geschaeftsstelle
     * @param string $nummernart
     * @param string $partnerID
     */
    public function __construct($nummer = null, $name = null, $ort = null, $geschaeftsstelle = null, $nummernart = null, $partnerID = null)
    {
        $this
            ->setNummer($nummer)
            ->setName($name)
            ->setOrt($ort)
            ->setGeschaeftsstelle($geschaeftsstelle)
            ->setNummernart($nummernart)
            ->setPartnerID($partnerID);
    }
    /**
     * Get Nummer value
     * @return string|null
     */
    public function getNummer()
    {
        return $this->Nummer;
    }
    /**
     * Set Nummer value
     * @param string $nummer
     * @return \BiPRO\StructType\CT_Unternehmen
     */
    public function setNummer($nummer = null)
    {
        // validation for constraint: string
        if (!is_null($nummer) && !is_string($nummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nummer, true), gettype($nummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($nummer) && mb_strlen($nummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($nummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nummer) && mb_strlen($nummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nummer)), __LINE__);
        }
        $this->Nummer = $nummer;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \BiPRO\StructType\CT_Unternehmen
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($name) && mb_strlen($name) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name) && mb_strlen($name) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->Ort;
    }
    /**
     * Set Ort value
     * @param string $ort
     * @return \BiPRO\StructType\CT_Unternehmen
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ort) && mb_strlen($ort) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($ort)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ort) && mb_strlen($ort) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ort)), __LINE__);
        }
        $this->Ort = $ort;
        return $this;
    }
    /**
     * Get Geschaeftsstelle value
     * @return string|null
     */
    public function getGeschaeftsstelle()
    {
        return $this->Geschaeftsstelle;
    }
    /**
     * Set Geschaeftsstelle value
     * @param string $geschaeftsstelle
     * @return \BiPRO\StructType\CT_Unternehmen
     */
    public function setGeschaeftsstelle($geschaeftsstelle = null)
    {
        // validation for constraint: string
        if (!is_null($geschaeftsstelle) && !is_string($geschaeftsstelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geschaeftsstelle, true), gettype($geschaeftsstelle)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!is_null($geschaeftsstelle) && !preg_match('/\\d{4}/', $geschaeftsstelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($geschaeftsstelle, true)), __LINE__);
        }
        $this->Geschaeftsstelle = $geschaeftsstelle;
        return $this;
    }
    /**
     * Get Nummernart value
     * @return string|null
     */
    public function getNummernart()
    {
        return $this->Nummernart;
    }
    /**
     * Set Nummernart value
     * @uses \BiPRO\EnumType\ST_Unternehmensnummernart::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Unternehmensnummernart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nummernart
     * @return \BiPRO\StructType\CT_Unternehmen
     */
    public function setNummernart($nummernart = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Unternehmensnummernart::valueIsValid($nummernart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Unternehmensnummernart', is_array($nummernart) ? implode(', ', $nummernart) : var_export($nummernart, true), implode(', ', \BiPRO\EnumType\ST_Unternehmensnummernart::getValidValues())), __LINE__);
        }
        $this->Nummernart = $nummernart;
        return $this;
    }
    /**
     * Get PartnerID value
     * @return string|null
     */
    public function getPartnerID()
    {
        return $this->PartnerID;
    }
    /**
     * Set PartnerID value
     * @param string $partnerID
     * @return \BiPRO\StructType\CT_Unternehmen
     */
    public function setPartnerID($partnerID = null)
    {
        // validation for constraint: string
        if (!is_null($partnerID) && !is_string($partnerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerID, true), gettype($partnerID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partnerID) && mb_strlen($partnerID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partnerID)), __LINE__);
        }
        $this->PartnerID = $partnerID;
        return $this;
    }
}
