<?php

namespace BiPRO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CT_Transport StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasse zur Beschreibung von Gütern (z. B. Schüttgut oder Stückgut) während eines Transportes.
 * @subpackage Structs
 */
class CT_Transport extends CT_Gegenstand
{
    /**
     * The TransportmittelSchluessel
     * Meta information extracted from the WSDL
     * - documentation: Angabe, um welche Art von Transportmittel es sich handelt (in Anlehnung an GDV Anlage 57). Kann mehrfach verwendet werden, um multimodale Transporte abbilden zu können.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TransportmittelSchluessel;
    /**
     * The Transportmittel
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung des Transportmittels (z.B. Bahn, Flugzeug, aber auch Schiffsname)
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Transportmittel;
    /**
     * The Route
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Transportroute: von … über ... nach
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Route;
    /**
     * The Besonderheiten
     * Meta information extracted from the WSDL
     * - documentation: Da es sich hierbei um hoch individuelle Ausprägungen für den einzelnen Transport handelt, wird dies als Text abgebildet. (z. B. Zwischenlagerzeit für eine bestimmte Route auf Grund besondere Einflüsse 4 anstelle von 2 Tagen)
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Besonderheiten;
    /**
     * The Zertifikatsnummer
     * Meta information extracted from the WSDL
     * - documentation: Zertifikatsnummer der Ware
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Zertifikatsnummer;
    /**
     * The Warenbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Klartext der Warenbezeichnung
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Warenbezeichnung;
    /**
     * The Menge
     * Meta information extracted from the WSDL
     * - documentation: Mengenangabe speziell für Transport z.B. 4 Paletten, 3 Container
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Menge;
    /**
     * The Verpackungsart
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der Verpackung der Ware (z.B. verschweißt)
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Verpackungsart;
    /**
     * The Signatur
     * Meta information extracted from the WSDL
     * - documentation: "Elektronische" Signatur zur eindeutigen Identifizierung der Ware (z.B. Trackingnummer)
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $Signatur;
    /**
     * The Zeitraum
     * Meta information extracted from the WSDL
     * - documentation: Zeitraum um den Beginn und das Ende des Transportes festzulegen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Zeitraum
     */
    public $Zeitraum;
    /**
     * The Gewicht
     * Meta information extracted from the WSDL
     * - documentation: Gewicht der transportierten Ware in Kilogramm.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Gewicht;
    /**
     * The Incoterms
     * Meta information extracted from the WSDL
     * - documentation: Internationale Handelsklauseln der Internationalen Handelskammer (International Chamber of Commerce, ICC)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Incoterms;
    /**
     * The Haftungsgrundlage
     * Meta information extracted from the WSDL
     * - documentation: Haftungsgrundlage des Transports
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Haftungsgrundlage;
    /**
     * The Empfaenger
     * Meta information extracted from the WSDL
     * - documentation: Empfänger des Transports
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Empfaenger
     */
    public $Empfaenger;
    /**
     * The Bestimmungsort
     * Meta information extracted from the WSDL
     * - documentation: Der Bestimmungsort des Transports kann zusätzlich oder alternativ zur Route angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Bestimmungsort
     */
    public $Bestimmungsort;
    /**
     * The Absender
     * Meta information extracted from the WSDL
     * - documentation: Absender des Transports
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Absender
     */
    public $Absender;
    /**
     * The Abgangsort
     * Meta information extracted from the WSDL
     * - documentation: Der Abgangsort des Transports kann zusätzlich oder alternativ zur Route angegeben werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \BiPRO\StructType\CT_Abgangsort
     */
    public $Abgangsort;
    /**
     * Constructor method for CT_Transport
     * @uses CT_Transport::setTransportmittelSchluessel()
     * @uses CT_Transport::setTransportmittel()
     * @uses CT_Transport::setRoute()
     * @uses CT_Transport::setBesonderheiten()
     * @uses CT_Transport::setZertifikatsnummer()
     * @uses CT_Transport::setWarenbezeichnung()
     * @uses CT_Transport::setMenge()
     * @uses CT_Transport::setVerpackungsart()
     * @uses CT_Transport::setSignatur()
     * @uses CT_Transport::setZeitraum()
     * @uses CT_Transport::setGewicht()
     * @uses CT_Transport::setIncoterms()
     * @uses CT_Transport::setHaftungsgrundlage()
     * @uses CT_Transport::setEmpfaenger()
     * @uses CT_Transport::setBestimmungsort()
     * @uses CT_Transport::setAbsender()
     * @uses CT_Transport::setAbgangsort()
     * @param string[] $transportmittelSchluessel
     * @param string $transportmittel
     * @param string $route
     * @param string $besonderheiten
     * @param string $zertifikatsnummer
     * @param string $warenbezeichnung
     * @param string $menge
     * @param string $verpackungsart
     * @param string $signatur
     * @param \BiPRO\StructType\CT_Zeitraum $zeitraum
     * @param float $gewicht
     * @param string $incoterms
     * @param string $haftungsgrundlage
     * @param \BiPRO\StructType\CT_Empfaenger $empfaenger
     * @param \BiPRO\StructType\CT_Bestimmungsort $bestimmungsort
     * @param \BiPRO\StructType\CT_Absender $absender
     * @param \BiPRO\StructType\CT_Abgangsort $abgangsort
     */
    public function __construct(array $transportmittelSchluessel = array(), $transportmittel = null, $route = null, $besonderheiten = null, $zertifikatsnummer = null, $warenbezeichnung = null, $menge = null, $verpackungsart = null, $signatur = null, \BiPRO\StructType\CT_Zeitraum $zeitraum = null, $gewicht = null, $incoterms = null, $haftungsgrundlage = null, \BiPRO\StructType\CT_Empfaenger $empfaenger = null, \BiPRO\StructType\CT_Bestimmungsort $bestimmungsort = null, \BiPRO\StructType\CT_Absender $absender = null, \BiPRO\StructType\CT_Abgangsort $abgangsort = null)
    {
        $this
            ->setTransportmittelSchluessel($transportmittelSchluessel)
            ->setTransportmittel($transportmittel)
            ->setRoute($route)
            ->setBesonderheiten($besonderheiten)
            ->setZertifikatsnummer($zertifikatsnummer)
            ->setWarenbezeichnung($warenbezeichnung)
            ->setMenge($menge)
            ->setVerpackungsart($verpackungsart)
            ->setSignatur($signatur)
            ->setZeitraum($zeitraum)
            ->setGewicht($gewicht)
            ->setIncoterms($incoterms)
            ->setHaftungsgrundlage($haftungsgrundlage)
            ->setEmpfaenger($empfaenger)
            ->setBestimmungsort($bestimmungsort)
            ->setAbsender($absender)
            ->setAbgangsort($abgangsort);
    }
    /**
     * Get TransportmittelSchluessel value
     * @return string[]|null
     */
    public function getTransportmittelSchluessel()
    {
        return $this->TransportmittelSchluessel;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportmittelSchluessel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportmittelSchluessel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportmittelSchluesselForArrayConstraintsFromSetTransportmittelSchluessel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cT_TransportTransportmittelSchluesselItem) {
            // validation for constraint: enumeration
            if (!\BiPRO\EnumType\ST_TransportmittelSchluessel::valueIsValid($cT_TransportTransportmittelSchluesselItem)) {
                $invalidValues[] = is_object($cT_TransportTransportmittelSchluesselItem) ? get_class($cT_TransportTransportmittelSchluesselItem) : sprintf('%s(%s)', gettype($cT_TransportTransportmittelSchluesselItem), var_export($cT_TransportTransportmittelSchluesselItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_TransportmittelSchluessel', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \BiPRO\EnumType\ST_TransportmittelSchluessel::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransportmittelSchluessel value
     * @uses \BiPRO\EnumType\ST_TransportmittelSchluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_TransportmittelSchluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $transportmittelSchluessel
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setTransportmittelSchluessel(array $transportmittelSchluessel = array())
    {
        // validation for constraint: array
        if ('' !== ($transportmittelSchluesselArrayErrorMessage = self::validateTransportmittelSchluesselForArrayConstraintsFromSetTransportmittelSchluessel($transportmittelSchluessel))) {
            throw new \InvalidArgumentException($transportmittelSchluesselArrayErrorMessage, __LINE__);
        }
        $this->TransportmittelSchluessel = $transportmittelSchluessel;
        return $this;
    }
    /**
     * Add item to TransportmittelSchluessel value
     * @uses \BiPRO\EnumType\ST_TransportmittelSchluessel::valueIsValid()
     * @uses \BiPRO\EnumType\ST_TransportmittelSchluessel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \BiPRO\StructType\CT_Transport
     */
    public function addToTransportmittelSchluessel($item)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_TransportmittelSchluessel::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_TransportmittelSchluessel', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \BiPRO\EnumType\ST_TransportmittelSchluessel::getValidValues())), __LINE__);
        }
        $this->TransportmittelSchluessel[] = $item;
        return $this;
    }
    /**
     * Get Transportmittel value
     * @return string|null
     */
    public function getTransportmittel()
    {
        return $this->Transportmittel;
    }
    /**
     * Set Transportmittel value
     * @param string $transportmittel
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setTransportmittel($transportmittel = null)
    {
        // validation for constraint: string
        if (!is_null($transportmittel) && !is_string($transportmittel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportmittel, true), gettype($transportmittel)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($transportmittel) && mb_strlen($transportmittel) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($transportmittel)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($transportmittel) && mb_strlen($transportmittel) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($transportmittel)), __LINE__);
        }
        $this->Transportmittel = $transportmittel;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @param string $route
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setRoute($route = null)
    {
        // validation for constraint: string
        if (!is_null($route) && !is_string($route)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($route, true), gettype($route)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($route) && mb_strlen($route) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($route)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($route) && mb_strlen($route) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($route)), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Get Besonderheiten value
     * @return string|null
     */
    public function getBesonderheiten()
    {
        return $this->Besonderheiten;
    }
    /**
     * Set Besonderheiten value
     * @param string $besonderheiten
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setBesonderheiten($besonderheiten = null)
    {
        // validation for constraint: string
        if (!is_null($besonderheiten) && !is_string($besonderheiten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($besonderheiten, true), gettype($besonderheiten)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($besonderheiten) && mb_strlen($besonderheiten) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($besonderheiten)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($besonderheiten) && mb_strlen($besonderheiten) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($besonderheiten)), __LINE__);
        }
        $this->Besonderheiten = $besonderheiten;
        return $this;
    }
    /**
     * Get Zertifikatsnummer value
     * @return string|null
     */
    public function getZertifikatsnummer()
    {
        return $this->Zertifikatsnummer;
    }
    /**
     * Set Zertifikatsnummer value
     * @param string $zertifikatsnummer
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setZertifikatsnummer($zertifikatsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($zertifikatsnummer) && !is_string($zertifikatsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zertifikatsnummer, true), gettype($zertifikatsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($zertifikatsnummer) && mb_strlen($zertifikatsnummer) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($zertifikatsnummer)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($zertifikatsnummer) && mb_strlen($zertifikatsnummer) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($zertifikatsnummer)), __LINE__);
        }
        $this->Zertifikatsnummer = $zertifikatsnummer;
        return $this;
    }
    /**
     * Get Warenbezeichnung value
     * @return string|null
     */
    public function getWarenbezeichnung()
    {
        return $this->Warenbezeichnung;
    }
    /**
     * Set Warenbezeichnung value
     * @param string $warenbezeichnung
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setWarenbezeichnung($warenbezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($warenbezeichnung) && !is_string($warenbezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warenbezeichnung, true), gettype($warenbezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($warenbezeichnung) && mb_strlen($warenbezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($warenbezeichnung)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($warenbezeichnung) && mb_strlen($warenbezeichnung) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($warenbezeichnung)), __LINE__);
        }
        $this->Warenbezeichnung = $warenbezeichnung;
        return $this;
    }
    /**
     * Get Menge value
     * @return string|null
     */
    public function getMenge()
    {
        return $this->Menge;
    }
    /**
     * Set Menge value
     * @param string $menge
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setMenge($menge = null)
    {
        // validation for constraint: string
        if (!is_null($menge) && !is_string($menge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($menge, true), gettype($menge)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($menge) && mb_strlen($menge) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($menge)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($menge) && mb_strlen($menge) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($menge)), __LINE__);
        }
        $this->Menge = $menge;
        return $this;
    }
    /**
     * Get Verpackungsart value
     * @return string|null
     */
    public function getVerpackungsart()
    {
        return $this->Verpackungsart;
    }
    /**
     * Set Verpackungsart value
     * @param string $verpackungsart
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setVerpackungsart($verpackungsart = null)
    {
        // validation for constraint: string
        if (!is_null($verpackungsart) && !is_string($verpackungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verpackungsart, true), gettype($verpackungsart)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($verpackungsart) && mb_strlen($verpackungsart) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($verpackungsart)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($verpackungsart) && mb_strlen($verpackungsart) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($verpackungsart)), __LINE__);
        }
        $this->Verpackungsart = $verpackungsart;
        return $this;
    }
    /**
     * Get Signatur value
     * @return string|null
     */
    public function getSignatur()
    {
        return $this->Signatur;
    }
    /**
     * Set Signatur value
     * @param string $signatur
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setSignatur($signatur = null)
    {
        // validation for constraint: string
        if (!is_null($signatur) && !is_string($signatur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatur, true), gettype($signatur)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($signatur) && mb_strlen($signatur) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($signatur)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($signatur) && mb_strlen($signatur) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($signatur)), __LINE__);
        }
        $this->Signatur = $signatur;
        return $this;
    }
    /**
     * Get Zeitraum value
     * @return \BiPRO\StructType\CT_Zeitraum|null
     */
    public function getZeitraum()
    {
        return $this->Zeitraum;
    }
    /**
     * Set Zeitraum value
     * @param \BiPRO\StructType\CT_Zeitraum $zeitraum
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setZeitraum(\BiPRO\StructType\CT_Zeitraum $zeitraum = null)
    {
        $this->Zeitraum = $zeitraum;
        return $this;
    }
    /**
     * Get Gewicht value
     * @return float|null
     */
    public function getGewicht()
    {
        return $this->Gewicht;
    }
    /**
     * Set Gewicht value
     * @param float $gewicht
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setGewicht($gewicht = null)
    {
        // validation for constraint: float
        if (!is_null($gewicht) && !(is_float($gewicht) || is_numeric($gewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gewicht, true), gettype($gewicht)), __LINE__);
        }
        $this->Gewicht = $gewicht;
        return $this;
    }
    /**
     * Get Incoterms value
     * @return string|null
     */
    public function getIncoterms()
    {
        return $this->Incoterms;
    }
    /**
     * Set Incoterms value
     * @uses \BiPRO\EnumType\ST_Incoterms::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Incoterms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $incoterms
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setIncoterms($incoterms = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Incoterms::valueIsValid($incoterms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Incoterms', is_array($incoterms) ? implode(', ', $incoterms) : var_export($incoterms, true), implode(', ', \BiPRO\EnumType\ST_Incoterms::getValidValues())), __LINE__);
        }
        $this->Incoterms = $incoterms;
        return $this;
    }
    /**
     * Get Haftungsgrundlage value
     * @return string|null
     */
    public function getHaftungsgrundlage()
    {
        return $this->Haftungsgrundlage;
    }
    /**
     * Set Haftungsgrundlage value
     * @uses \BiPRO\EnumType\ST_Haftungsgrundlage::valueIsValid()
     * @uses \BiPRO\EnumType\ST_Haftungsgrundlage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $haftungsgrundlage
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setHaftungsgrundlage($haftungsgrundlage = null)
    {
        // validation for constraint: enumeration
        if (!\BiPRO\EnumType\ST_Haftungsgrundlage::valueIsValid($haftungsgrundlage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \BiPRO\EnumType\ST_Haftungsgrundlage', is_array($haftungsgrundlage) ? implode(', ', $haftungsgrundlage) : var_export($haftungsgrundlage, true), implode(', ', \BiPRO\EnumType\ST_Haftungsgrundlage::getValidValues())), __LINE__);
        }
        $this->Haftungsgrundlage = $haftungsgrundlage;
        return $this;
    }
    /**
     * Get Empfaenger value
     * @return \BiPRO\StructType\CT_Empfaenger|null
     */
    public function getEmpfaenger()
    {
        return $this->Empfaenger;
    }
    /**
     * Set Empfaenger value
     * @param \BiPRO\StructType\CT_Empfaenger $empfaenger
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setEmpfaenger(\BiPRO\StructType\CT_Empfaenger $empfaenger = null)
    {
        $this->Empfaenger = $empfaenger;
        return $this;
    }
    /**
     * Get Bestimmungsort value
     * @return \BiPRO\StructType\CT_Bestimmungsort|null
     */
    public function getBestimmungsort()
    {
        return $this->Bestimmungsort;
    }
    /**
     * Set Bestimmungsort value
     * @param \BiPRO\StructType\CT_Bestimmungsort $bestimmungsort
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setBestimmungsort(\BiPRO\StructType\CT_Bestimmungsort $bestimmungsort = null)
    {
        $this->Bestimmungsort = $bestimmungsort;
        return $this;
    }
    /**
     * Get Absender value
     * @return \BiPRO\StructType\CT_Absender|null
     */
    public function getAbsender()
    {
        return $this->Absender;
    }
    /**
     * Set Absender value
     * @param \BiPRO\StructType\CT_Absender $absender
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setAbsender(\BiPRO\StructType\CT_Absender $absender = null)
    {
        $this->Absender = $absender;
        return $this;
    }
    /**
     * Get Abgangsort value
     * @return \BiPRO\StructType\CT_Abgangsort|null
     */
    public function getAbgangsort()
    {
        return $this->Abgangsort;
    }
    /**
     * Set Abgangsort value
     * @param \BiPRO\StructType\CT_Abgangsort $abgangsort
     * @return \BiPRO\StructType\CT_Transport
     */
    public function setAbgangsort(\BiPRO\StructType\CT_Abgangsort $abgangsort = null)
    {
        $this->Abgangsort = $abgangsort;
        return $this;
    }
}
